/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.base;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.kinetics.KineticDebugger;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class KineticBlockEntityRenderer<T extends KineticBlockEntity, S extends KineticRenderState>
implements BlockEntityRenderer<T, S> {
    public static final SuperByteBufferCache.Compartment<BlockState> KINETIC_BLOCK = new SuperByteBufferCache.Compartment();
    public static boolean rainbowMode = false;

    public KineticBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
    }

    public S createRenderState() {
        return (S)((Object)new KineticRenderState());
    }

    public void extractRenderState(T be, S state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        Level world = be.getLevel();
        ((KineticRenderState)((Object)state)).support = VisualizationManager.supportsVisualization((LevelAccessor)world);
        if (((KineticRenderState)((Object)state)).support) {
            return;
        }
        this.updateBaseRenderState(be, state, world, crumblingOverlay);
        ((KineticRenderState)((Object)state)).model = this.getRotatedModel(be, state);
        ((KineticRenderState)((Object)state)).angle = KineticBlockEntityRenderer.getAngleForBe(be, ((KineticRenderState)((Object)state)).blockPos, ((KineticRenderState)((Object)state)).axis);
    }

    public void updateBaseRenderState(T be, S state, Level world, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        ((KineticRenderState)((Object)state)).blockPos = be.getBlockPos();
        ((KineticRenderState)((Object)state)).blockState = this.getRenderedBlockState(be);
        ((KineticRenderState)((Object)state)).blockEntityType = be.getType();
        ((KineticRenderState)((Object)state)).lightCoords = world != null ? LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)((KineticRenderState)((Object)state)).blockPos) : 0xF000F0;
        ((KineticRenderState)((Object)state)).breakProgress = crumblingOverlay;
        ((KineticRenderState)((Object)state)).layer = this.getRenderType(be, ((KineticRenderState)((Object)state)).blockState);
        ((KineticRenderState)((Object)state)).axis = ((IRotate)((KineticRenderState)((Object)state)).blockState.getBlock()).getRotationAxis(((KineticRenderState)((Object)state)).blockState);
        ((KineticRenderState)((Object)state)).direction = Direction.fromAxisAndDirection((Direction.Axis)((KineticRenderState)((Object)state)).axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        ((KineticRenderState)((Object)state)).color = KineticBlockEntityRenderer.getColor(be);
    }

    public void submit(S state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (((KineticRenderState)((Object)state)).support) {
            return;
        }
        queue.submitCustomGeometry(matrices, ((KineticRenderState)((Object)state)).layer, state);
    }

    protected BlockState getRenderedBlockState(T be) {
        return be.getBlockState();
    }

    protected RenderType getRenderType(T be, BlockState state) {
        return ItemBlockRenderTypes.getMovingBlockRenderType((BlockState)state);
    }

    protected SuperByteBuffer getRotatedModel(T be, S state) {
        return CachedBuffers.block(KINETIC_BLOCK, ((KineticRenderState)((Object)state)).blockState);
    }

    public static float getAngleForBe(KineticBlockEntity be, BlockPos pos, Direction.Axis axis) {
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        float offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, axis);
        return (time * be.getSpeed() * 3.0f / 10.0f + offset) % 360.0f / 180.0f * (float)Math.PI;
    }

    public static Color getColor(KineticBlockEntity be) {
        if (KineticDebugger.isActive()) {
            rainbowMode = true;
            return be.network != null ? Color.generateFromLong(be.network) : Color.WHITE;
        }
        float overStressedEffect = be.effects.overStressedEffect;
        if (overStressedEffect != 0.0f) {
            boolean overstressed = overStressedEffect > 0.0f;
            Color color = overstressed ? Color.RED : Color.SPRING_GREEN;
            float weight = overstressed ? overStressedEffect : -overStressedEffect;
            return Color.WHITE.mixWith(color, weight);
        }
        return Color.WHITE;
    }

    public static float getRotationOffsetForPosition(KineticBlockEntity be, BlockPos pos, Direction.Axis axis) {
        return KineticBlockEntityVisual.rotationOffset(be.getBlockState(), axis, (Vec3i)pos) + (float)be.getRotationAngleOffset(axis);
    }

    public static BlockState shaft(Direction.Axis axis) {
        return (BlockState)AllBlocks.SHAFT.defaultBlockState().setValue((Property)BlockStateProperties.AXIS, (Comparable)axis);
    }

    public static Direction.Axis getRotationAxisOf(KineticBlockEntity be) {
        return ((IRotate)be.getBlockState().getBlock()).getRotationAxis(be.getBlockState());
    }

    public static class KineticRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public boolean support;
        public RenderType layer;
        public SuperByteBuffer model;
        public float angle;
        public Direction.Axis axis;
        public Direction direction;
        public Color color;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.model.light(this.lightCoords);
            this.model.rotateCentered(this.angle, this.direction);
            this.model.color(this.color);
            this.model.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

