/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.base;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.model.Model;
import com.zurrtum.create.client.flywheel.api.visual.BlockEntityVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.visualization.SimpleBlockEntityVisualizer;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlock;
import com.zurrtum.create.content.kinetics.gantry.GantryShaftBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class OrientedRotatingVisual<T extends KineticBlockEntity>
extends KineticBlockEntityVisual<T> {
    protected final RotatingInstance rotatingModel;

    public OrientedRotatingVisual(VisualizationContext context, T blockEntity, float partialTick, Direction from, Direction to, Model model) {
        super(context, blockEntity, partialTick);
        this.rotatingModel = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, model).createInstance().rotateToFace(from, to).setup((KineticBlockEntity)blockEntity).setPosition((Vec3i)this.getVisualPosition());
        this.rotatingModel.setChanged();
    }

    public static <T extends KineticBlockEntity> SimpleBlockEntityVisualizer.Factory<T> of(PartialModel partial) {
        return (context, blockEntity, partialTick) -> {
            Direction facing = (Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.FACING);
            return new OrientedRotatingVisual<KineticBlockEntity>(context, (KineticBlockEntity)blockEntity, partialTick, Direction.SOUTH, facing, Models.partial(partial));
        };
    }

    public static <T extends KineticBlockEntity> SimpleBlockEntityVisualizer.Factory<T> backHorizontal(PartialModel partial) {
        return (context, blockEntity, partialTick) -> {
            Direction facing = ((Direction)blockEntity.getBlockState().getValue((Property)BlockStateProperties.HORIZONTAL_FACING)).getOpposite();
            return new OrientedRotatingVisual<KineticBlockEntity>(context, (KineticBlockEntity)blockEntity, partialTick, Direction.SOUTH, facing, Models.partial(partial));
        };
    }

    public static BlockEntityVisual<? super GantryShaftBlockEntity> gantryShaft(VisualizationContext visualizationContext, GantryShaftBlockEntity gantryShaftBlockEntity, float partialTick) {
        BlockState blockState = gantryShaftBlockEntity.getBlockState();
        GantryShaftBlock.Part part = (GantryShaftBlock.Part)((Object)blockState.getValue(GantryShaftBlock.PART));
        boolean isPowered = (Boolean)blockState.getValue((Property)GantryShaftBlock.POWERED);
        boolean isFlipped = ((Direction)blockState.getValue((Property)GantryShaftBlock.FACING)).getAxisDirection() == Direction.AxisDirection.NEGATIVE;
        Model model = Models.partial(AllPartialModels.GANTRY_SHAFTS.get(new AllPartialModels.GantryShaftKey(part, isPowered, isFlipped)));
        return new OrientedRotatingVisual<GantryShaftBlockEntity>(visualizationContext, gantryShaftBlockEntity, partialTick, Direction.UP, (Direction)blockState.getValue((Property)GantryShaftBlock.FACING), model);
    }

    @Override
    public void update(float pt) {
        this.rotatingModel.setup((KineticBlockEntity)this.blockEntity).setChanged();
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.rotatingModel);
    }

    @Override
    protected void _delete() {
        this.rotatingModel.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(this.rotatingModel);
    }
}

