/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.belt;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.levelWrappers.WrappedLevel;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.render.ShadowRenderHelper;
import com.zurrtum.create.client.ponder.api.level.PonderLevel;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.belt.BeltBlock;
import com.zurrtum.create.content.kinetics.belt.BeltBlockEntity;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.BeltPart;
import com.zurrtum.create.content.kinetics.belt.BeltSlope;
import com.zurrtum.create.content.kinetics.belt.transport.BeltInventory;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class BeltRenderer
implements BlockEntityRenderer<BeltBlockEntity, BeltRenderState> {
    protected final ItemModelResolver itemModelManager;

    public BeltRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public BeltRenderState createRenderState() {
        return new BeltRenderState();
    }

    public void extractRenderState(BeltBlockEntity be, BeltRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        Level world = be.getLevel();
        float speed = be.getSpeed();
        boolean stopped = speed == 0.0f;
        boolean bl = state.render = !VisualizationManager.supportsVisualization((LevelAccessor)world) && state.blockState.is((Block)AllBlocks.BELT);
        if (state.render) {
            BeltSlope beltSlope = (BeltSlope)((Object)state.blockState.getValue(BeltBlock.SLOPE));
            BeltPart part = (BeltPart)((Object)state.blockState.getValue(BeltBlock.PART));
            Direction facing = (Direction)state.blockState.getValue((Property)BeltBlock.HORIZONTAL_FACING);
            Direction.AxisDirection axisDirection = facing.getAxisDirection();
            boolean downward = beltSlope == BeltSlope.DOWNWARD;
            boolean upward = beltSlope == BeltSlope.UPWARD;
            boolean diagonal = downward || upward;
            boolean start = part == BeltPart.START;
            boolean end = part == BeltPart.END;
            boolean sideways = beltSlope == BeltSlope.SIDEWAYS;
            boolean alongX = facing.getAxis() == Direction.Axis.X;
            state.localTransforms = new PoseStack();
            PoseTransformStack msr = TransformStack.of(state.localTransforms);
            state.layer = RenderTypes.solidMovingBlock();
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)msr.center()).rotateYDegrees(AngleHelper.horizontalAngle(facing) + (float)(upward ? 180 : 0) + (float)(sideways ? 270 : 0))).rotateZDegrees(sideways ? 90.0f : 0.0f)).rotateXDegrees(!diagonal && beltSlope != BeltSlope.HORIZONTAL ? 90.0f : 0.0f)).uncenter();
            if (downward || beltSlope == BeltSlope.VERTICAL && axisDirection == Direction.AxisDirection.POSITIVE) {
                boolean b = start;
                start = end;
                end = b;
            }
            DyeColor color = be.color.orElse(null);
            state.top = CachedBuffers.partial(BeltRenderer.getBeltPartial(diagonal, start, end, false), state.blockState);
            boolean needScroll = !stopped || color != null;
            double scroll = 0.0;
            if (needScroll) {
                float time = AnimationTickHolder.getRenderTime((LevelAccessor)world) * (float)axisDirection.getStep();
                if (diagonal && downward ^ alongX || !sideways && !diagonal && alongX || sideways && axisDirection == Direction.AxisDirection.NEGATIVE) {
                    speed = -speed;
                }
                scroll = (double)(speed * time) / 504.0;
                float scrollMult = diagonal ? 0.375f : 0.5f;
                state.topShift = BeltRenderer.getSpriteShiftEntry(color, diagonal, false);
                TextureAtlasSprite target = state.topShift.getTarget();
                float spriteSize = target.getV1() - target.getV0();
                state.topScroll = (float)((scroll - Math.floor(scroll)) * (double)spriteSize * (double)scrollMult);
            }
            if (!diagonal) {
                state.bottom = CachedBuffers.partial(BeltRenderer.getBeltPartial(false, start, end, true), state.blockState);
                if (needScroll) {
                    state.bottomShift = BeltRenderer.getSpriteShiftEntry(color, false, true);
                    TextureAtlasSprite target = state.bottomShift.getTarget();
                    float spriteSize = target.getV1() - target.getV0();
                    state.bottomScroll = (float)(((scroll += 0.5) - Math.floor(scroll)) * (double)spriteSize * 0.5);
                }
            }
            if (be.hasPulley()) {
                Direction dir = sideways ? Direction.UP : facing.getClockWise();
                Supplier<PoseStack> matrixStackSupplier = () -> {
                    PoseStack stack = new PoseStack();
                    PoseTransformStack stacker = TransformStack.of(stack);
                    stacker.center();
                    if (dir.getAxis() == Direction.Axis.X) {
                        stacker.rotateYDegrees(90.0f);
                    }
                    if (dir.getAxis() == Direction.Axis.Y) {
                        stacker.rotateXDegrees(90.0f);
                    }
                    stacker.rotateXDegrees(90.0f);
                    stacker.uncenter();
                    return stack;
                };
                state.pulley = CachedBuffers.partialDirectional(AllPartialModels.BELT_PULLEY, state.blockState, dir, matrixStackSupplier);
                Direction.Axis axis = ((IRotate)state.blockState.getBlock()).getRotationAxis(state.blockState);
                state.pulleyAngle = KineticBlockEntityRenderer.getAngleForBe(be, state.blockPos, axis);
                state.pulleyDirection = Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis);
                state.pulleyColor = KineticBlockEntityRenderer.getColor(be);
            }
        }
        int n = state.beltLength = be.isController() ? be.beltLength : 0;
        if (state.beltLength != 0) {
            BeltInventory inventory = be.getInventory();
            List<TransportedItemStack> transportedItems = inventory.getTransportedItems();
            TransportedItemStack lazyClientItem = inventory.getLazyClientItem();
            int transportedSize = transportedItems.size();
            if (transportedSize == 0 && lazyClientItem == null) {
                state.beltLength = 0;
                return;
            }
            BeltItemState[] items = new BeltItemState[lazyClientItem == null ? transportedSize : transportedSize + 1];
            state.items = items;
            state.beltFacing = be.getBeltFacing();
            state.directionVec = state.beltFacing.getUnitVec3i();
            state.beltStartOffset = Vec3.atLowerCornerOf((Vec3i)state.directionVec).scale(-0.5).add(0.5, 0.9375, 0.5);
            state.slope = (BeltSlope)((Object)state.blockState.getValue(BeltBlock.SLOPE));
            state.verticality = state.slope == BeltSlope.DOWNWARD ? -1 : (state.slope == BeltSlope.UPWARD ? 1 : 0);
            state.slopeAlongX = state.beltFacing.getAxis() == Direction.Axis.X;
            state.partialTicks = tickProgress;
            state.camera = cameraPos;
            state.onContraption = world instanceof WrappedLevel;
            state.onPonder = world instanceof PonderLevel;
            BlockPos.MutableBlockPos mutablePos = new BlockPos.MutableBlockPos();
            for (int i = 0; i < transportedSize; ++i) {
                items[i] = BeltItemState.create(this.itemModelManager, transportedItems.get(i), state, stopped, world, mutablePos);
            }
            if (lazyClientItem != null) {
                items[transportedSize] = BeltItemState.create(this.itemModelManager, lazyClientItem, state, stopped, world, mutablePos);
            }
        }
    }

    public void submit(BeltRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.render) {
            queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        }
        if (state.beltLength != 0) {
            Vec3 beltStartOffset = state.beltStartOffset;
            matrices.translate(beltStartOffset.x, beltStartOffset.y, beltStartOffset.z);
            for (BeltItemState item : state.items) {
                this.renderItem(state, item, matrices, queue);
            }
        }
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public static SpriteShiftEntry getSpriteShiftEntry(DyeColor color, boolean diagonal, boolean bottom) {
        if (color != null) {
            return (diagonal ? AllSpriteShifts.DYED_DIAGONAL_BELTS : (bottom ? AllSpriteShifts.DYED_OFFSET_BELTS : AllSpriteShifts.DYED_BELTS)).get(color);
        }
        return diagonal ? AllSpriteShifts.BELT_DIAGONAL : (bottom ? AllSpriteShifts.BELT_OFFSET : AllSpriteShifts.BELT);
    }

    public static PartialModel getBeltPartial(boolean diagonal, boolean start, boolean end, boolean bottom) {
        if (diagonal) {
            if (start) {
                return AllPartialModels.BELT_DIAGONAL_START;
            }
            if (end) {
                return AllPartialModels.BELT_DIAGONAL_END;
            }
            return AllPartialModels.BELT_DIAGONAL_MIDDLE;
        }
        if (bottom) {
            if (start) {
                return AllPartialModels.BELT_START_BOTTOM;
            }
            if (end) {
                return AllPartialModels.BELT_END_BOTTOM;
            }
            return AllPartialModels.BELT_MIDDLE_BOTTOM;
        }
        if (start) {
            return AllPartialModels.BELT_START;
        }
        if (end) {
            return AllPartialModels.BELT_END;
        }
        return AllPartialModels.BELT_MIDDLE;
    }

    private void renderItem(BeltRenderState state, BeltItemState item, PoseStack ms, SubmitNodeCollector queue) {
        boolean tiltForward;
        float offset = item.offset;
        float verticalMovement = (double)offset < 0.5 ? 0.0f : (float)state.verticality * (Math.min(offset, (float)state.beltLength - 0.5f) - 0.5f);
        Vec3 offsetVec = Vec3.atLowerCornerOf((Vec3i)state.directionVec).scale((double)offset);
        if (verticalMovement != 0.0f) {
            offsetVec = offsetVec.add(0.0, (double)verticalMovement, 0.0);
        }
        boolean onSlope = state.slope != BeltSlope.HORIZONTAL && Mth.clamp((float)offset, (float)0.5f, (float)((float)state.beltLength - 0.5f)) == offset;
        boolean bl = tiltForward = (state.slope == BeltSlope.DOWNWARD ^ state.beltFacing.getAxisDirection() == Direction.AxisDirection.POSITIVE) == (state.beltFacing.getAxis() == Direction.Axis.Z);
        float slopeAngle = onSlope ? (tiltForward ? -45.0f : 45.0f) : 0.0f;
        BlockPos pos = state.blockPos;
        Vec3 itemPos = state.beltStartOffset.add((double)pos.getX(), (double)pos.getY(), (double)pos.getZ()).add(offsetVec);
        ms.pushPose();
        TransformStack.of(ms).nudge(item.angle);
        ms.translate(offsetVec.x, offsetVec.y, offsetVec.z);
        boolean alongX = state.beltFacing.getClockWise().getAxis() == Direction.Axis.X;
        float sideOffset = item.sideOffset;
        if (!alongX) {
            sideOffset *= -1.0f;
        }
        ms.translate(alongX ? sideOffset : 0.0f, 0.0f, alongX ? 0.0f : sideOffset);
        int stackLight = state.onContraption ? state.lightCoords : item.light;
        boolean renderUpright = item.upright;
        boolean blockItem = item.state.usesBlockLight();
        int count = 0;
        if (state.onPonder || state.camera.distanceTo(itemPos) < 16.0) {
            count = Mth.log2((int)item.count) / 2;
        }
        Random r = new Random(item.angle);
        boolean slopeShadowOnly = renderUpright && onSlope;
        float slopeOffset = 0.125f;
        if (slopeShadowOnly) {
            ms.pushPose();
        }
        if (!renderUpright || slopeShadowOnly) {
            ms.mulPose((Quaternionfc)(state.slopeAlongX ? Axis.ZP : Axis.XP).rotationDegrees(slopeAngle));
        }
        if (onSlope) {
            ms.translate(0.0f, slopeOffset, 0.0f);
        }
        ms.pushPose();
        ms.translate(0.0f, -0.12f, 0.0f);
        ShadowRenderHelper.renderShadow(ms, queue, 0.75f, 0.2f);
        ms.popPose();
        if (slopeShadowOnly) {
            ms.popPose();
            ms.translate(0.0f, slopeOffset, 0.0f);
        }
        if (renderUpright) {
            Vec3 vectorForOffset = BeltHelper.getVectorForOffset(state.blockPos, state.slope, state.verticality, state.beltLength, state.directionVec, offset);
            Vec3 diff = vectorForOffset.subtract(state.camera);
            float yRot = (float)(Mth.atan2((double)diff.x, (double)diff.z) + Math.PI);
            ms.mulPose((Quaternionfc)Axis.YP.rotation(yRot));
            ms.translate(0.0, 0.09375, 0.0625);
        }
        for (int i = 0; i <= count; ++i) {
            ms.pushPose();
            ms.mulPose((Quaternionfc)Axis.YP.rotationDegrees((float)item.angle));
            if (!blockItem && !renderUpright) {
                ms.translate(0.0, -0.09375, 0.0);
                ms.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            }
            if (blockItem && !item.box) {
                ms.translate(r.nextFloat() * 0.0625f * (float)i, 0.0f, r.nextFloat() * 0.0625f * (float)i);
            }
            if (item.box) {
                ms.translate(0.0f, 0.25f, 0.0f);
                ms.scale(1.5f, 1.5f, 1.5f);
            } else {
                ms.scale(0.5f, 0.5f, 0.5f);
            }
            item.state.submit(ms, queue, stackLight, OverlayTexture.NO_OVERLAY, 0);
            ms.popPose();
            if (!renderUpright) {
                if (!blockItem) {
                    ms.mulPose((Quaternionfc)Axis.YP.rotationDegrees(10.0f));
                }
                ms.translate(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                continue;
            }
            ms.translate(0.0f, 0.0f, -0.0625f);
        }
        ms.popPose();
    }

    public static class BeltRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public boolean render;
        public RenderType layer;
        public PoseStack localTransforms;
        public SuperByteBuffer top;
        public SpriteShiftEntry topShift;
        public float topScroll;
        public SuperByteBuffer bottom;
        public SpriteShiftEntry bottomShift;
        public float bottomScroll;
        public SuperByteBuffer pulley;
        public float pulleyAngle;
        public Direction pulleyDirection;
        public Color pulleyColor;
        public int beltLength;
        public BeltItemState[] items;
        public Direction beltFacing;
        public boolean onContraption;
        public Vec3i directionVec;
        public Vec3 beltStartOffset;
        public BeltSlope slope;
        public int verticality;
        public boolean slopeAlongX;
        public float partialTicks;
        public Vec3 camera;
        boolean onPonder;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.top.light(this.lightCoords);
            if (this.topShift != null) {
                this.top.shiftUVScrolling(this.topShift, this.topScroll);
            }
            this.top.transform(this.localTransforms);
            this.top.renderInto(matricesEntry, vertexConsumer);
            if (this.bottom != null) {
                this.bottom.light(this.lightCoords);
                if (this.bottomShift != null) {
                    this.bottom.shiftUVScrolling(this.bottomShift, this.bottomScroll);
                }
                this.bottom.transform(this.localTransforms);
                this.bottom.renderInto(matricesEntry, vertexConsumer);
            }
            if (this.pulley != null) {
                this.pulley.light(this.lightCoords);
                this.pulley.rotateCentered(this.pulleyAngle, this.pulleyDirection);
                this.pulley.color(this.pulleyColor);
                this.pulley.renderInto(matricesEntry, vertexConsumer);
            }
        }
    }

    public record BeltItemState(ItemStackRenderState state, float offset, float sideOffset, Integer light, boolean upright, boolean box, int angle, int count) {
        public static BeltItemState create(ItemModelResolver itemModelManager, TransportedItemStack transported, BeltRenderState state, boolean stopped, Level world, BlockPos.MutableBlockPos mutablePos) {
            Integer light;
            float sideOffset;
            float offset;
            if (stopped) {
                offset = transported.beltPosition;
                sideOffset = transported.sideOffset;
            } else {
                offset = Mth.lerp((float)state.partialTicks, (float)transported.prevBeltPosition, (float)transported.beltPosition);
                sideOffset = Mth.lerp((float)state.partialTicks, (float)transported.prevSideOffset, (float)transported.sideOffset);
            }
            if (state.onContraption) {
                light = null;
            } else {
                int segment = (int)Math.floor(offset);
                mutablePos.set((Vec3i)state.blockPos).move(state.directionVec.getX() * segment, state.verticality * segment, state.directionVec.getZ() * segment);
                light = world != null ? LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)mutablePos) : 0xF000F0;
            }
            ItemStack stack = transported.stack;
            ItemStackRenderState renderState = new ItemStackRenderState();
            renderState.displayContext = ItemDisplayContext.FIXED;
            itemModelManager.appendItemLayers(renderState, stack, ItemDisplayContext.FIXED, null, null, 0);
            boolean upright = BeltHelper.isItemUpright(transported.stack);
            boolean box = PackageItem.isPackage(transported.stack);
            return new BeltItemState(renderState, offset, sideOffset, light, upright, box, transported.angle, stack.getCount());
        }
    }
}

