/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.google.common.cache.Cache;
import com.zurrtum.create.catnip.data.WorldAttached;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorInteractionHandler;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorPackagePhysicsData;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorShape;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBehaviour;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.foundation.utility.TickBasedCache;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.phys.Vec3;

public class ChainConveyorClientBehaviour
extends ChainConveyorBehaviour {
    private static final int ticksUntilExpired = 30;
    public static final WorldAttached<Cache<Integer, ChainConveyorPackagePhysicsData>> physicsDataCache = new WorldAttached<Cache>($ -> new TickBasedCache(30, true));

    public static ChainConveyorPackagePhysicsData physicsData(ChainConveyorPackage box, LevelAccessor level) {
        if (box.physicsData == null) {
            try {
                ChainConveyorPackagePhysicsData physicsData = (ChainConveyorPackagePhysicsData)physicsDataCache.get(level).get((Object)box.netId, ChainConveyorPackagePhysicsData::new);
                box.physicsData = physicsData;
                return physicsData;
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        physicsDataCache.get(level).getIfPresent((Object)box.netId);
        return (ChainConveyorPackagePhysicsData)box.physicsData;
    }

    public ChainConveyorClientBehaviour(ChainConveyorBlockEntity be) {
        super(be);
    }

    @Override
    public void blockEntityTickBoxVisuals() {
        if (!VisualizationManager.supportsVisualization((LevelAccessor)((ChainConveyorBlockEntity)this.blockEntity).getLevel())) {
            this.tickBoxVisuals();
        }
    }

    @Override
    public void tickBoxVisuals() {
        for (ChainConveyorPackage chainConveyorPackage : ((ChainConveyorBlockEntity)this.blockEntity).getLoopingPackages()) {
            this.tickBoxVisuals(chainConveyorPackage);
        }
        for (Map.Entry entry : ((ChainConveyorBlockEntity)this.blockEntity).getTravellingPackages().entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                this.tickBoxVisuals(box);
            }
        }
    }

    private void tickBoxVisuals(ChainConveyorPackage box) {
        if (box.worldPosition == null) {
            return;
        }
        ChainConveyorPackagePhysicsData physicsData = ChainConveyorClientBehaviour.physicsData(box, (LevelAccessor)((ChainConveyorBlockEntity)this.blockEntity).getLevel());
        physicsData.setBE((ChainConveyorBlockEntity)this.blockEntity);
        if (!physicsData.shouldTick() && !((ChainConveyorBlockEntity)this.blockEntity).isVirtual()) {
            return;
        }
        physicsData.prevTargetPos = physicsData.targetPos;
        physicsData.prevPos = physicsData.pos;
        physicsData.prevYaw = physicsData.yaw;
        physicsData.flipped = ((ChainConveyorBlockEntity)this.blockEntity).reversed;
        if (physicsData.pos != null) {
            if (physicsData.pos.distanceToSqr(box.worldPosition) > 2.25) {
                physicsData.pos = box.worldPosition.add(physicsData.pos.subtract(box.worldPosition).normalize().scale(1.5));
            }
            physicsData.motion = physicsData.motion.add(0.0, -0.25, 0.0).scale(0.75).add(box.worldPosition.subtract(physicsData.pos).scale(0.25));
            physicsData.pos = physicsData.pos.add(physicsData.motion);
        }
        physicsData.targetPos = box.worldPosition.subtract(0.0, 0.5625, 0.0);
        if (physicsData.pos == null) {
            physicsData.pos = physicsData.targetPos;
            physicsData.prevPos = physicsData.targetPos;
            physicsData.prevTargetPos = physicsData.targetPos;
        }
        physicsData.yaw = AngleHelper.angleLerp(0.25, physicsData.yaw, box.yaw);
    }

    @Override
    public void updateChainShapes() {
        ArrayList<ChainConveyorShape> shapes = new ArrayList<ChainConveyorShape>();
        shapes.add(new ChainConveyorShape.ChainConveyorBB(Vec3.atBottomCenterOf((Vec3i)BlockPos.ZERO)));
        BlockPos pos = ((ChainConveyorBlockEntity)this.blockEntity).getBlockPos();
        for (BlockPos target : ((ChainConveyorBlockEntity)this.blockEntity).connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = ((ChainConveyorBlockEntity)this.blockEntity).connectionStats.get(target);
            if (stats == null) continue;
            Vec3 localStart = stats.start().subtract(Vec3.atLowerCornerOf((Vec3i)pos));
            Vec3 localEnd = stats.end().subtract(Vec3.atLowerCornerOf((Vec3i)pos));
            shapes.add(new ChainConveyorShape.ChainConveyorOBB(target, localStart, localEnd));
        }
        ChainConveyorInteractionHandler.loadedChains.get((LevelAccessor)((ChainConveyorBlockEntity)this.blockEntity).getLevel()).put((Object)pos, shapes);
    }

    @Override
    public void invalidate() {
        ChainConveyorInteractionHandler.loadedChains.get((LevelAccessor)((ChainConveyorBlockEntity)this.blockEntity).getLevel()).invalidate((Object)((ChainConveyorBlockEntity)this.blockEntity).getBlockPos());
    }
}

