/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.chainConveyor;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorClientBehaviour;
import com.zurrtum.create.client.content.kinetics.chainConveyor.ChainConveyorPackagePhysicsData;
import com.zurrtum.create.client.foundation.render.CreateRenderTypes;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorBlockEntity;
import com.zurrtum.create.content.kinetics.chainConveyor.ChainConveyorPackage;
import com.zurrtum.create.content.logistics.box.PackageItem;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.Identifier;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;

public class ChainConveyorRenderer
extends KineticBlockEntityRenderer<ChainConveyorBlockEntity, ChainConveyorRenderState> {
    public static final Identifier CHAIN_LOCATION = Identifier.withDefaultNamespace((String)"textures/block/iron_chain.png");
    public static final int MIP_DISTANCE = 48;

    public ChainConveyorRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public ChainConveyorRenderState createRenderState() {
        return new ChainConveyorRenderState();
    }

    @Override
    public void extractRenderState(ChainConveyorBlockEntity be, ChainConveyorRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        Level world = be.getLevel();
        if (state.support) {
            BlockPos pos = be.getBlockPos();
            state.chains = this.getChainsRenderState(be, world, pos, cameraPos);
            if (state.chains == null) {
                return;
            }
            state.blockPos = pos;
            state.blockEntityType = be.getType();
            state.chain = CreateRenderTypes.chain(CHAIN_LOCATION);
            return;
        }
        state.chains = this.getChainsRenderState(be, world, state.blockPos, cameraPos);
        state.wheel = CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_WHEEL, state.blockState);
        if (state.chains != null) {
            state.chain = CreateRenderTypes.chain(CHAIN_LOCATION);
            state.guard = CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_GUARD, state.blockState);
        }
        ArrayList<BoxRenderState> boxes = new ArrayList<BoxRenderState>();
        for (ChainConveyorPackage chainConveyorPackage : be.getLoopingPackages()) {
            ChainConveyorPackagePhysicsData data = this.getPhysicsData(world, chainConveyorPackage);
            if (data == null) continue;
            boxes.add(this.getBoxRenderState(world, state.blockState, state.blockPos, chainConveyorPackage, data, tickProgress));
        }
        for (Map.Entry entry : be.getTravellingPackages().entrySet()) {
            for (ChainConveyorPackage box : (List)entry.getValue()) {
                ChainConveyorPackagePhysicsData data = this.getPhysicsData(world, box);
                if (data == null) continue;
                boxes.add(this.getBoxRenderState(world, state.blockState, state.blockPos, box, data, tickProgress));
            }
        }
        if (boxes.isEmpty()) {
            return;
        }
        state.boxes = boxes;
    }

    @Override
    public void submit(ChainConveyorRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.chains != null) {
            for (ChainRenderState chain : state.chains) {
                chain.render(matrices, state.chain, queue);
            }
        }
    }

    public ChainConveyorPackagePhysicsData getPhysicsData(Level world, ChainConveyorPackage box) {
        if (box.worldPosition == null || box.item == null || box.item.isEmpty()) {
            return null;
        }
        ChainConveyorPackagePhysicsData physicsData = ChainConveyorClientBehaviour.physicsData(box, (LevelAccessor)world);
        if (physicsData.prevPos == null) {
            return null;
        }
        if (physicsData.modelKey == null) {
            Identifier key = BuiltInRegistries.ITEM.getKey((Object)box.item.getItem());
            if (key == BuiltInRegistries.ITEM.getDefaultKey()) {
                return null;
            }
            physicsData.modelKey = key;
        }
        return physicsData;
    }

    public BoxRenderState getBoxRenderState(Level world, BlockState blockState, BlockPos pos, ChainConveyorPackage box, ChainConveyorPackagePhysicsData physicsData, float partialTicks) {
        BoxRenderState state = new BoxRenderState();
        Vec3 position = physicsData.prevPos.lerp(physicsData.pos, (double)partialTicks);
        Vec3 targetPosition = physicsData.prevTargetPos.lerp(physicsData.targetPos, (double)partialTicks);
        float yaw = AngleHelper.angleLerp(partialTicks, physicsData.prevYaw, physicsData.yaw);
        state.yaw = (float)Math.PI / 180 * yaw;
        state.offset = new Vec3(targetPosition.x - (double)pos.getX(), targetPosition.y - (double)pos.getY(), targetPosition.z - (double)pos.getZ());
        BlockPos containingPos = BlockPos.containing((Position)position);
        state.light = LightTexture.pack((int)world.getBrightness(LightLayer.BLOCK, containingPos), (int)world.getBrightness(LightLayer.SKY, containingPos));
        Vec3 dangleDiff = VecHelper.rotate(targetPosition.add(0.0, 0.5, 0.0).subtract(position), -yaw, Direction.Axis.Y);
        float zRot = Mth.wrapDegrees((float)((float)Mth.atan2((double)(-dangleDiff.x), (double)dangleDiff.y) * 57.295776f)) / 2.0f;
        float xRot = Mth.wrapDegrees((float)((float)Mth.atan2((double)dangleDiff.z, (double)dangleDiff.y) * 57.295776f)) / 2.0f;
        state.zRot = (float)Math.PI / 180 * Mth.clamp((float)zRot, (float)-25.0f, (float)25.0f);
        state.xRot = (float)Math.PI / 180 * Mth.clamp((float)xRot, (float)-25.0f, (float)25.0f);
        if (physicsData.flipped) {
            state.yRot = (float)Math.PI;
        }
        state.offsetY = -PackageItem.getHookDistance(box.item) + 0.4375f;
        state.rig = CachedBuffers.partial(AllPartialModels.PACKAGE_RIGGING.get(physicsData.modelKey), blockState);
        state.box = CachedBuffers.partial(AllPartialModels.PACKAGES.get(physicsData.modelKey), blockState);
        return state;
    }

    @Nullable
    public List<ChainRenderState> getChainsRenderState(ChainConveyorBlockEntity be, Level world, BlockPos tilePos, Vec3 cameraPos) {
        ArrayList<ChainRenderState> chains = new ArrayList<ChainRenderState>();
        Vec3 position = Vec3.atCenterOf((Vec3i)tilePos);
        boolean renderWorld = Minecraft.getInstance().level == world;
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)world) / (360.0f / Math.abs(be.getSpeed()));
        if ((time %= 1.0f) < 0.0f) {
            time += 1.0f;
        }
        float animation = time - 0.5f;
        int light1 = LightTexture.pack((int)world.getBrightness(LightLayer.BLOCK, tilePos), (int)world.getBrightness(LightLayer.SKY, tilePos));
        float yRot = 0.7853982f;
        for (BlockPos blockPos : be.connections) {
            ChainConveyorBlockEntity.ConnectionStats stats = be.connectionStats.get(blockPos);
            if (stats == null) continue;
            boolean far = renderWorld && !cameraPos.closerThan((Position)Vec3.atCenterOf((Vec3i)tilePos).add((double)((float)blockPos.getX() / 2.0f), (double)((float)blockPos.getY() / 2.0f), (double)((float)blockPos.getZ() / 2.0f)), 48.0);
            ChainRenderState state = far ? new FarChainRenderState() : new ChainRenderState();
            Vec3 diff = stats.end().subtract(stats.start());
            state.startOffset = stats.start().subtract(position);
            state.yaw = (float)Mth.atan2((double)diff.x, (double)diff.z);
            state.pitch = (float)(0.01745329238474369 * (90.0 - 57.2957763671875 * Mth.atan2((double)diff.y, (double)diff.multiply(1.0, 0.0, 1.0).length())));
            state.yRot = yRot;
            BlockPos pos = tilePos.offset((Vec3i)blockPos);
            state.light1 = light1;
            state.light2 = LightTexture.pack((int)world.getBrightness(LightLayer.BLOCK, pos), (int)world.getBrightness(LightLayer.SKY, pos));
            state.animation = animation;
            state.length = stats.chainLength();
            state.maxV = far ? 0.0625f : state.length + animation;
            chains.add(state);
        }
        if (chains.isEmpty()) {
            return null;
        }
        return chains;
    }

    private static void renderPart(PoseStack.Pose pose, VertexConsumer pConsumer, float pMaxY, float pX0, float pZ0, float pX1, float pZ1, float pX2, float pZ2, float pX3, float pZ3, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2, float uO) {
        Matrix4f matrix4f = pose.pose();
        ChainConveyorRenderer.renderQuad(matrix4f, pose, pConsumer, 0.0f, pMaxY, pX0, pZ0, pX3, pZ3, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, pose, pConsumer, 0.0f, pMaxY, pX3, pZ3, pX0, pZ0, pMinU, pMaxU, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, pose, pConsumer, 0.0f, pMaxY, pX1, pZ1, pX2, pZ2, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
        ChainConveyorRenderer.renderQuad(matrix4f, pose, pConsumer, 0.0f, pMaxY, pX2, pZ2, pX1, pZ1, pMinU + uO, pMaxU + uO, pMinV, pMaxV, light1, light2);
    }

    private static void renderQuad(Matrix4f pPose, PoseStack.Pose pNormal, VertexConsumer pConsumer, float pMinY, float pMaxY, float pMinX, float pMinZ, float pMaxX, float pMaxZ, float pMinU, float pMaxU, float pMinV, float pMaxV, int light1, int light2) {
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMinX, pMinZ, pMaxU, pMinV, light2);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMinX, pMinZ, pMaxU, pMaxV, light1);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMinY, pMaxX, pMaxZ, pMinU, pMaxV, light1);
        ChainConveyorRenderer.addVertex(pPose, pNormal, pConsumer, pMaxY, pMaxX, pMaxZ, pMinU, pMinV, light2);
    }

    private static void addVertex(Matrix4f pPose, PoseStack.Pose pNormal, VertexConsumer pConsumer, float pY, float pX, float pZ, float pU, float pV, int light) {
        pConsumer.addVertex((Matrix4fc)pPose, pX, pY, pZ).setColor(1.0f, 1.0f, 1.0f, 1.0f).setUv(pU, pV).setOverlay(OverlayTexture.NO_OVERLAY).setLight(light).setNormal(pNormal, 0.0f, 1.0f, 0.0f);
    }

    public int getViewDistance() {
        return 256;
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    @Override
    protected SuperByteBuffer getRotatedModel(ChainConveyorBlockEntity be, ChainConveyorRenderState state) {
        return CachedBuffers.partial(AllPartialModels.CHAIN_CONVEYOR_SHAFT, state.blockState);
    }

    @Override
    protected RenderType getRenderType(ChainConveyorBlockEntity be, BlockState state) {
        return RenderTypes.cutoutMovingBlock();
    }

    public static class ChainConveyorRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public SuperByteBuffer wheel;
        public SuperByteBuffer guard;
        public RenderType chain;
        public List<ChainRenderState> chains;
        public List<BoxRenderState> boxes;

        @Override
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            super.render(matricesEntry, vertexConsumer);
            this.wheel.light(this.lightCoords).overlay(OverlayTexture.NO_OVERLAY).renderInto(matricesEntry, vertexConsumer);
            if (this.guard != null) {
                for (ChainRenderState chain : this.chains) {
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.guard.center()).rotateY(chain.yaw)).uncenter()).light(this.lightCoords).overlay(OverlayTexture.NO_OVERLAY).renderInto(matricesEntry, vertexConsumer);
                }
            }
            if (this.boxes != null) {
                for (BoxRenderState box : this.boxes) {
                    box.render(matricesEntry, vertexConsumer);
                }
            }
        }
    }

    public static class BoxRenderState {
        public SuperByteBuffer rig;
        public SuperByteBuffer box;
        public float yaw;
        public Vec3 offset;
        public float zRot;
        public float xRot;
        public float yRot;
        public float offsetY;
        public int light;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.rig.translate(this.offset)).translate(0.0f, 0.625f, 0.0f)).rotateY(this.yaw)).rotateZ(this.zRot)).rotateX(this.xRot)).rotateY(this.yRot)).uncenter();
            ((SuperByteBuffer)this.rig.translate(0.0f, this.offsetY, 0.0f)).light(this.light).overlay(OverlayTexture.NO_OVERLAY).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.box.translate(this.offset)).translate(0.0f, 0.625f, 0.0f)).rotateY(this.yaw)).rotateZ(this.zRot)).rotateX(this.xRot)).uncenter();
            ((SuperByteBuffer)this.box.translate(0.0f, this.offsetY, 0.0f)).light(this.light).overlay(OverlayTexture.NO_OVERLAY).renderInto(matricesEntry, vertexConsumer);
        }
    }

    public static class ChainRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public Vec3 startOffset;
        public float yaw;
        public float pitch;
        public float yRot;
        public float animation;
        public float length;
        public int light1;
        public int light2;
        public float maxV;

        public void render(PoseStack matrices, RenderType layer, SubmitNodeCollector queue) {
            matrices.pushPose();
            matrices.translate(0.5f, 0.5f, 0.5f);
            matrices.translate(this.startOffset);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.yaw));
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(this.pitch));
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.yRot));
            queue.submitCustomGeometry(matrices, layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
            matrices.popPose();
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ChainConveyorRenderer.renderPart(matricesEntry, vertexConsumer, this.length, 0.0f, 0.09375f, 0.09375f, 0.0f, -0.09375f, 0.0f, 0.0f, -0.09375f, 0.0f, 0.1875f, this.animation, this.maxV, this.light1, this.light2, 0.1875f);
        }
    }

    public static class FarChainRenderState
    extends ChainRenderState {
        @Override
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ChainConveyorRenderer.renderPart(matricesEntry, vertexConsumer, this.length, 0.0f, 0.0625f, 0.0625f, 0.0f, -0.0625f, 0.0f, 0.0f, -0.0625f, 0.1875f, 0.25f, 0.0f, this.maxV, this.light1, this.light2, 0.0f);
        }
    }
}

