/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.clock;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.animation.AnimationBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.animation.CuckooClockAnimationBehaviour;
import com.zurrtum.create.content.kinetics.clock.CuckooClockBlock;
import com.zurrtum.create.content.kinetics.clock.CuckooClockBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class CuckooClockRenderer
extends KineticBlockEntityRenderer<CuckooClockBlockEntity, CuckooClockRenderState> {
    public CuckooClockRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public CuckooClockRenderState createRenderState() {
        return new CuckooClockRenderState();
    }

    @Override
    public void extractRenderState(CuckooClockBlockEntity be, CuckooClockRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        if (state.support) {
            state.blockPos = be.getBlockPos();
            state.blockState = be.getBlockState();
            state.blockEntityType = be.getType();
            Level world = be.getLevel();
            state.lightCoords = world != null ? LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos) : 0xF000F0;
            state.layer = RenderTypes.solidMovingBlock();
            state.facing = (Direction)state.blockState.getValue((Property)CuckooClockBlock.HORIZONTAL_FACING);
        }
        state.hourHand = CachedBuffers.partial(AllPartialModels.CUCKOO_HOUR_HAND, state.blockState);
        state.minuteHand = CachedBuffers.partial(AllPartialModels.CUCKOO_MINUTE_HAND, state.blockState);
        CuckooClockAnimationBehaviour behaviour = (CuckooClockAnimationBehaviour)be.getBehaviour(AnimationBehaviour.TYPE);
        state.angle = AngleHelper.rad(AngleHelper.horizontalAngle(state.facing.getCounterClockWise()));
        state.hourAngle = AngleHelper.rad(behaviour.hourHand.getValue(tickProgress));
        state.minuteAngle = AngleHelper.rad(behaviour.minuteHand.getValue(tickProgress));
        state.leftDoor = CachedBuffers.partial(AllPartialModels.CUCKOO_LEFT_DOOR, state.blockState);
        state.rightDoor = CachedBuffers.partial(AllPartialModels.CUCKOO_RIGHT_DOOR, state.blockState);
        float angle = 0.0f;
        if (be.animationType != null) {
            float value = be.animationProgress.getValue(tickProgress);
            int step = be.animationType == CuckooClockBlockEntity.Animation.SURPRISE ? 3 : 15;
            for (int phase = 30; phase <= 60; phase += step) {
                float local = value - (float)phase;
                if (local < (float)(-step / 3)) continue;
                if (local < 0.0f) {
                    angle = Mth.lerpInt((float)((value - (float)(phase - 5)) / 5.0f), (int)0, (int)135);
                    continue;
                }
                if (local < (float)(step / 3)) {
                    angle = 135.0f;
                    continue;
                }
                if (!(local < (float)(2 * step / 3))) continue;
                angle = Mth.lerpInt((float)((value - (float)(phase + 5)) / 5.0f), (int)135, (int)0);
            }
        }
        state.doorAngle = AngleHelper.rad(angle);
        if (be.animationType != CuckooClockBlockEntity.Animation.NONE) {
            PartialModel partialModel = be.animationType == CuckooClockBlockEntity.Animation.PIG ? AllPartialModels.CUCKOO_PIG : AllPartialModels.CUCKOO_CREEPER;
            state.figure = CachedBuffers.partial(partialModel, state.blockState);
            state.offset = -(angle / 135.0f) * 1.0f / 2.0f + 0.625f;
        }
    }

    @Override
    public void updateBaseRenderState(CuckooClockBlockEntity be, CuckooClockRenderState state, Level world, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.updateBaseRenderState(be, state, world, crumblingOverlay);
        state.facing = (Direction)state.blockState.getValue((Property)CuckooClockBlock.HORIZONTAL_FACING);
    }

    @Override
    public void submit(CuckooClockRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    @Override
    protected RenderType getRenderType(CuckooClockBlockEntity be, BlockState state) {
        return RenderTypes.solidMovingBlock();
    }

    @Override
    protected SuperByteBuffer getRotatedModel(CuckooClockBlockEntity be, CuckooClockRenderState state) {
        return CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.blockState, state.facing.getOpposite());
    }

    public static class CuckooClockRenderState
    extends KineticBlockEntityRenderer.KineticRenderState {
        public Direction facing;
        public SuperByteBuffer hourHand;
        public SuperByteBuffer minuteHand;
        public float angle;
        public float hourAngle;
        public float minuteAngle;
        public SuperByteBuffer leftDoor;
        public SuperByteBuffer rightDoor;
        public float doorAngle;
        public SuperByteBuffer figure;
        public float offset;

        @Override
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            if (this.model != null) {
                super.render(matricesEntry, vertexConsumer);
            }
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.hourHand.rotateCentered(this.angle, Direction.UP)).translate(0.125f, 0.375f, 0.5f)).rotate(this.hourAngle, Direction.EAST)).translate(-0.125f, -0.375f, -0.5f)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.minuteHand.rotateCentered(this.angle, Direction.UP)).translate(0.125f, 0.375f, 0.5f)).rotate(this.minuteAngle, Direction.EAST)).translate(-0.125f, -0.375f, -0.5f)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.leftDoor.rotateCentered(this.angle, Direction.UP)).translate(0.125f, 0.0f, 0.375f)).rotate(-this.doorAngle, Direction.UP)).translate(-0.125f, 0.0f, -0.375f)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.rightDoor.rotateCentered(this.angle, Direction.UP)).translate(0.125f, 0.0f, 0.625f)).rotate(this.doorAngle, Direction.UP)).translate(-0.125f, 0.0f, -0.625f)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            if (this.figure != null) {
                ((SuperByteBuffer)((SuperByteBuffer)this.figure.rotateCentered(this.angle, Direction.UP)).translate(this.offset, 0.0f, 0.0f)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

