/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.crank;

import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.content.kinetics.crank.HandCrankRenderer;
import com.zurrtum.create.content.kinetics.crank.HandCrankBlockEntity;
import com.zurrtum.create.content.kinetics.crank.ValveHandleBlock;
import com.zurrtum.create.content.kinetics.crank.ValveHandleBlockEntity;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ValveHandleRenderer
extends HandCrankRenderer {
    public ValveHandleRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public float getIndependentAngle(HandCrankBlockEntity be, float partialTicks) {
        return ValveHandleRenderer.getValveHandleIndependentAngle((ValveHandleBlockEntity)be, partialTicks);
    }

    public static float getValveHandleIndependentAngle(ValveHandleBlockEntity be, float partialTicks) {
        if (be.inUse == 0 && be.source != null && be.getSpeed() != 0.0f) {
            return KineticBlockEntityRenderer.getAngleForBe(be, be.getBlockPos(), KineticBlockEntityRenderer.getRotationAxisOf(be));
        }
        int step = be.getBlockState().getOptionalValue((Property)ValveHandleBlock.FACING).orElse(Direction.SOUTH).getAxisDirection().getStep();
        return (float)(be.inUse > 0 && be.totalUseTicks > 0 ? Mth.lerpInt((float)(Math.min((float)be.totalUseTicks, (float)(be.totalUseTicks - be.inUse) + partialTicks) / (float)be.totalUseTicks), (int)be.startAngle, (int)be.targetAngle) : be.targetAngle) * ((float)Math.PI / 180) * (float)(be.backwards ? -1 : 1) * (float)step;
    }

    @Override
    public SuperByteBuffer getRenderedHandle(BlockState blockState) {
        return CachedBuffers.block(blockState);
    }

    @Override
    public boolean shouldRenderShaft() {
        return false;
    }
}

