/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.deployer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlock;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class DeployerFilterSlot
extends ValueBoxTransform.Sided {
    @Override
    public Vec3 getLocalOffset(BlockState state) {
        Direction facing = (Direction)state.getValue((Property)DeployerBlock.FACING);
        Vec3 vec = VecHelper.voxelSpace(8.0, 8.0, 15.5);
        vec = VecHelper.rotateCentered(vec, AngleHelper.horizontalAngle(this.getSide()), Direction.Axis.Y);
        vec = VecHelper.rotateCentered(vec, AngleHelper.verticalAngle(this.getSide()), Direction.Axis.X);
        vec = vec.subtract(Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()).scale(0.125));
        return vec;
    }

    @Override
    protected boolean isSideActive(BlockState state, Direction direction) {
        Direction facing = (Direction)state.getValue((Property)DeployerBlock.FACING);
        if (direction.getAxis() == facing.getAxis()) {
            return false;
        }
        return ((DeployerBlock)state.getBlock()).getRotationAxis(state) != direction.getAxis();
    }

    @Override
    public void rotate(BlockState state, PoseStack ms) {
        Direction facing = this.getSide();
        float xRot = facing == Direction.UP ? 90.0f : (facing == Direction.DOWN ? 270.0f : 0.0f);
        float yRot = AngleHelper.horizontalAngle(facing) + 180.0f;
        if (facing.getAxis() == Direction.Axis.Y) {
            TransformStack.of(ms).rotateYDegrees(180.0f + AngleHelper.horizontalAngle((Direction)state.getValue((Property)DeployerBlock.FACING)));
        }
        ((PoseTransformStack)TransformStack.of(ms).rotateYDegrees(yRot)).rotateXDegrees(xRot);
    }

    @Override
    protected Vec3 getSouthLocation() {
        return Vec3.ZERO;
    }
}

