/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.deployer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderBehaviour;
import com.zurrtum.create.client.api.behaviour.movement.MovementRenderState;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.contraptions.render.ActorVisual;
import com.zurrtum.create.client.content.kinetics.deployer.DeployerActorVisual;
import com.zurrtum.create.client.content.kinetics.deployer.DeployerRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.virtualWorld.VirtualRenderWorld;
import com.zurrtum.create.content.contraptions.behaviour.MovementContext;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;

public class DeployerMovementRenderBehaviour
implements MovementRenderBehaviour {
    @Override
    @Nullable
    public ActorVisual createVisual(VisualizationContext visualizationContext, VirtualRenderWorld simulationWorld, MovementContext movementContext) {
        return new DeployerActorVisual(visualizationContext, simulationWorld, movementContext);
    }

    @Override
    public MovementRenderState getRenderState(Vec3 camera, Font textRenderer, MovementContext context, VirtualRenderWorld renderWorld, Matrix4f worldMatrix4f) {
        double factor;
        if (VisualizationManager.supportsVisualization((LevelAccessor)context.world)) {
            return null;
        }
        DeployerMovementRenderState state = new DeployerMovementRenderState(context.localPos);
        state.layer = RenderTypes.solidMovingBlock();
        BlockState blockState = context.state;
        DeployerBlockEntity.Mode mode = context.blockEntityData.read("Mode", DeployerBlockEntity.Mode.CODEC).orElse(DeployerBlockEntity.Mode.PUNCH);
        PartialModel handPose = DeployerRenderer.getHandPose(mode);
        float speed = context.getAnimationSpeed();
        if (context.contraption.stalled) {
            speed = 0.0f;
        }
        state.shaft = CachedBuffers.block(AllBlocks.SHAFT.defaultBlockState());
        state.pole = CachedBuffers.partial(AllPartialModels.DEPLOYER_POLE, blockState);
        state.hand = CachedBuffers.partial(handPose, blockState);
        if (context.contraption.stalled || context.position == null || context.data.contains("StationaryTimer")) {
            factor = Mth.sin((double)(AnimationTickHolder.getRenderTime() * 0.5f)) * 0.25f + 0.25f;
        } else {
            Vec3 center = VecHelper.getCenterOf((Vec3i)BlockPos.containing((Position)context.position));
            double distance = context.position.distanceTo(center);
            double nextDistance = context.position.add(context.motion).distanceTo(center);
            factor = 0.5 - Mth.clamp((double)Mth.lerp((double)AnimationTickHolder.getPartialTicks(), (double)distance, (double)nextDistance), (double)0.0, (double)1.0);
        }
        Direction facing = (Direction)blockState.getValue(DirectionalKineticBlock.FACING);
        Direction.Axis axis = Direction.Axis.Y;
        Block block = context.state.getBlock();
        if (block instanceof IRotate) {
            IRotate def = (IRotate)block;
            axis = def.getRotationAxis(context.state);
        }
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)context.world) / 20.0f;
        state.angle = time * speed % 360.0f;
        state.yRot = axis == Direction.Axis.Z ? 1.5707964f : 0.0f;
        state.zRot = axis.isHorizontal() ? 1.5707964f : 0.0f;
        state.light = LevelRenderer.getLightColor((BlockAndTintGetter)renderWorld, (BlockPos)context.localPos);
        state.world = context.world;
        state.worldMatrix4f = worldMatrix4f;
        if (!context.disabled) {
            state.offset = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()).scale(factor);
        }
        state.upAngle = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        state.eastAngle = (float)Math.PI / 180 * (float)(facing == Direction.UP ? 270 : (facing == Direction.DOWN ? 90 : 0));
        state.southAngle = (float)Math.PI / 180 * (float)((Boolean)blockState.getValue((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ facing.getAxis() == Direction.Axis.Z ? 90 : 0);
        return state;
    }

    public static class DeployerMovementRenderState
    extends MovementRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer shaft;
        public SuperByteBuffer pole;
        public SuperByteBuffer hand;
        public float yRot;
        public float zRot;
        public float angle;
        public int light;
        public Level world;
        public Matrix4f worldMatrix4f;
        public Vec3 offset;
        public float upAngle;
        public float eastAngle;
        public float southAngle;

        public DeployerMovementRenderState(BlockPos pos) {
            super(pos);
        }

        @Override
        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            queue.submitCustomGeometry(matrices, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
        }

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.shaft.center()).rotateY(this.yRot)).rotateZ(this.zRot)).uncenter()).rotateCentered(this.angle, Direction.UP)).light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            if (this.offset != null) {
                this.pole.translate(this.offset);
                this.hand.translate(this.offset);
            }
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.pole.rotateCentered(this.upAngle, Direction.UP)).rotateCentered(this.eastAngle, Direction.EAST)).rotateCentered(this.southAngle, Direction.SOUTH)).light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)this.hand.rotateCentered(this.upAngle, Direction.UP)).rotateCentered(this.eastAngle, Direction.EAST)).light(this.light).useLevelLight((BlockAndTintGetter)this.world, this.worldMatrix4f).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

