/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.deployer;

import com.mojang.math.Axis;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.ShaftVisual;
import com.zurrtum.create.client.content.kinetics.deployer.DeployerRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.OrientedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleTickableVisual;
import com.zurrtum.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.zurrtum.create.content.kinetics.base.DirectionalKineticBlock;
import com.zurrtum.create.content.kinetics.deployer.DeployerBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class DeployerVisual
extends ShaftVisual<DeployerBlockEntity>
implements SimpleDynamicVisual,
SimpleTickableVisual {
    final Direction facing;
    final float yRot;
    final float xRot;
    final float zRot;
    protected final OrientedInstance pole;
    protected OrientedInstance hand;
    PartialModel currentHand;
    float progress;

    public DeployerVisual(VisualizationContext context, DeployerBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        this.facing = (Direction)this.blockState.getValue(DirectionalKineticBlock.FACING);
        boolean rotatePole = (Boolean)this.blockState.getValue((Property)DirectionalAxisKineticBlock.AXIS_ALONG_FIRST_COORDINATE) ^ this.facing.getAxis() == Direction.Axis.Z;
        this.yRot = AngleHelper.horizontalAngle(this.facing);
        this.xRot = this.facing == Direction.UP ? 270.0f : (this.facing == Direction.DOWN ? 90.0f : 0.0f);
        this.zRot = rotatePole ? 90.0f : 0.0f;
        this.pole = this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial(AllPartialModels.DEPLOYER_POLE)).createInstance();
        this.currentHand = DeployerRenderer.getHandPose(blockEntity);
        this.hand = this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial(this.currentHand)).createInstance();
        this.progress = this.getProgress(partialTick);
        DeployerVisual.updateRotation(this.pole, this.hand, this.yRot, this.xRot, this.zRot);
        this.updatePosition();
    }

    @Override
    public void tick(TickableVisual.Context context) {
        PartialModel handPose = DeployerRenderer.getHandPose((DeployerBlockEntity)this.blockEntity);
        if (this.currentHand != handPose) {
            this.currentHand = handPose;
            this.instancerProvider().instancer(InstanceTypes.ORIENTED, Models.partial(this.currentHand)).stealInstance(this.hand);
        }
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        float newProgress = this.getProgress(ctx.partialTick());
        if (Mth.equal((float)newProgress, (float)this.progress)) {
            return;
        }
        this.progress = newProgress;
        this.updatePosition();
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(this.hand, this.pole);
    }

    @Override
    protected void _delete() {
        super._delete();
        this.hand.delete();
        this.pole.delete();
    }

    private float getProgress(float partialTicks) {
        if (((DeployerBlockEntity)this.blockEntity).state == DeployerBlockEntity.State.EXPANDING) {
            float f = 1.0f - ((float)((DeployerBlockEntity)this.blockEntity).timer - partialTicks * (float)((DeployerBlockEntity)this.blockEntity).getTimerSpeed()) / 1000.0f;
            if (((DeployerBlockEntity)this.blockEntity).fistBump) {
                f *= f;
            }
            return f;
        }
        if (((DeployerBlockEntity)this.blockEntity).state == DeployerBlockEntity.State.RETRACTING) {
            return ((float)((DeployerBlockEntity)this.blockEntity).timer - partialTicks * (float)((DeployerBlockEntity)this.blockEntity).getTimerSpeed()) / 1000.0f;
        }
        return 0.0f;
    }

    private void updatePosition() {
        float handLength = this.currentHand == AllPartialModels.DEPLOYER_HAND_POINTING ? 0.0f : (this.currentHand == AllPartialModels.DEPLOYER_HAND_HOLDING ? 0.25f : 0.1875f);
        float distance = Math.min(Mth.clamp((float)this.progress, (float)0.0f, (float)1.0f) * (((DeployerBlockEntity)this.blockEntity).reach + handLength), 1.3125f);
        Vec3i facingVec = this.facing.getUnitVec3i();
        BlockPos blockPos = this.getVisualPosition();
        float x = (float)blockPos.getX() + (float)facingVec.getX() * distance;
        float y = (float)blockPos.getY() + (float)facingVec.getY() * distance;
        float z = (float)blockPos.getZ() + (float)facingVec.getZ() * distance;
        this.pole.position(x, y, z).setChanged();
        this.hand.position(x, y, z).setChanged();
    }

    static void updateRotation(OrientedInstance pole, OrientedInstance hand, float yRot, float xRot, float zRot) {
        Quaternionf q = Axis.YP.rotationDegrees(yRot);
        q.mul((Quaternionfc)Axis.XP.rotationDegrees(xRot));
        hand.rotation((Quaternionfc)q).setChanged();
        q.mul((Quaternionfc)Axis.ZP.rotationDegrees(zRot));
        pole.rotation((Quaternionfc)q).setChanged();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept(this.pole);
        consumer.accept(this.hand);
    }
}

