/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.fan;

import com.zurrtum.create.client.content.kinetics.fan.AirCurrentSound;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public class AirCurrentClient {
    private static boolean isClientPlayerInAirCurrent;
    private static AirCurrentSound flyingSound;

    public static void enableClientPlayerSound(Entity e, float maxVolume) {
        if (e != Minecraft.getInstance().getCameraEntity()) {
            return;
        }
        isClientPlayerInAirCurrent = true;
        float pitch = (float)Mth.clamp((double)(e.getDeltaMovement().length() * 0.5), (double)0.5, (double)2.0);
        if (flyingSound == null || flyingSound.isStopped()) {
            flyingSound = new AirCurrentSound(SoundEvents.ELYTRA_FLYING, pitch);
            Minecraft.getInstance().getSoundManager().play((SoundInstance)flyingSound);
        }
        flyingSound.setPitch(pitch);
        flyingSound.fadeIn(maxVolume);
    }

    public static void tickClientPlayerSounds() {
        if (!isClientPlayerInAirCurrent && flyingSound != null) {
            if (flyingSound.isFaded()) {
                flyingSound.stopSound();
            } else {
                flyingSound.fadeOut();
            }
        }
        isClientPlayerInAirCurrent = false;
    }
}

