/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.gearbox;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.instance.Instancer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.AbstractInstance;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.gearbox.GearboxBlockEntity;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class GearboxVisual
extends KineticBlockEntityVisual<GearboxBlockEntity> {
    protected final EnumMap<Direction, RotatingInstance> keys = new EnumMap(Direction.class);
    protected Direction sourceFacing;

    public GearboxVisual(VisualizationContext context, GearboxBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        Direction.Axis boxAxis = (Direction.Axis)this.blockState.getValue((Property)BlockStateProperties.AXIS);
        this.updateSourceFacing();
        Instancer<RotatingInstance> instancer = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial(AllPartialModels.SHAFT_HALF));
        for (Direction direction : Iterate.directions) {
            Direction.Axis axis = direction.getAxis();
            if (boxAxis == axis) continue;
            RotatingInstance instance = instancer.createInstance();
            instance.setup(blockEntity, axis, this.getSpeed(direction)).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, direction).setChanged();
            this.keys.put(direction, instance);
        }
    }

    private float getSpeed(Direction direction) {
        float speed = ((GearboxBlockEntity)this.blockEntity).getSpeed();
        if (speed != 0.0f && this.sourceFacing != null) {
            if (this.sourceFacing.getAxis() == direction.getAxis()) {
                speed *= this.sourceFacing == direction ? 1.0f : -1.0f;
            } else if (this.sourceFacing.getAxisDirection() == direction.getAxisDirection()) {
                speed *= -1.0f;
            }
        }
        return speed;
    }

    protected void updateSourceFacing() {
        if (((GearboxBlockEntity)this.blockEntity).hasSource()) {
            BlockPos source = ((GearboxBlockEntity)this.blockEntity).source.subtract((Vec3i)this.pos);
            this.sourceFacing = Direction.getApproximateNearest((float)source.getX(), (float)source.getY(), (float)source.getZ());
        } else {
            this.sourceFacing = null;
        }
    }

    @Override
    public void update(float pt) {
        this.updateSourceFacing();
        for (Map.Entry<Direction, RotatingInstance> key : this.keys.entrySet()) {
            Direction direction = key.getKey();
            Direction.Axis axis = direction.getAxis();
            key.getValue().setup((KineticBlockEntity)this.blockEntity, axis, this.getSpeed(direction)).setChanged();
        }
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight((FlatLit[])this.keys.values().toArray(FlatLit[]::new));
    }

    @Override
    protected void _delete() {
        this.keys.values().forEach(AbstractInstance::delete);
        this.keys.clear();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        this.keys.values().forEach(consumer);
    }
}

