/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.saw;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.filtering.FilteringRenderer;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.saw.SawBlock;
import com.zurrtum.create.content.kinetics.saw.SawBlockEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.processing.recipe.ProcessingInventory;
import it.unimi.dsi.fastutil.booleans.BooleanArrayList;
import it.unimi.dsi.fastutil.booleans.BooleanList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class SawRenderer
implements BlockEntityRenderer<SawBlockEntity, SawRenderState> {
    protected final ItemModelResolver itemModelManager;

    public SawRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public SawRenderState createRenderState() {
        return new SawRenderState();
    }

    public void extractRenderState(SawBlockEntity be, SawRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        state.layer = RenderTypes.cutoutMovingBlock();
        state.partialTicks = tickProgress;
        state.speed = be.getSpeed();
        this.updateBlade(state);
        Level world = be.getLevel();
        this.updateItems(be.inventory, world, state);
        if (!be.isRemoved()) {
            state.filter = FilteringRenderer.getFilterRenderState(be, state.blockState, this.itemModelManager, be.isVirtual() ? -1.0 : cameraPos.distanceToSqr(VecHelper.getCenterOf((Vec3i)state.blockPos)));
        }
        if (VisualizationManager.supportsVisualization((LevelAccessor)world)) {
            return;
        }
        Direction.Axis axis = ((IRotate)state.blockState.getBlock()).getRotationAxis(state.blockState);
        state.shaft = this.getRotatedModel(state.blockState, axis);
        state.angle = KineticBlockEntityRenderer.getAngleForBe(be, state.blockPos, axis);
        state.direction = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
        state.color = KineticBlockEntityRenderer.getColor(be);
    }

    public void submit(SawRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        if (state.items != null) {
            this.renderItems(state, matrices, queue);
        }
        if (state.filter != null) {
            state.filter.render(state.blockState, queue, matrices, state.lightCoords);
        }
    }

    public void updateBlade(SawRenderState state) {
        PartialModel partial;
        BlockState blockState = state.blockState;
        float speed = state.speed;
        boolean rotate = false;
        if (SawBlock.isHorizontal(blockState)) {
            partial = speed > 0.0f ? AllPartialModels.SAW_BLADE_HORIZONTAL_ACTIVE : (speed < 0.0f ? AllPartialModels.SAW_BLADE_HORIZONTAL_REVERSED : AllPartialModels.SAW_BLADE_HORIZONTAL_INACTIVE);
        } else {
            partial = speed > 0.0f ? AllPartialModels.SAW_BLADE_VERTICAL_ACTIVE : (speed < 0.0f ? AllPartialModels.SAW_BLADE_VERTICAL_REVERSED : AllPartialModels.SAW_BLADE_VERTICAL_INACTIVE);
            if (((Boolean)blockState.getValue((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE)).booleanValue()) {
                rotate = true;
            }
        }
        state.blade = CachedBuffers.partialFacing(partial, blockState);
        state.bladeAngle = rotate ? AngleHelper.rad(90.0) : -1.0f;
    }

    public void updateItems(ProcessingInventory inventory, Level world, SawRenderState state) {
        boolean hasInput;
        if (state.blockState.getValue((Property)SawBlock.FACING) != Direction.UP) {
            return;
        }
        ArrayList<ItemStackRenderState> items = new ArrayList<ItemStackRenderState>();
        BooleanArrayList box = new BooleanArrayList();
        ItemStack stack = inventory.getItem(0);
        boolean bl = hasInput = !stack.isEmpty();
        if (hasInput) {
            ItemStackRenderState renderState = new ItemStackRenderState();
            renderState.displayContext = ItemDisplayContext.FIXED;
            this.itemModelManager.appendItemLayers(renderState, stack, ItemDisplayContext.FIXED, world, null, 0);
            items.add(renderState);
            box.add(PackageItem.isPackage(stack));
        }
        int size = inventory.getContainerSize();
        for (int i = 1; i < size; ++i) {
            stack = inventory.getItem(i);
            if (stack.isEmpty()) continue;
            ItemStackRenderState renderState = new ItemStackRenderState();
            renderState.displayContext = ItemDisplayContext.FIXED;
            this.itemModelManager.appendItemLayers(renderState, stack, ItemDisplayContext.FIXED, world, null, 0);
            items.add(renderState);
            box.add(PackageItem.isPackage(stack));
        }
        if (items.isEmpty()) {
            return;
        }
        state.items = items;
        state.box = box;
        state.outputs = hasInput ? items.size() - 1 : items.size();
        state.alongZ = (Boolean)state.blockState.getValue((Property)SawBlock.AXIS_ALONG_FIRST_COORDINATE) == false;
        state.duration = inventory.recipeDuration;
        state.remainingTime = inventory.remainingTime;
        state.appliedRecipe = inventory.appliedRecipe;
    }

    public void renderItems(SawRenderState state, PoseStack ms, SubmitNodeCollector queue) {
        float offset;
        boolean alongZ = state.alongZ;
        float duration = state.duration;
        float speed = state.speed;
        boolean moving = duration != 0.0f;
        float f = offset = moving ? state.remainingTime / duration : 0.0f;
        if (moving) {
            float processingSpeed = Mth.clamp((float)(Math.abs(speed) / 32.0f), (float)1.0f, (float)128.0f);
            offset = Mth.clamp((float)(offset + (-state.partialTicks + 0.5f) * processingSpeed / duration), (float)0.125f, (float)1.0f);
            if (!state.appliedRecipe) {
                offset += 1.0f;
            }
            offset /= 2.0f;
        }
        if (speed == 0.0f) {
            offset = 0.5f;
        }
        if (speed < 0.0f ^ alongZ) {
            offset = 1.0f - offset;
        }
        int outputs = state.outputs;
        ms.pushPose();
        if (alongZ) {
            ms.mulPose((Quaternionfc)Axis.YP.rotationDegrees(90.0f));
        }
        ms.translate(outputs <= 1 ? 0.5 : 0.25, 0.0, (double)offset);
        ms.translate(alongZ ? -1.0f : 0.0f, 0.0f, 0.0f);
        int renderedI = 0;
        List<ItemStackRenderState> items = state.items;
        BooleanList boxList = state.box;
        int light = state.lightCoords;
        int size = items.size();
        PoseTransformStack msr = size > 1 && outputs > 1 ? TransformStack.of(ms) : null;
        for (int i = 0; i < size; ++i) {
            boolean box;
            ItemStackRenderState renderState = items.get(i);
            ms.pushPose();
            ms.translate(0.0f, renderState.usesBlockLight() ? 0.925f : 0.8125f, 0.0f);
            if (i > 0 && outputs > 1) {
                ms.translate(0.5 / (double)(outputs - 1) * (double)renderedI, 0.0, 0.0);
                msr.nudge(i * 133);
            }
            if (box = boxList.getBoolean(i)) {
                ms.translate(0.0f, 0.25f, 0.0f);
                ms.scale(1.5f, 1.5f, 1.5f);
            } else {
                ms.scale(0.5f, 0.5f, 0.5f);
            }
            if (!box) {
                ms.mulPose((Quaternionfc)Axis.XP.rotationDegrees(90.0f));
            }
            renderState.submit(ms, queue, light, OverlayTexture.NO_OVERLAY, 0);
            ++renderedI;
            ms.popPose();
        }
        ms.popPose();
    }

    protected SuperByteBuffer getRotatedModel(BlockState state, Direction.Axis axis) {
        if (((Direction)state.getValue((Property)BlockStateProperties.FACING)).getAxis().isHorizontal()) {
            return CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.getBlock().rotate(state, Rotation.CLOCKWISE_180));
        }
        return CachedBuffers.block(KineticBlockEntityRenderer.KINETIC_BLOCK, KineticBlockEntityRenderer.shaft(axis));
    }

    public static class SawRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public float speed;
        public float partialTicks;
        public SuperByteBuffer blade;
        public float bladeAngle;
        public List<ItemStackRenderState> items;
        public BooleanList box;
        public int outputs;
        public boolean alongZ;
        public float duration;
        public float remainingTime;
        public boolean appliedRecipe;
        public FilteringRenderer.FilterRenderState filter;
        public SuperByteBuffer shaft;
        public float angle;
        public Direction direction;
        public Color color;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            if (this.bladeAngle != -1.0f) {
                this.blade.rotateCentered(this.bladeAngle, Direction.UP);
            }
            this.blade.color(0xFFFFFF).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            if (this.shaft != null) {
                ((SuperByteBuffer)this.shaft.light(this.lightCoords).rotateCentered(this.angle, this.direction)).color(this.color).renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

