/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.speedController;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.speedController.SpeedControllerBlock;
import com.zurrtum.create.content.kinetics.speedController.SpeedControllerBlockEntity;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SpeedControllerRenderer
implements BlockEntityRenderer<SpeedControllerBlockEntity, SpeedControllerRenderState> {
    public SpeedControllerRenderer(BlockEntityRendererProvider.Context context) {
    }

    public SpeedControllerRenderState createRenderState() {
        return new SpeedControllerRenderState();
    }

    public void extractRenderState(SpeedControllerBlockEntity be, SpeedControllerRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        Level world = be.getLevel();
        boolean bl = state.render = !VisualizationManager.supportsVisualization((LevelAccessor)world);
        if (state.render) {
            state.model = this.getRotatedModel(be);
            Direction.Axis axis = ((IRotate)state.blockState.getBlock()).getRotationAxis(state.blockState);
            state.direction = Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)Direction.AxisDirection.POSITIVE);
            state.angle = KineticBlockEntityRenderer.getAngleForBe(be, state.blockPos, axis);
            state.color = KineticBlockEntityRenderer.getColor(be);
        }
        state.hasBracket = be.hasBracket;
        if (state.hasBracket) {
            state.bracket = CachedBuffers.partial(AllPartialModels.SPEED_CONTROLLER_BRACKET, state.blockState);
            boolean alongX = state.blockState.getValue((Property)SpeedControllerBlock.HORIZONTAL_AXIS) == Direction.Axis.X;
            state.bracketAngle = (float)(alongX ? Math.PI : 1.5707963267948966);
            int n = state.bracketLight = world != null ? LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos.above()) : 0xF000F0;
        }
        if (state.render || state.hasBracket) {
            state.layer = RenderTypes.solidMovingBlock();
        }
    }

    public void submit(SpeedControllerRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.render || state.hasBracket) {
            queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        }
    }

    private SuperByteBuffer getRotatedModel(SpeedControllerBlockEntity blockEntity) {
        return CachedBuffers.block(KineticBlockEntityRenderer.KINETIC_BLOCK, KineticBlockEntityRenderer.shaft(KineticBlockEntityRenderer.getRotationAxisOf(blockEntity)));
    }

    public static class SpeedControllerRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public boolean render;
        public SuperByteBuffer model;
        public Direction direction;
        public float angle;
        public Color color;
        public boolean hasBracket;
        public SuperByteBuffer bracket;
        public float bracketAngle;
        public int bracketLight;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            if (this.render) {
                this.model.light(this.lightCoords);
                this.model.rotateCentered(this.angle, this.direction);
                this.model.color(this.color);
                this.model.renderInto(matricesEntry, vertexConsumer);
            }
            if (this.hasBracket) {
                this.bracket.translate(0.0f, 1.0f, 0.0f);
                this.bracket.rotateCentered(this.bracketAngle, Direction.UP);
                this.bracket.light(this.bracketLight);
                this.bracket.renderInto(matricesEntry, vertexConsumer);
            }
        }
    }
}

