/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.steamEngine;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.Pointing;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.kinetics.steamEngine.SteamEngineBlock;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class SteamEngineValueBox
extends ValueBoxTransform.Sided {
    @Override
    protected boolean isSideActive(BlockState state, Direction side) {
        boolean recessed;
        Direction engineFacing = SteamEngineBlock.getFacing(state);
        if (engineFacing.getAxis() == side.getAxis()) {
            return false;
        }
        float roll = 0.0f;
        for (Pointing p : Pointing.values()) {
            if (p.getCombinedDirection(engineFacing) != side) continue;
            roll = p.getXRotation();
        }
        if (engineFacing == Direction.UP) {
            roll += 180.0f;
        }
        boolean bl = recessed = roll % 180.0f == 0.0f;
        if (engineFacing.getAxis() == Direction.Axis.Y) {
            recessed ^= ((Direction)state.getValue((Property)SteamEngineBlock.FACING)).getAxis() == Direction.Axis.X;
        }
        return !recessed;
    }

    @Override
    public Vec3 getLocalOffset(BlockState state) {
        Direction side = this.getSide();
        Direction engineFacing = SteamEngineBlock.getFacing(state);
        float roll = 0.0f;
        for (Pointing p : Pointing.values()) {
            if (p.getCombinedDirection(engineFacing) != side) continue;
            roll = p.getXRotation();
        }
        if (engineFacing == Direction.UP) {
            roll += 180.0f;
        }
        float horizontalAngle = AngleHelper.horizontalAngle(engineFacing);
        float verticalAngle = AngleHelper.verticalAngle(engineFacing);
        Vec3 local = VecHelper.voxelSpace(8.0, 14.5, 9.0);
        local = VecHelper.rotateCentered(local, roll, Direction.Axis.Z);
        local = VecHelper.rotateCentered(local, horizontalAngle, Direction.Axis.Y);
        local = VecHelper.rotateCentered(local, verticalAngle, Direction.Axis.X);
        return local;
    }

    @Override
    public void rotate(BlockState state, PoseStack ms) {
        Direction facing = SteamEngineBlock.getFacing(state);
        if (facing.getAxis() == Direction.Axis.Y) {
            super.rotate(state, ms);
            return;
        }
        float roll = 0.0f;
        for (Pointing p : Pointing.values()) {
            if (p.getCombinedDirection(facing) != this.getSide()) continue;
            roll = p.getXRotation();
        }
        float yRot = AngleHelper.horizontalAngle(facing) + (float)(facing == Direction.DOWN ? 180 : 0);
        ((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).rotateYDegrees(yRot)).rotateXDegrees(facing == Direction.DOWN ? -90.0f : 90.0f)).rotateYDegrees(roll);
    }

    @Override
    protected Vec3 getSouthLocation() {
        return Vec3.ZERO;
    }
}

