/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.transmission;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.transmission.SplitShaftBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SplitShaftRenderer
implements BlockEntityRenderer<SplitShaftBlockEntity, SplitShaftRenderState> {
    public SplitShaftRenderer(BlockEntityRendererProvider.Context context) {
    }

    public SplitShaftRenderState createRenderState() {
        return new SplitShaftRenderState();
    }

    public void extractRenderState(SplitShaftBlockEntity be, SplitShaftRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        state.layer = RenderTypes.solidMovingBlock();
        state.color = KineticBlockEntityRenderer.getColor(be);
        Direction.Axis boxAxis = ((IRotate)state.blockState.getBlock()).getRotationAxis(state.blockState);
        BlockPos pos = state.blockPos;
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        float offset = KineticBlockEntityRenderer.getRotationOffsetForPosition(be, pos, boxAxis);
        float angle = time * be.getSpeed() * 3.0f / 10.0f % 360.0f;
        state.direction = switch (boxAxis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.Y -> Direction.UP;
            case Direction.Axis.Z -> Direction.SOUTH;
            case Direction.Axis.X -> Direction.EAST;
        };
        Direction bottom = switch (boxAxis) {
            default -> throw new MatchException(null, null);
            case Direction.Axis.Y -> Direction.DOWN;
            case Direction.Axis.Z -> Direction.NORTH;
            case Direction.Axis.X -> Direction.WEST;
        };
        state.top = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.blockState, state.direction);
        state.topAngle = SplitShaftRenderer.getAngle(be, angle, offset, state.direction);
        state.bottom = CachedBuffers.partialFacing(AllPartialModels.SHAFT_HALF, state.blockState, bottom);
        state.bottomAngle = SplitShaftRenderer.getAngle(be, angle, offset, bottom);
    }

    private static float getAngle(SplitShaftBlockEntity be, float angle, float offset, Direction direction) {
        angle *= be.getRotationSpeedModifier(direction);
        return (angle += offset) / 180.0f * (float)Math.PI;
    }

    public void submit(SplitShaftRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
    }

    public static class SplitShaftRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public Color color;
        public Direction direction;
        public SuperByteBuffer top;
        public float topAngle;
        public SuperByteBuffer bottom;
        public float bottomAngle;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.top.light(this.lightCoords);
            this.top.rotateCentered(this.topAngle, this.direction);
            this.top.color(this.color);
            this.top.renderInto(matricesEntry, vertexConsumer);
            this.bottom.light(this.lightCoords);
            this.bottom.rotateCentered(this.bottomAngle, this.direction);
            this.bottom.color(this.color);
            this.bottom.renderInto(matricesEntry, vertexConsumer);
        }
    }
}

