/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.transmission;

import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityVisual;
import com.zurrtum.create.client.content.kinetics.base.RotatingInstance;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.AbstractInstance;
import com.zurrtum.create.client.flywheel.lib.instance.FlatLit;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.content.kinetics.base.IRotate;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.kinetics.transmission.SplitShaftBlockEntity;
import java.util.ArrayList;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.Block;

public class SplitShaftVisual
extends KineticBlockEntityVisual<SplitShaftBlockEntity> {
    protected final ArrayList<RotatingInstance> keys = new ArrayList(2);

    public SplitShaftVisual(VisualizationContext modelManager, SplitShaftBlockEntity blockEntity, float partialTick) {
        super(modelManager, blockEntity, partialTick);
        float speed = blockEntity.getSpeed();
        for (Direction dir : Iterate.directionsInAxis(this.rotationAxis())) {
            float splitSpeed = speed * blockEntity.getRotationSpeedModifier(dir);
            RotatingInstance instance = this.instancerProvider().instancer(AllInstanceTypes.ROTATING, Models.partial(AllPartialModels.SHAFT_HALF)).createInstance();
            instance.setup((KineticBlockEntity)blockEntity, splitSpeed).setPosition((Vec3i)this.getVisualPosition()).rotateToFace(Direction.SOUTH, dir).setChanged();
            this.keys.add(instance);
        }
    }

    @Override
    public void update(float pt) {
        Block block = this.blockState.getBlock();
        Direction.Axis boxAxis = ((IRotate)block).getRotationAxis(this.blockState);
        Direction[] directions = Iterate.directionsInAxis(boxAxis);
        for (int i : Iterate.zeroAndOne) {
            this.keys.get(i).setup((KineticBlockEntity)this.blockEntity, ((SplitShaftBlockEntity)this.blockEntity).getSpeed() * ((SplitShaftBlockEntity)this.blockEntity).getRotationSpeedModifier(directions[i])).setChanged();
        }
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight((FlatLit[])this.keys.toArray(FlatLit[]::new));
    }

    @Override
    protected void _delete() {
        this.keys.forEach(AbstractInstance::delete);
        this.keys.clear();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        this.keys.forEach((Consumer<RotatingInstance>)consumer);
    }
}

