/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.turntable;

import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.content.kinetics.turntable.TurntableBlockEntity;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;

public class TurntableHandler {
    public static void gameRenderFrame(Minecraft mc) {
        if (mc.gameMode == null || mc.player == null) {
            return;
        }
        BlockPos pos = mc.player.blockPosition();
        if (!mc.level.getBlockState(pos).is((Block)AllBlocks.TURNTABLE)) {
            return;
        }
        if (!mc.player.onGround()) {
            return;
        }
        if (mc.isPaused()) {
            return;
        }
        BlockEntity blockEntity = mc.level.getBlockEntity(pos);
        if (!(blockEntity instanceof TurntableBlockEntity)) {
            return;
        }
        TurntableBlockEntity turnTable = (TurntableBlockEntity)blockEntity;
        float speed = turnTable.getSpeed() * 3.0f / 10.0f;
        if (speed == 0.0f) {
            return;
        }
        Vec3 origin = VecHelper.getCenterOf((Vec3i)pos);
        Vec3 offset = mc.player.position().subtract(origin);
        if (offset.length() > 0.25) {
            speed = (float)((double)speed * Mth.clamp((double)((0.5 - offset.length()) * 2.0), (double)0.0, (double)1.0));
        }
        mc.player.setYRot(mc.player.yRotO - speed * AnimationTickHolder.getPartialTicks());
        mc.player.yBodyRot = mc.player.getYRot();
    }
}

