/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.kinetics.waterwheel;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.registry.RegisteredObjectsHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.StitchedSprite;
import com.zurrtum.create.client.catnip.render.SuperBufferFactory;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.catnip.render.SuperByteBufferCache;
import com.zurrtum.create.client.content.kinetics.base.KineticBlockEntityRenderer;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.model.BakedModelHelper;
import com.zurrtum.create.content.kinetics.waterwheel.LargeWaterWheelBlock;
import com.zurrtum.create.content.kinetics.waterwheel.WaterWheelBlock;
import com.zurrtum.create.content.kinetics.waterwheel.WaterWheelBlockEntity;
import it.unimi.dsi.fastutil.objects.Reference2ReferenceOpenHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.BlockModelPart;
import net.minecraft.client.renderer.block.model.BlockStateModel;
import net.minecraft.client.renderer.block.model.SimpleModelWrapper;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.jetbrains.annotations.Nullable;

public class WaterWheelRenderer<T extends WaterWheelBlockEntity>
extends KineticBlockEntityRenderer<T, KineticBlockEntityRenderer.KineticRenderState> {
    public static final SuperByteBufferCache.Compartment<ModelKey> WATER_WHEEL = new SuperByteBufferCache.Compartment();
    public static final StitchedSprite OAK_PLANKS_TEMPLATE = new StitchedSprite(Identifier.parse((String)"block/oak_planks"));
    public static final StitchedSprite OAK_LOG_TEMPLATE = new StitchedSprite(Identifier.parse((String)"block/oak_log"));
    public static final StitchedSprite OAK_LOG_TOP_TEMPLATE = new StitchedSprite(Identifier.parse((String)"block/oak_log_top"));
    protected final boolean large;
    private static final String[] LOG_LOCATIONS = new String[]{"x_log", "x_stem", "x_block", "wood/log/x"};

    public WaterWheelRenderer(BlockEntityRendererProvider.Context context, boolean large) {
        super(context);
        this.large = large;
    }

    public static <T extends WaterWheelBlockEntity> WaterWheelRenderer<T> standard(BlockEntityRendererProvider.Context context) {
        return new WaterWheelRenderer<T>(context, false);
    }

    public static <T extends WaterWheelBlockEntity> WaterWheelRenderer<T> large(BlockEntityRendererProvider.Context context) {
        return new WaterWheelRenderer<T>(context, true);
    }

    @Override
    protected SuperByteBuffer getRotatedModel(T be, KineticBlockEntityRenderer.KineticRenderState state) {
        ModelKey key = new ModelKey(this.large, state.blockState, ((WaterWheelBlockEntity)be).material);
        return SuperByteBufferCache.getInstance().get(WATER_WHEEL, key, () -> {
            SimpleModelWrapper model = WaterWheelRenderer.generateModel(key);
            BlockState state1 = key.state();
            Direction dir = key.large() ? Direction.fromAxisAndDirection((Direction.Axis)((Direction.Axis)state1.getValue((Property)LargeWaterWheelBlock.AXIS)), (Direction.AxisDirection)Direction.AxisDirection.POSITIVE) : (Direction)state1.getValue((Property)WaterWheelBlock.FACING);
            PoseStack transform = CachedBuffers.rotateToFaceVertical(dir).get();
            return SuperBufferFactory.getInstance().createForBlock(model, Blocks.AIR.defaultBlockState(), transform);
        });
    }

    public static SimpleModelWrapper generateModel(ModelKey key) {
        return WaterWheelRenderer.generateModel(Variant.of(key.large(), key.state()), key.material());
    }

    public static SimpleModelWrapper generateModel(Variant variant, BlockState material) {
        return WaterWheelRenderer.generateModel(variant.model(), material);
    }

    public static SimpleModelWrapper generateModel(SimpleModelWrapper template, BlockState planksBlockState) {
        Block planksBlock = planksBlockState.getBlock();
        Identifier id = RegisteredObjectsHelper.getKeyOrThrow(planksBlock);
        String wood = WaterWheelRenderer.plankStateToWoodName(planksBlockState);
        if (wood == null) {
            return BakedModelHelper.generateModel(template, sprite -> null);
        }
        String namespace = id.getNamespace();
        BlockState logBlockState = WaterWheelRenderer.getLogBlockState(namespace, wood);
        Reference2ReferenceOpenHashMap map = new Reference2ReferenceOpenHashMap();
        map.put(OAK_PLANKS_TEMPLATE.get(), WaterWheelRenderer.getSpriteOnSide(planksBlockState, Direction.UP));
        map.put(OAK_LOG_TEMPLATE.get(), WaterWheelRenderer.getSpriteOnSide(logBlockState, Direction.SOUTH));
        map.put(OAK_LOG_TOP_TEMPLATE.get(), WaterWheelRenderer.getSpriteOnSide(logBlockState, Direction.UP));
        return BakedModelHelper.generateModel(template, ((Map)map)::get);
    }

    @Nullable
    private static String plankStateToWoodName(BlockState planksBlockState) {
        Block planksBlock = planksBlockState.getBlock();
        Identifier id = RegisteredObjectsHelper.getKeyOrThrow(planksBlock);
        String path = id.getPath();
        if (path.endsWith("_planks")) {
            return (path.startsWith("archwood") ? "blue_" : "") + path.substring(0, path.length() - 7);
        }
        if (path.contains("wood/planks/")) {
            return path.substring(12);
        }
        return null;
    }

    private static BlockState getLogBlockState(String namespace, String wood) {
        for (String location : LOG_LOCATIONS) {
            Optional<BlockState> state = BuiltInRegistries.BLOCK.get(ResourceKey.create((ResourceKey)Registries.BLOCK, (Identifier)Identifier.fromNamespaceAndPath((String)namespace, (String)location.replace("x", wood)))).map(Holder::value).map(Block::defaultBlockState);
            if (!state.isPresent()) continue;
            return state.get();
        }
        return Blocks.OAK_LOG.defaultBlockState();
    }

    private static TextureAtlasSprite getSpriteOnSide(BlockState state, Direction side) {
        List quads;
        BlockStateModel model = Minecraft.getInstance().getBlockRenderer().getBlockModel(state);
        if (model == null) {
            return null;
        }
        RandomSource random = RandomSource.create();
        random.setSeed(42L);
        List parts = model.collectParts(random);
        for (BlockModelPart part : parts) {
            quads = part.getQuads(side);
            if (quads.isEmpty()) continue;
            return ((BakedQuad)quads.getFirst()).sprite();
        }
        random.setSeed(42L);
        for (BlockModelPart part : parts) {
            quads = part.getQuads(null);
            if (quads.isEmpty()) continue;
            for (BakedQuad quad : quads) {
                if (quad.direction() != side) continue;
                return quad.sprite();
            }
        }
        return model.particleIcon();
    }

    public record ModelKey(boolean large, BlockState state, BlockState material) {
    }

    public static enum Variant {
        SMALL(AllPartialModels.WATER_WHEEL),
        LARGE(AllPartialModels.LARGE_WATER_WHEEL),
        LARGE_EXTENSION(AllPartialModels.LARGE_WATER_WHEEL_EXTENSION);

        private final PartialModel partial;

        private Variant(PartialModel partial) {
            this.partial = partial;
        }

        public SimpleModelWrapper model() {
            return this.partial.get();
        }

        public static Variant of(boolean large, BlockState blockState) {
            if (large) {
                boolean extension = (Boolean)blockState.getValue((Property)LargeWaterWheelBlock.EXTENSION);
                if (extension) {
                    return LARGE_EXTENSION;
                }
                return LARGE;
            }
            return SMALL;
        }
    }
}

