/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.content.logistics.AddressEditBoxHelper;
import com.zurrtum.create.client.content.trains.schedule.DestinationSuggestions;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.input.MouseButtonInfo;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.util.Mth;

public class AddressEditBox
extends EditBox {
    private final DestinationSuggestions destinationSuggestions;
    private final Consumer<String> mainResponder;
    private String prevValue = "=)";

    public AddressEditBox(Screen screen, Font pFont, int pX, int pY, int pWidth, int pHeight, boolean anchorToBottom) {
        this(screen, pFont, pX, pY, pWidth, pHeight, anchorToBottom, null);
    }

    public AddressEditBox(Screen screen, Font pFont, int pX, int pY, int pWidth, int pHeight, boolean anchorToBottom, String localAddress) {
        super(pFont, pX, pY, pWidth, pHeight, (Component)Component.empty());
        this.destinationSuggestions = AddressEditBoxHelper.createSuggestions(screen, this, anchorToBottom, localAddress);
        this.destinationSuggestions.setAllowSuggestions(true);
        this.destinationSuggestions.updateCommandInfo();
        this.mainResponder = t -> {
            if (!t.equals(this.prevValue)) {
                this.destinationSuggestions.updateCommandInfo();
            }
            this.prevValue = t;
        };
        this.setResponder(this.mainResponder);
        this.setBordered(false);
        this.setFocused(false);
        this.mouseClicked(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)), false);
        this.setMaxLength(25);
    }

    public boolean keyPressed(KeyEvent input) {
        if (this.destinationSuggestions.keyPressed(input)) {
            return true;
        }
        if (this.isFocused() && input.key() == 257) {
            this.setFocused(false);
            this.moveCursorToEnd(false);
            this.mouseClicked(new MouseButtonEvent(0.0, 0.0, new MouseButtonInfo(0, 0)), false);
            return true;
        }
        return super.keyPressed(input);
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.destinationSuggestions.mouseScrolled(Mth.clamp((double)scrollY, (double)-1.0, (double)1.0))) {
            return true;
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        if (click.button() == 1 && this.isMouseOver(click.x(), click.y())) {
            this.setValue("");
            return true;
        }
        boolean wasFocused = this.isFocused();
        if (super.mouseClicked(click, doubled)) {
            if (!wasFocused) {
                this.setHighlightPos(0);
                this.setCursorPosition(this.getValue().length());
            }
            return true;
        }
        return this.destinationSuggestions.mouseClicked(click);
    }

    public void setValue(String text) {
        this.setHighlightPos(0);
        super.setValue(text);
    }

    public void setFocused(boolean focused) {
        super.setFocused(focused);
    }

    public void renderWidget(GuiGraphics pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        super.renderWidget(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        this.destinationSuggestions.render(pGuiGraphics, pMouseX, pMouseY);
        if (!this.destinationSuggestions.isEmpty()) {
            return;
        }
        int itemX = this.getX() + this.width + 4;
        int itemY = this.getY() - 4;
        pGuiGraphics.renderItem(AllItems.CLIPBOARD.getDefaultInstance(), itemX, itemY);
        if (pMouseX >= itemX && pMouseX < itemX + 16 && pMouseY >= itemY && pMouseY < itemY + 16) {
            List<MutableComponent> promiseTip = List.of(CreateLang.translate("gui.address_box.clipboard_tip", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.address_box.clipboard_tip_1", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.address_box.clipboard_tip_2", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.address_box.clipboard_tip_3", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.address_box.clipboard_tip_4", new Object[0]).style(ChatFormatting.DARK_GRAY).component());
            pGuiGraphics.setComponentTooltipForNextFrame(this.font, promiseTip, pMouseX, pMouseY);
        }
    }

    public void setResponder(Consumer<String> pResponder) {
        super.setResponder(pResponder == this.mainResponder ? this.mainResponder : this.mainResponder.andThen(pResponder));
    }

    public void tick() {
        if (!this.isFocused()) {
            this.destinationSuggestions.hide();
        }
        if (this.isFocused() && this.destinationSuggestions.suggestions == null) {
            this.destinationSuggestions.updateCommandInfo();
        }
        this.destinationSuggestions.tick();
    }
}

