/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.box;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.logistics.box.PackageEntity;
import com.zurrtum.create.content.logistics.box.PackageItem;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;

public class PackageVisual
extends AbstractEntityVisual<PackageEntity>
implements SimpleDynamicVisual {
    public final TransformedInstance instance;

    public PackageVisual(VisualizationContext ctx, PackageEntity entity, float partialTick) {
        super(ctx, entity, partialTick);
        ItemStack box = entity.box;
        if (box.isEmpty() || !PackageItem.isPackage(box)) {
            box = AllItems.CARDBOARD_BLOCK.getDefaultInstance();
        }
        PartialModel model = AllPartialModels.PACKAGES.get(BuiltInRegistries.ITEM.getKey((Object)box.getItem()));
        this.instance = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(model)).createInstance();
        this.animate(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    private void animate(float partialTick) {
        float yaw = Mth.lerp((float)partialTick, (float)((PackageEntity)this.entity).yRotO, (float)((PackageEntity)this.entity).getYRot());
        Vec3 pos = ((PackageEntity)this.entity).position();
        Vec3i renderOrigin = this.renderOrigin();
        float x = (float)(Mth.lerp((double)partialTick, (double)((PackageEntity)this.entity).xo, (double)pos.x) - (double)renderOrigin.getX());
        float y = (float)(Mth.lerp((double)partialTick, (double)((PackageEntity)this.entity).yo, (double)pos.y) - (double)renderOrigin.getY());
        float z = (float)(Mth.lerp((double)partialTick, (double)((PackageEntity)this.entity).zo, (double)pos.z) - (double)renderOrigin.getZ());
        long randomBits = (long)((PackageEntity)this.entity).getId() * 31L * 493286711L;
        randomBits = randomBits * randomBits * 4392167121L + randomBits * 98761L;
        float xNudge = (((float)(randomBits >> 16 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float yNudge = (((float)(randomBits >> 20 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        float zNudge = (((float)(randomBits >> 24 & 7L) + 0.5f) / 8.0f - 0.5f) * 0.004f;
        ((TransformedInstance)((TransformedInstance)this.instance.setIdentityTransform().translate((double)x - 0.5 + (double)xNudge, (double)(y + yNudge), (double)z - 0.5 + (double)zNudge)).rotateYCenteredDegrees(-yaw - 90.0f)).light(this.computePackedLight(partialTick)).setChanged();
    }

    @Override
    protected void _delete() {
        this.instance.delete();
    }
}

