/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.chute;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.chute.ChuteBlock;
import com.zurrtum.create.content.logistics.chute.ChuteBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class ChuteRenderer
implements BlockEntityRenderer<ChuteBlockEntity, ChuteRenderState> {
    protected final ItemModelResolver itemModelManager;

    public ChuteRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public ChuteRenderState createRenderState() {
        return new ChuteRenderState();
    }

    public void extractRenderState(ChuteBlockEntity be, ChuteRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        boolean notWindow;
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        ItemStack item = be.getItem();
        if (item.isEmpty()) {
            return;
        }
        if (state.blockState.getValue(ChuteBlock.FACING) != Direction.DOWN) {
            return;
        }
        boolean bl = notWindow = state.blockState.getValue(ChuteBlock.SHAPE) != ChuteBlock.Shape.WINDOW;
        if (notWindow && be.bottomPullDistance == 0.0f) {
            return;
        }
        float itemPosition = be.itemPosition.getValue(tickProgress);
        if (notWindow && itemPosition > 0.5f) {
            return;
        }
        state.item = ChuteItemRenderState.create(this.itemModelManager, item, itemPosition, be.getLevel());
    }

    public void submit(ChuteRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.item != null) {
            state.item.render(matrices, queue, state.lightCoords);
        }
    }

    public static class ChuteRenderState
    extends BlockEntityRenderState {
        public ChuteItemRenderState item;
    }

    public record ChuteItemRenderState(ItemStackRenderState item, float offset, float rotate) {
        public static ChuteItemRenderState create(ItemModelResolver itemModelManager, ItemStack stack, float itemPosition, Level world) {
            float offset = itemPosition - 0.5f;
            float rotate = PackageItem.isPackage(stack) ? -1.0f : (float)Math.PI / 180 * itemPosition * 180.0f;
            ItemStackRenderState item = new ItemStackRenderState();
            item.displayContext = ItemDisplayContext.FIXED;
            itemModelManager.appendItemLayers(item, stack, item.displayContext, world, null, 0);
            return new ChuteItemRenderState(item, offset, rotate);
        }

        public void render(PoseStack matrices, SubmitNodeCollector queue, int light) {
            matrices.pushPose();
            matrices.translate(0.5f, 0.5f, 0.5f);
            matrices.translate(0.0f, this.offset, 0.0f);
            if (this.rotate == -1.0f) {
                matrices.scale(1.5f, 1.5f, 1.5f);
            } else {
                matrices.scale(0.5f, 0.5f, 0.5f);
                matrices.mulPose((Quaternionfc)Axis.XP.rotation(this.rotate));
                matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.rotate));
            }
            this.item.submit(matrices, queue, light, OverlayTexture.NO_OVERLAY, 0);
            matrices.popPose();
        }
    }
}

