/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.depot;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.content.kinetics.belt.BeltHelper;
import com.zurrtum.create.content.kinetics.belt.transport.TransportedItemStack;
import com.zurrtum.create.content.logistics.box.PackageItem;
import com.zurrtum.create.content.logistics.depot.DepotBehaviour;
import com.zurrtum.create.content.logistics.depot.DepotBlockEntity;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.BiConsumer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class DepotRenderer
implements BlockEntityRenderer<DepotBlockEntity, DepotRenderState> {
    protected final ItemModelResolver itemModelManager;

    public DepotRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public DepotRenderState createRenderState() {
        return new DepotRenderState();
    }

    public void extractRenderState(DepotBlockEntity be, DepotRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        state.blockPos = be.getBlockPos();
        state.blockEntityType = be.getType();
        Level world = be.getLevel();
        state.lightCoords = world != null ? LevelRenderer.getLightColor((BlockAndTintGetter)world, (BlockPos)state.blockPos) : 0xF000F0;
        DepotBehaviour depotBehaviour = be.depotBehaviour;
        state.incoming = DepotRenderer.createIncomingStateList(depotBehaviour, this.itemModelManager, tickProgress, world);
        state.outputs = DepotRenderer.createOutputStateList(depotBehaviour, this.itemModelManager, world);
    }

    @Nullable
    public static DepotItemState[] createIncomingStateList(DepotBehaviour depotBehaviour, ItemModelResolver itemModelManager, float tickProgress, Level world) {
        boolean notHeld;
        List<TransportedItemStack> incomingList = depotBehaviour.incoming;
        int incomingSize = incomingList.size();
        TransportedItemStack heldItem = depotBehaviour.heldItem;
        boolean bl = notHeld = heldItem == null;
        if (incomingSize == 0 && notHeld) {
            return null;
        }
        DepotItemState[] incoming = new DepotItemState[notHeld ? incomingSize : incomingSize + 1];
        for (int i = 0; i < incomingSize; ++i) {
            incoming[i] = DepotItemState.create(itemModelManager, incomingList.get(i), tickProgress, world);
        }
        if (!notHeld) {
            incoming[incomingSize] = DepotItemState.create(itemModelManager, heldItem, tickProgress, world);
        }
        return incoming;
    }

    @Nullable
    public static List<DepotOutputItemState> createOutputStateList(DepotBehaviour depotBehaviour, ItemModelResolver itemModelManager, Level world) {
        ArrayList<DepotOutputItemState> outputs = null;
        Iterator iterator = depotBehaviour.processingOutputBuffer.iterator();
        while (iterator.hasNext()) {
            ItemStack stack = (ItemStack)iterator.next();
            if (stack.isEmpty()) continue;
            if (outputs == null) {
                outputs = new ArrayList<DepotOutputItemState>();
            }
            outputs.add(DepotOutputItemState.create(itemModelManager, stack, world));
        }
        return outputs;
    }

    public void submit(DepotRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.incoming != null || state.outputs != null) {
            DepotRenderer.renderItemsOf(state.incoming, state.outputs, state.blockPos, cameraState.pos, queue, matrices, state.lightCoords);
        }
    }

    public static void renderItemsOf(DepotItemState[] incoming, List<DepotOutputItemState> outputs, BlockPos pos, Vec3 cameraPos, SubmitNodeCollector queue, PoseStack ms, int light) {
        PoseTransformStack msr = TransformStack.of(ms);
        Vec3 itemPosition = VecHelper.getCenterOf((Vec3i)pos);
        ms.pushPose();
        ms.translate(0.5f, 0.9375f, 0.5f);
        if (incoming != null) {
            for (DepotItemState item : incoming) {
                ms.pushPose();
                msr.nudge(0);
                if (item.offset != null) {
                    ms.translate(item.offset.x, item.offset.y, item.offset.z);
                }
                DepotRenderer.renderItem(queue, ms, light, item.state, item.angle, item.upright, item.box, item.count, new Random(0L), itemPosition, cameraPos, false, null);
                ms.popPose();
            }
        }
        if (outputs != null) {
            int size = outputs.size();
            for (int i = 0; i < size; ++i) {
                DepotOutputItemState item = outputs.get(i);
                ms.pushPose();
                msr.nudge(i);
                boolean renderUpright = item.upright;
                msr.rotateYDegrees(45.0f * (float)i);
                ms.translate(0.35f, 0.0f, 0.0f);
                if (renderUpright) {
                    msr.rotateYDegrees(-(45.0f * (float)i));
                }
                Random r = new Random(i + 1);
                int angle = (int)(360.0f * r.nextFloat());
                DepotRenderer.renderItem(queue, ms, light, item.state, renderUpright ? angle + 90 : angle, item.upright, item.box, item.count, r, itemPosition, cameraPos, false, null);
                ms.popPose();
            }
        }
        ms.popPose();
    }

    public static void renderItem(SubmitNodeCollector queue, PoseStack ms, int light, ItemStackRenderState state, int angle, boolean upright, boolean box, int count, Random r, Vec3 itemPosition, Vec3 cameraPos, boolean alwaysUpright, BiConsumer<PoseTransformStack, Boolean> transform) {
        boolean blockItem = state.usesBlockLight();
        PoseTransformStack msr = TransformStack.of(ms);
        if (transform != null) {
            transform.accept(msr, blockItem);
        }
        boolean renderUpright = upright || alwaysUpright && !blockItem;
        ms.pushPose();
        msr.rotateYDegrees(angle);
        if (renderUpright) {
            Vec3 diff = itemPosition.subtract(cameraPos);
            float yRot = (float)(Mth.atan2((double)diff.x, (double)diff.z) + Math.PI);
            ms.mulPose((Quaternionfc)Axis.YP.rotation(yRot));
            ms.translate(0.0, 0.09375, -0.0625);
        }
        for (int i = 0; i <= count; ++i) {
            ms.pushPose();
            if (blockItem && r != null) {
                ms.translate(r.nextFloat() * 0.0625f * (float)i, 0.0f, r.nextFloat() * 0.0625f * (float)i);
            }
            if (box && !alwaysUpright) {
                ms.translate(0.0f, 0.25f, 0.0f);
                ms.scale(1.5f, 1.5f, 1.5f);
            } else if (blockItem && alwaysUpright) {
                ms.translate(0.0f, 0.0625f, 0.0f);
                ms.scale(0.755f, 0.755f, 0.755f);
            } else {
                ms.scale(0.5f, 0.5f, 0.5f);
            }
            if (!blockItem && !renderUpright) {
                ms.translate(0.0f, -0.1875f, 0.0f);
                msr.rotateXDegrees(90.0f);
            }
            state.submit(ms, queue, light, OverlayTexture.NO_OVERLAY, 0);
            ms.popPose();
            if (!renderUpright) {
                if (!blockItem) {
                    msr.rotateYDegrees(10.0f);
                }
                ms.translate(0.0, blockItem ? 0.015625 : 0.0625, 0.0);
                continue;
            }
            ms.translate(0.0f, 0.0f, -0.0625f);
        }
        ms.popPose();
    }

    public static class DepotRenderState
    extends BlockEntityRenderState {
        public DepotItemState[] incoming;
        public List<DepotOutputItemState> outputs;
    }

    public record DepotItemState(ItemStackRenderState state, int angle, Vec3 offset, boolean upright, boolean box, int count) {
        public static DepotItemState create(ItemModelResolver itemModelManager, TransportedItemStack tis, float partialTicks, Level world) {
            Vec3 offsetVec;
            if (tis.insertedFrom.getAxis().isHorizontal()) {
                boolean alongX;
                float offset = Mth.lerp((float)partialTicks, (float)tis.prevBeltPosition, (float)tis.beltPosition);
                float sideOffset = Mth.lerp((float)partialTicks, (float)tis.prevSideOffset, (float)tis.sideOffset);
                boolean bl = alongX = tis.insertedFrom.getClockWise().getAxis() == Direction.Axis.X;
                if (!alongX) {
                    sideOffset *= -1.0f;
                }
                offsetVec = Vec3.atLowerCornerOf((Vec3i)tis.insertedFrom.getOpposite().getUnitVec3i()).scale((double)(0.5f - offset)).add(alongX ? (double)sideOffset : 0.0, 0.0, alongX ? 0.0 : (double)sideOffset);
            } else {
                offsetVec = null;
            }
            ItemStack stack = tis.stack;
            ItemStackRenderState state = new ItemStackRenderState();
            state.displayContext = ItemDisplayContext.FIXED;
            itemModelManager.appendItemLayers(state, stack, state.displayContext, world, null, 0);
            boolean upright = BeltHelper.isItemUpright(stack);
            boolean box = PackageItem.isPackage(stack);
            int count = Mth.log2((int)stack.getCount()) / 2;
            return new DepotItemState(state, tis.angle, offsetVec, upright, box, count);
        }
    }

    public record DepotOutputItemState(ItemStackRenderState state, boolean upright, boolean box, int count) {
        public static DepotOutputItemState create(ItemModelResolver itemModelManager, ItemStack stack, Level world) {
            ItemStackRenderState state = new ItemStackRenderState();
            state.displayContext = ItemDisplayContext.FIXED;
            itemModelManager.appendItemLayers(state, stack, state.displayContext, world, null, 0);
            boolean upright = BeltHelper.isItemUpright(stack);
            boolean box = PackageItem.isPackage(stack);
            int count = Mth.log2((int)stack.getCount()) / 2;
            return new DepotOutputItemState(state, upright, box, count);
        }
    }
}

