/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.depot;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.logistics.depot.EjectorBlock;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class EjectorSlot
extends ValueBoxTransform.Sided {
    private final EjectorBlockEntity blockEntity;

    public EjectorSlot(EjectorBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    @Override
    public Vec3 getLocalOffset(BlockState state) {
        if (this.direction != Direction.UP) {
            return super.getLocalOffset(state);
        }
        return new Vec3(0.5, 0.65625, 0.5).add(VecHelper.rotate(VecHelper.voxelSpace(0.0, 0.0, -5.0), this.angle(state), Direction.Axis.Y));
    }

    @Override
    public void rotate(BlockState state, PoseStack ms) {
        if (this.direction != Direction.UP) {
            super.rotate(state, ms);
            return;
        }
        ((PoseTransformStack)TransformStack.of(ms).rotateYDegrees(this.angle(state))).rotateXDegrees(90.0f);
    }

    protected float angle(BlockState state) {
        return state.is((Block)AllBlocks.WEIGHTED_EJECTOR) ? AngleHelper.horizontalAngle((Direction)state.getValue((Property)EjectorBlock.HORIZONTAL_FACING)) : 0.0f;
    }

    @Override
    protected boolean isSideActive(BlockState state, Direction direction) {
        return direction.getAxis() == ((Direction)state.getValue((Property)EjectorBlock.HORIZONTAL_FACING)).getAxis() || direction == Direction.UP && this.blockEntity.getState() != EjectorBlockEntity.State.CHARGED;
    }

    @Override
    protected Vec3 getSouthLocation() {
        return this.direction == Direction.UP ? Vec3.ZERO : VecHelper.voxelSpace(8.0, 6.0, 15.5);
    }
}

