/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.depot;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.kinetics.base.ShaftVisual;
import com.zurrtum.create.client.content.logistics.depot.EjectorRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.kinetics.base.KineticBlockEntity;
import com.zurrtum.create.content.logistics.depot.EjectorBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.Vec3i;

public class EjectorVisual
extends ShaftVisual<EjectorBlockEntity>
implements SimpleDynamicVisual {
    protected final TransformedInstance plate;
    private float lastProgress = Float.NaN;

    public EjectorVisual(VisualizationContext dispatcher, EjectorBlockEntity blockEntity, float partialTick) {
        super(dispatcher, blockEntity, partialTick);
        this.plate = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.EJECTOR_TOP)).createInstance();
        this.pivotPlate(this.getLidProgress(partialTick));
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        float lidProgress = this.getLidProgress(ctx.partialTick());
        if (lidProgress == this.lastProgress) {
            return;
        }
        this.pivotPlate(lidProgress);
        this.lastProgress = lidProgress;
    }

    @Override
    public void updateLight(float partialTick) {
        super.updateLight(partialTick);
        this.relight(this.plate);
    }

    @Override
    protected void _delete() {
        super._delete();
        this.plate.delete();
    }

    private float getLidProgress(float pt) {
        return ((EjectorBlockEntity)this.blockEntity).getLidProgress(pt);
    }

    private void pivotPlate(float lidProgress) {
        float angle = lidProgress * 70.0f;
        EjectorRenderer.applyLidAngle((KineticBlockEntity)this.blockEntity, angle, (TransformedInstance)this.plate.setIdentityTransform().translate((Vec3i)this.getVisualPosition()));
        this.plate.setChanged();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        super.collectCrumblingInstances(consumer);
        consumer.accept(this.plate);
    }
}

