/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.factoryBoard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.client.foundation.render.CreateRenderTypes;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlockEntity;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSupportBehaviour;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.content.redstone.displayLink.DisplayLinkBlockEntity;
import com.zurrtum.create.content.redstone.link.RedstoneLinkBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class FactoryPanelRenderer
extends SmartBlockEntityRenderer<FactoryPanelBlockEntity, FactoryPanelRenderState> {
    public FactoryPanelRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public FactoryPanelRenderState createRenderState() {
        return new FactoryPanelRenderState();
    }

    @Override
    public void extractRenderState(FactoryPanelBlockEntity be, FactoryPanelRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        ArrayList<SingleFactoryPanelRenderState> panels = new ArrayList<SingleFactoryPanelRenderState>();
        boolean[] layers = new boolean[3];
        for (ServerFactoryPanelBehaviour behaviour : be.panels.values()) {
            boolean target;
            if (!behaviour.isActive()) continue;
            boolean bulb = behaviour.getAmount() > 0;
            boolean bl = target = !behaviour.targetedBy.isEmpty() || !behaviour.targetedByLinks.isEmpty();
            if (!target && !bulb) continue;
            SingleFactoryPanelRenderState panel = new SingleFactoryPanelRenderState();
            boolean missingAddress = behaviour.isMissingAddress();
            float offsetX = (float)behaviour.slot.xOffset * 0.5f;
            float offsetY = (float)behaviour.slot.yOffset * 0.5f;
            float glow = behaviour.bulb.getValue(tickProgress);
            if (target) {
                List<Direction> path;
                layers[0] = true;
                panel.offsetX = offsetX + 0.25f;
                panel.offsetY = offsetY + 0.25f;
                panel.paths = new ArrayList<PathRenderState>();
                ArrayList<PathRenderState> paths = panel.paths;
                Level world = behaviour.getLevel();
                FactoryPanelPosition to = behaviour.getPanelPosition();
                FactoryPanelBehaviour fromBehaviour = be.getBehaviour(FactoryPanelBehaviour.getTypeForSlot(behaviour.slot));
                Vec3 start = fromBehaviour.getSlotPositioning().getLocalOffset(state.blockState).add(Vec3.atLowerCornerOf((Vec3i)state.blockPos));
                for (FactoryPanelConnection connection : behaviour.targetedBy.values()) {
                    path = connection.getPath(world, state.blockState, to, start);
                    if (path.isEmpty()) continue;
                    paths.add(FactoryPanelRenderer.getPathRenderState(behaviour, connection, path, world, state.blockState, missingAddress, glow));
                }
                for (FactoryPanelConnection connection : behaviour.targetedByLinks.values()) {
                    path = connection.getPath(world, state.blockState, to, start);
                    if (path.isEmpty()) continue;
                    paths.add(FactoryPanelRenderer.getPathRenderState(behaviour, connection, path, world, state.blockState, missingAddress, glow));
                }
            }
            if (bulb) {
                panel.bulb = FactoryPanelRenderer.getBulbRenderState(behaviour, state.blockState, missingAddress, offsetX, offsetY, glow, layers);
            }
            panels.add(panel);
        }
        if (panels.isEmpty()) {
            return;
        }
        state.xRot = FactoryPanelBlock.getXRot(state.blockState) + 1.5707964f;
        state.yRot = FactoryPanelBlock.getYRot(state.blockState);
        state.panels = panels;
        if (layers[0]) {
            state.cutout = RenderTypes.cutoutMovingBlock();
        }
        if (layers[1]) {
            state.translucent1 = RenderTypes.translucentMovingBlock();
        }
        if (layers[2]) {
            state.translucent2 = CreateRenderTypes.translucent();
            state.additive = CreateRenderTypes.additive();
        }
    }

    @Override
    public void submit(FactoryPanelRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.panels != null) {
            if (state.cutout != null) {
                queue.submitCustomGeometry(matrices, state.cutout, state::renderCutout);
            }
            if (state.translucent1 != null) {
                queue.submitCustomGeometry(matrices, state.translucent1, state::renderTranslucent1);
            }
            if (state.additive != null) {
                queue.submitCustomGeometry(matrices, state.translucent2, state::renderTranslucent2);
                queue.submitCustomGeometry(matrices, state.additive, state::renderAdditive);
            }
        }
    }

    public static BulbRenderState getBulbRenderState(ServerFactoryPanelBehaviour behaviour, BlockState blockState, boolean missingAddress, float offsetX, float offsetY, float glow, boolean[] layers) {
        BulbRenderState state = new BulbRenderState();
        PartialModel partial = behaviour.redstonePowered || missingAddress ? AllPartialModels.FACTORY_PANEL_RED_LIGHT : AllPartialModels.FACTORY_PANEL_LIGHT;
        state.model = CachedBuffers.partial(partial, blockState);
        state.offsetX = offsetX;
        state.offsetY = offsetY;
        if (glow < 0.125f) {
            layers[1] = true;
            return state;
        }
        layers[2] = true;
        state.glow = true;
        glow = (float)(1.0 - 2.0 * Math.pow(glow - 0.75f, 2.0));
        glow = Mth.clamp((float)glow, (float)-1.0f, (float)1.0f);
        state.color = (int)(200.0f * glow);
        return state;
    }

    public static PathRenderState getPathRenderState(ServerFactoryPanelBehaviour behaviour, FactoryPanelConnection connection, List<Direction> path, Level world, BlockState blockState, boolean missingAddress, float glow) {
        float yOffset;
        boolean dots;
        int color;
        boolean pathReversed;
        PathRenderState state = new PathRenderState();
        FactoryPanelSupportBehaviour sbe = ServerFactoryPanelBehaviour.linkAt((BlockAndTintGetter)world, connection);
        boolean displayLinkMode = sbe != null && sbe.blockEntity instanceof DisplayLinkBlockEntity;
        boolean redstoneLinkMode = sbe != null && sbe.blockEntity instanceof RedstoneLinkBlockEntity;
        boolean bl = pathReversed = sbe != null && !sbe.isOutput();
        if (displayLinkMode) {
            color = 3971154;
            dots = true;
            yOffset = 0.0f;
        } else if (redstoneLinkMode) {
            color = pathReversed ? (behaviour.count == 0 ? 0x888898 : (behaviour.satisfied ? 0xEF0000 : 5767425)) : (behaviour.redstonePowered ? 0xEF0000 : 5767425);
            dots = false;
            yOffset = 0.5f;
        } else {
            color = behaviour.getIngredientStatusColor();
            dots = false;
            yOffset = 1 + (behaviour.promisedSatisfied ? 1 : (behaviour.satisfied ? 0 : 2));
            if (!behaviour.redstonePowered && !behaviour.waitingForNetwork && glow > 0.0f && !behaviour.satisfied) {
                float p = 1.0f - (1.0f - glow) * (1.0f - glow);
                boolean success = connection.success;
                color = Color.mixColors(color, success ? 15397612 : 15033675, p);
                if (!behaviour.promisedSatisfied) {
                    yOffset += (float)(success ? 1 : 2) * p;
                }
            }
        }
        state.shiftUV = !displayLinkMode && !redstoneLinkMode && !missingAddress && !behaviour.waitingForNetwork && !behaviour.satisfied && !behaviour.redstonePowered;
        state.color = color;
        float currentX = 0.0f;
        float currentZ = 0.0f;
        state.lines = new ArrayList<LineRenderData>();
        ArrayList<LineRenderData> lines = state.lines;
        int size = path.size();
        int end = size - 1;
        for (int i = 0; i < size; ++i) {
            Direction direction = path.get(i);
            if (!pathReversed) {
                currentX += (float)direction.getStepX() * 0.5f;
                currentZ += (float)direction.getStepZ() * 0.5f;
            }
            Map<Direction, PartialModel> group = dots ? AllPartialModels.FACTORY_PANEL_DOTTED : ((pathReversed ? i == end : i == 0) ? AllPartialModels.FACTORY_PANEL_ARROWS : AllPartialModels.FACTORY_PANEL_LINES);
            PartialModel partial = group.get(pathReversed ? direction : direction.getOpposite());
            SuperByteBuffer model = CachedBuffers.partial(partial, blockState);
            float currentY = (yOffset + (float)(direction.get2DDataValue() % 2) * 0.125f) / 512.0f;
            lines.add(new LineRenderData(model, currentX, currentY, currentZ));
            if (!pathReversed) continue;
            currentX += (float)direction.getStepX() * 0.5f;
            currentZ += (float)direction.getStepZ() * 0.5f;
        }
        return state;
    }

    public static class FactoryPanelRenderState
    extends SmartBlockEntityRenderer.SmartRenderState {
        public RenderType cutout;
        public RenderType translucent1;
        public RenderType translucent2;
        public RenderType additive;
        public float xRot;
        public float yRot;
        public List<SingleFactoryPanelRenderState> panels;

        public void renderCutout(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            for (SingleFactoryPanelRenderState panel : this.panels) {
                panel.renderPaths(matricesEntry, vertexConsumer, this.xRot, this.yRot, this.lightCoords);
            }
        }

        public void renderTranslucent1(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            for (SingleFactoryPanelRenderState panel : this.panels) {
                panel.renderBulb(false, matricesEntry, vertexConsumer, this.xRot, this.yRot, this.lightCoords);
            }
        }

        public void renderTranslucent2(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            for (SingleFactoryPanelRenderState panel : this.panels) {
                panel.renderBulb(true, matricesEntry, vertexConsumer, this.xRot, this.yRot, this.lightCoords);
            }
        }

        public void renderAdditive(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            for (SingleFactoryPanelRenderState panel : this.panels) {
                panel.renderGlow(matricesEntry, vertexConsumer, this.xRot, this.yRot);
            }
        }
    }

    public static class SingleFactoryPanelRenderState {
        public float offsetX;
        public float offsetY;
        public List<PathRenderState> paths;
        public BulbRenderState bulb;

        public void renderPaths(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer, float xRot, float yRot, int light) {
            if (this.paths != null) {
                for (PathRenderState path : this.paths) {
                    path.render(matricesEntry, vertexConsumer, xRot, yRot, this.offsetX, this.offsetY, light);
                }
            }
        }

        public void renderBulb(boolean glow, PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer, float xRot, float yRot, int light) {
            if (this.bulb != null) {
                this.bulb.renderBulb(glow, matricesEntry, vertexConsumer, xRot, yRot, light);
            }
        }

        public void renderGlow(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer, float xRot, float yRot) {
            if (this.bulb != null) {
                this.bulb.renderGlow(matricesEntry, vertexConsumer, xRot, yRot);
            }
        }
    }

    public static class PathRenderState {
        public boolean shiftUV;
        public int color;
        public List<LineRenderData> lines;

        public void render(PoseStack.Pose entry, VertexConsumer vertexConsumer, float xRot, float yRot, float offsetX, float offsetY, int light) {
            for (LineRenderData line : this.lines) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)line.model.rotateCentered(yRot, Direction.UP)).rotateCentered(xRot, Direction.EAST)).rotateCentered((float)Math.PI, Direction.UP)).translate(offsetX, 0.0f, offsetY)).translate(line.x, line.y, line.z);
                if (this.shiftUV) {
                    line.model.shiftUV(AllSpriteShifts.FACTORY_PANEL_CONNECTIONS);
                }
                line.model.color(this.color).light(light).overlay(OverlayTexture.NO_OVERLAY).renderInto(entry, vertexConsumer);
            }
        }
    }

    public static class BulbRenderState {
        public SuperByteBuffer model;
        public float offsetX;
        public float offsetY;
        public boolean glow;
        public int color;

        public void renderBulb(boolean glow, PoseStack.Pose entry, VertexConsumer vertexConsumer, float xRot, float yRot, int light) {
            if (glow == this.glow) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.model.rotateCentered(yRot, Direction.UP)).rotateCentered(xRot, Direction.EAST)).rotateCentered((float)Math.PI, Direction.UP)).translate(this.offsetX, 0.0f, this.offsetY)).light(glow ? 0xF000F0 : light).overlay(OverlayTexture.NO_OVERLAY).renderInto(entry, vertexConsumer);
            }
        }

        private void renderGlow(PoseStack.Pose entry, VertexConsumer vertexConsumer, float xRot, float yRot) {
            if (this.glow) {
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.model.rotateCentered(yRot, Direction.UP)).rotateCentered(xRot, Direction.EAST)).rotateCentered((float)Math.PI, Direction.UP)).translate(this.offsetX, 0.0f, this.offsetY)).light(0xF000F0).color(this.color, this.color, this.color, 255).overlay(OverlayTexture.NO_OVERLAY).renderInto(entry, vertexConsumer);
            }
        }
    }

    public record LineRenderData(SuperByteBuffer model, float x, float y, float z) {
    }
}

