/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.factoryBoard;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.content.logistics.AddressEditBox;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelConnectionHandler;
import com.zurrtum.create.client.content.trains.station.NoShadowFontWrapper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.BigItemStack;
import com.zurrtum.create.content.logistics.box.PackageStyles;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelConnection;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.infrastructure.packet.c2s.FactoryPanelConfigurationPacket;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3x2fStack;

public class FactoryPanelScreen
extends AbstractSimiScreen {
    private ElementWidget renderedBlock;
    private ElementWidget renderedItem;
    private AddressEditBox addressBox;
    private IconButton confirmButton;
    private IconButton deleteButton;
    private IconButton newInputButton;
    private IconButton relocateButton;
    private IconButton activateCraftingButton;
    private ScrollInput promiseExpiration;
    private ServerFactoryPanelBehaviour behaviour;
    private boolean restocker;
    private boolean sendReset;
    private boolean sendRedstoneReset;
    private BigItemStack outputConfig;
    private List<BigItemStack> inputConfig;
    private List<FactoryPanelConnection> connections;
    private boolean craftingActive;

    public FactoryPanelScreen(ServerFactoryPanelBehaviour behaviour) {
        this.behaviour = behaviour;
        this.restocker = behaviour.panelBE().restocker;
        this.craftingActive = !behaviour.activeCraftingArrangement.isEmpty();
        this.updateConfigs(Minecraft.getInstance().level);
    }

    private void updateConfigs(ClientLevel world) {
        this.connections = new ArrayList<FactoryPanelConnection>(this.behaviour.targetedBy.values());
        this.outputConfig = new BigItemStack(this.behaviour.getFilter(), this.behaviour.recipeOutput);
        this.inputConfig = this.connections.stream().map(c -> {
            ServerFactoryPanelBehaviour b = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)world, c.from);
            return b == null ? new BigItemStack(ItemStack.EMPTY, 0) : new BigItemStack(b.getFilter(), c.amount);
        }).toList();
        if (this.behaviour.craftingList == null) {
            this.craftingActive = false;
        }
    }

    @Override
    protected void init() {
        int sizeX = AllGuiTextures.FACTORY_GAUGE_BOTTOM.getWidth();
        int sizeY = (this.restocker ? AllGuiTextures.FACTORY_GAUGE_RESTOCK : AllGuiTextures.FACTORY_GAUGE_RECIPE).getHeight() + AllGuiTextures.FACTORY_GAUGE_BOTTOM.getHeight();
        this.setWindowSize(sizeX, sizeY);
        super.init();
        this.clearWidgets();
        int x = this.guiLeft;
        int y = this.guiTop;
        if (this.addressBox == null) {
            String frogAddress = this.behaviour.getFrogAddress();
            this.addressBox = new AddressEditBox(this, new NoShadowFontWrapper(this.font), x + 36, y + this.windowHeight - 51, 108, 10, false, frogAddress);
            this.addressBox.setValue(this.behaviour.recipeAddress);
            this.addressBox.setTextColor(-11184811);
        }
        this.addressBox.setX(x + 36);
        this.addressBox.setY(y + this.windowHeight - 51);
        this.addRenderableWidget((GuiEventListener)this.addressBox);
        this.confirmButton = new IconButton(x + sizeX - 33, y + sizeY - 25, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.minecraft.setScreen(null));
        this.confirmButton.setToolTip((Component)CreateLang.translate("gui.factory_panel.save_and_close", new Object[0]).component());
        this.addRenderableWidget(this.confirmButton);
        this.deleteButton = new IconButton(x + sizeX - 55, y + sizeY - 25, AllIcons.I_TRASH);
        this.deleteButton.withCallback(() -> {
            this.sendReset = true;
            this.minecraft.setScreen(null);
        });
        this.deleteButton.setToolTip((Component)CreateLang.translate("gui.factory_panel.reset", new Object[0]).component());
        this.addRenderableWidget(this.deleteButton);
        this.promiseExpiration = new ScrollInput(x + 97, y + this.windowHeight - 24, 28, 16).withRange(-1, 31).titled(CreateLang.translate("gui.factory_panel.promises_expire_title", new Object[0]).component());
        this.promiseExpiration.setState(this.behaviour.promiseClearingInterval);
        this.addRenderableWidget(this.promiseExpiration);
        this.newInputButton = new IconButton(x + 31, y + 47, AllIcons.I_ADD);
        this.newInputButton.withCallback(() -> {
            FactoryPanelConnectionHandler.startConnection(this.behaviour);
            this.minecraft.setScreen(null);
        });
        this.newInputButton.setToolTip((Component)CreateLang.translate("gui.factory_panel.connect_input", new Object[0]).component());
        this.relocateButton = new IconButton(x + 31, y + 67, AllIcons.I_MOVE_GAUGE);
        this.relocateButton.withCallback(() -> {
            FactoryPanelConnectionHandler.startRelocating(this.behaviour);
            this.minecraft.setScreen(null);
        });
        this.relocateButton.setToolTip((Component)CreateLang.translate("gui.factory_panel.relocate", new Object[0]).component());
        if (!this.restocker) {
            this.addRenderableWidget(this.newInputButton);
            this.addRenderableWidget(this.relocateButton);
        }
        this.activateCraftingButton = null;
        if (this.behaviour.craftingList != null) {
            this.activateCraftingButton = new IconButton(x + 31, y + 27, AllIcons.I_3x3);
            this.activateCraftingButton.green = this.craftingActive;
            this.activateCraftingButton.withCallback(() -> {
                this.craftingActive = !this.craftingActive;
                this.clearRenderedElements();
                this.init();
                if (this.craftingActive) {
                    this.outputConfig.count = this.behaviour.craftingList.getFirst().count;
                }
            });
            this.activateCraftingButton.setToolTip((Component)CreateLang.translate("gui.factory_panel.activate_crafting", new Object[0]).component());
            this.addRenderableWidget(this.activateCraftingButton);
        }
        int previewY = this.restocker ? 0 : 60;
        this.renderedBlock = new ElementWidget(x + 195, y + 55 + previewY).showingElement(GuiGameElement.of(AllItems.FACTORY_GAUGE.getDefaultInstance()).scale(4.0f));
        this.addRenderableWidget(this.renderedBlock);
        if (!this.behaviour.getFilter().isEmpty()) {
            this.renderedItem = new ElementWidget(x + 214, y + 68 + previewY).showingElement(GuiGameElement.of(this.behaviour.getFilter()).scale(1.625f));
            this.addRenderableWidget(this.renderedItem);
        } else {
            this.renderedItem = null;
        }
    }

    public void onClose() {
        super.onClose();
        this.clearRenderedElements();
    }

    private void clearRenderedElements() {
        this.renderedBlock.getRenderElement().clear();
        if (this.renderedItem != null) {
            this.renderedItem.getRenderElement().clear();
        }
    }

    @Override
    public void tick() {
        super.tick();
        if (this.inputConfig.size() != this.behaviour.targetedBy.size()) {
            this.updateConfigs(this.minecraft.level);
            this.clearRenderedElements();
            this.init();
        }
        if (this.activateCraftingButton != null) {
            this.activateCraftingButton.green = this.craftingActive;
        }
        this.addressBox.tick();
        this.promiseExpiration.titled(CreateLang.translate(this.promiseExpiration.getState() == -1 ? "gui.factory_panel.promises_do_not_expire" : "gui.factory_panel.promises_expire_title", new Object[0]).component());
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int state;
        AllGuiTextures bg;
        int x = this.guiLeft;
        int y = this.guiTop;
        AllGuiTextures allGuiTextures = bg = this.restocker ? AllGuiTextures.FACTORY_GAUGE_RESTOCK : AllGuiTextures.FACTORY_GAUGE_RECIPE;
        if (this.restocker) {
            AllGuiTextures.FACTORY_GAUGE_RECIPE.render(graphics, x, y - 16);
        }
        bg.render(graphics, x, y);
        AllGuiTextures.FACTORY_GAUGE_BOTTOM.render(graphics, x, y + bg.getHeight());
        y = this.guiTop;
        int slot = 0;
        if (this.craftingActive) {
            List<BigItemStack> list = this.behaviour.craftingList;
            int size = list.size();
            for (int i = 1; i < size; ++i) {
                this.renderInputItem(graphics, slot++, list.get(i), mouseX, mouseY);
            }
        } else {
            for (BigItemStack itemStack : this.inputConfig) {
                this.renderInputItem(graphics, slot++, itemStack, mouseX, mouseY);
            }
            if (this.inputConfig.isEmpty()) {
                int inputX = this.guiLeft + (this.restocker ? 88 : 68 + slot % 3 * 20);
                int inputY = this.guiTop + (this.restocker ? 12 : 28) + slot / 3 * 20;
                if (!this.restocker && mouseY > inputY && mouseY < inputY + 60 && mouseX > inputX && mouseX < inputX + 60) {
                    graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate("gui.factory_panel.unconfigured_input", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.unconfigured_input_tip", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.factory_panel.unconfigured_input_tip_1", new Object[0]).style(ChatFormatting.GRAY).component()), mouseX, mouseY);
                }
            }
        }
        if (this.restocker) {
            this.renderInputItem(graphics, slot, new BigItemStack(this.behaviour.getFilter(), 1), mouseX, mouseY);
        }
        if (!this.restocker) {
            int outputX = x + 160;
            int outputY = y + 48;
            graphics.renderItem(this.outputConfig.stack, outputX, outputY);
            graphics.renderItemDecorations(this.font, this.behaviour.getFilter(), outputX, outputY, "" + this.outputConfig.count);
            if (mouseX >= outputX - 1 && mouseX < outputX - 1 + 18 && mouseY >= outputY - 1 && mouseY < outputY - 1 + 18) {
                MutableComponent c1 = CreateLang.translate("gui.factory_panel.expected_output", CreateLang.itemName(this.outputConfig.stack).add(CreateLang.text(" x" + this.outputConfig.count)).string()).color(ScrollInput.HEADER_RGB).component();
                MutableComponent c2 = CreateLang.translate("gui.factory_panel.expected_output_tip", new Object[0]).style(ChatFormatting.GRAY).component();
                MutableComponent c3 = CreateLang.translate("gui.factory_panel.expected_output_tip_1", new Object[0]).style(ChatFormatting.GRAY).component();
                MutableComponent c4 = CreateLang.translate("gui.factory_panel.expected_output_tip_2", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component();
                graphics.setComponentTooltipForNextFrame(this.font, this.craftingActive ? List.of(c1, c2, c3) : List.of(c1, c2, c3, c4), mouseX, mouseY);
            }
        }
        Matrix3x2fStack ms = graphics.pose();
        ms.pushMatrix();
        if (this.addressBox.isHovered() && !this.addressBox.isFocused()) {
            this.showAddressBoxTooltip(graphics, mouseX, mouseY);
        }
        MutableComponent title = CreateLang.translate(this.restocker ? "gui.factory_panel.title_as_restocker" : "gui.factory_panel.title_as_recipe", new Object[0]).component();
        graphics.drawString(this.font, (Component)title, x + 97 - this.font.width((FormattedText)title) / 2, y + (this.restocker ? -12 : 4), -12764088, false);
        if (!this.behaviour.targetedByLinks.isEmpty()) {
            ItemStack asStack = AllItems.REDSTONE_LINK.getDefaultInstance();
            int itemX = x + 9;
            int itemY = y + this.windowHeight - 24;
            AllGuiTextures.FROGPORT_SLOT.render(graphics, itemX - 1, itemY - 1);
            graphics.renderItem(asStack, itemX, itemY);
            if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
                List<MutableComponent> linkTip = List.of(CreateLang.translate("gui.factory_panel.has_link_connections", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.left_click_disconnect", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component());
                graphics.setComponentTooltipForNextFrame(this.font, linkTip, mouseX, mouseY);
            }
        }
        graphics.drawString(this.font, (Component)CreateLang.text((String)((state = this.promiseExpiration.getState()) == -1 ? " /" : (state == 0 ? "30s" : state + "m"))).component(), this.promiseExpiration.getX() + 3, this.promiseExpiration.getY() + 4, -1118482, true);
        ItemStack asStack = PackageStyles.getDefaultBox();
        int itemX = x + 68;
        int itemY = y + this.windowHeight - 24;
        graphics.renderItem(asStack, itemX, itemY);
        int promised = this.behaviour.getPromised();
        graphics.renderItemDecorations(this.font, asStack, itemX, itemY, "" + promised);
        if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
            List<MutableComponent> promiseTip = promised == 0 ? List.of(CreateLang.translate("gui.factory_panel.no_open_promises", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate(this.restocker ? "gui.factory_panel.restocker_promises_tip" : "gui.factory_panel.recipe_promises_tip", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate(this.restocker ? "gui.factory_panel.restocker_promises_tip_1" : "gui.factory_panel.recipe_promises_tip_1", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.factory_panel.promise_prevents_oversending", new Object[0]).style(ChatFormatting.GRAY).component()) : List.of(CreateLang.translate("gui.factory_panel.promised_items", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.text(this.behaviour.getFilter().getHoverName().getString() + " x" + promised).component(), CreateLang.translate("gui.factory_panel.left_click_reset", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component());
            graphics.setComponentTooltipForNextFrame(this.font, promiseTip, mouseX, mouseY);
        }
        ms.popMatrix();
    }

    private void renderInputItem(GuiGraphics graphics, int slot, BigItemStack itemStack, int mouseX, int mouseY) {
        int inputX = this.guiLeft + (this.restocker ? 88 : 68 + slot % 3 * 20);
        int inputY = this.guiTop + (this.restocker ? 12 : 28) + slot / 3 * 20;
        graphics.renderItem(itemStack.stack, inputX, inputY);
        if (!(this.craftingActive || this.restocker || itemStack.stack.isEmpty())) {
            graphics.renderItemDecorations(this.font, itemStack.stack, inputX, inputY, "" + itemStack.count);
        }
        if (mouseX < inputX - 2 || mouseX >= inputX - 2 + 20 || mouseY < inputY - 2 || mouseY >= inputY - 2 + 20) {
            return;
        }
        if (this.craftingActive) {
            graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate("gui.factory_panel.crafting_input", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.crafting_input_tip", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.factory_panel.crafting_input_tip_1", new Object[0]).style(ChatFormatting.GRAY).component()), mouseX, mouseY);
            return;
        }
        if (itemStack.stack.isEmpty()) {
            graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate("gui.factory_panel.empty_panel", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.left_click_disconnect", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
            return;
        }
        if (this.restocker) {
            graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate("gui.factory_panel.sending_item", CreateLang.itemName(itemStack.stack).string()).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.sending_item_tip", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.factory_panel.sending_item_tip_1", new Object[0]).style(ChatFormatting.GRAY).component()), mouseX, mouseY);
            return;
        }
        graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate("gui.factory_panel.sending_item", CreateLang.itemName(itemStack.stack).add(CreateLang.text(" x" + itemStack.count)).string()).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.scroll_to_change_amount", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component(), CreateLang.translate("gui.factory_panel.left_click_disconnect", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
    }

    private void showAddressBoxTooltip(GuiGraphics graphics, int mouseX, int mouseY) {
        if (this.addressBox.getValue().isBlank()) {
            if (this.restocker) {
                graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate("gui.factory_panel.restocker_address", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.restocker_address_tip", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.factory_panel.restocker_address_tip_1", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.schedule.lmb_edit", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
            } else {
                graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate("gui.factory_panel.recipe_address", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.translate("gui.factory_panel.recipe_address_tip", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.factory_panel.recipe_address_tip_1", new Object[0]).style(ChatFormatting.GRAY).component(), CreateLang.translate("gui.schedule.lmb_edit", new Object[0]).style(ChatFormatting.DARK_GRAY).style(ChatFormatting.ITALIC).component()), mouseX, mouseY);
            }
        } else {
            graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate(this.restocker ? "gui.factory_panel.restocker_address_given" : "gui.factory_panel.recipe_address_given", new Object[0]).color(ScrollInput.HEADER_RGB).component(), CreateLang.text("'" + this.addressBox.getValue() + "'").style(ChatFormatting.GRAY).component()), mouseX, mouseY);
        }
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        double mouseX = click.x();
        double mouseY = click.y();
        if (this.getFocused() != null && !this.getFocused().isMouseOver(mouseX, mouseY)) {
            this.setFocused(null);
        }
        int x = this.guiLeft;
        int y = this.guiTop;
        if (!this.craftingActive) {
            for (int i = 0; i < this.connections.size(); ++i) {
                int inputX = x + 68 + i % 3 * 20;
                int inputY = y + 28 + i / 3 * 20;
                if (!(mouseX >= (double)inputX) || !(mouseX < (double)(inputX + 16)) || !(mouseY >= (double)inputY) || !(mouseY < (double)(inputY + 16))) continue;
                this.sendIt(this.connections.get((int)i).from, false);
                this.playButtonSound();
                return true;
            }
        }
        int itemX = x + 68;
        int itemY = y + this.windowHeight - 24;
        if (mouseX >= (double)itemX && mouseX < (double)(itemX + 16) && mouseY >= (double)itemY && mouseY < (double)(itemY + 16)) {
            this.sendIt(null, true);
            this.playButtonSound();
            return true;
        }
        itemX = x + 9;
        itemY = y + this.windowHeight - 24;
        if (mouseX >= (double)itemX && mouseX < (double)(itemX + 16) && mouseY >= (double)itemY && mouseY < (double)(itemY + 16)) {
            this.sendRedstoneReset = true;
            this.sendIt(null, false);
            this.playButtonSound();
            return true;
        }
        return super.mouseClicked(click, doubled);
    }

    public void playButtonSound() {
        this.minecraft.getSoundManager().play((SoundInstance)SimpleSoundInstance.forUI((SoundEvent)((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value()), (float)1.0f, (float)0.25f));
    }

    public boolean mouseScrolled(double mouseX, double mouseY, double scrollX, double scrollY) {
        int x = this.guiLeft;
        int y = this.guiTop;
        if (this.addressBox.mouseScrolled(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        if (this.craftingActive) {
            return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
        }
        for (int i = 0; i < this.inputConfig.size(); ++i) {
            int inputX = x + 68 + i % 3 * 20;
            int inputY = y + 26 + i / 3 * 20;
            if (!(mouseX >= (double)inputX) || !(mouseX < (double)(inputX + 16)) || !(mouseY >= (double)inputY) || !(mouseY < (double)(inputY + 16))) continue;
            BigItemStack itemStack = this.inputConfig.get(i);
            if (itemStack.stack.isEmpty()) {
                return true;
            }
            itemStack.count = Mth.clamp((int)((int)((double)itemStack.count + Math.signum(scrollY) * (double)(AllKeys.hasShiftDown() ? 10 : 1))), (int)1, (int)64);
            return true;
        }
        if (!this.restocker) {
            int outputX = x + 160;
            int outputY = y + 48;
            if (mouseX >= (double)outputX && mouseX < (double)(outputX + 16) && mouseY >= (double)outputY && mouseY < (double)(outputY + 16)) {
                BigItemStack itemStack = this.outputConfig;
                itemStack.count = Mth.clamp((int)((int)((double)itemStack.count + Math.signum(scrollY) * (double)(AllKeys.hasShiftDown() ? 10 : 1))), (int)1, (int)64);
                return true;
            }
        }
        return super.mouseScrolled(mouseX, mouseY, scrollX, scrollY);
    }

    public void removed() {
        this.sendIt(null, false);
        super.removed();
    }

    private void sendIt(@Nullable FactoryPanelPosition toRemove, boolean clearPromises) {
        HashMap<FactoryPanelPosition, Integer> inputs = new HashMap<FactoryPanelPosition, Integer>();
        if (this.inputConfig.size() == this.connections.size()) {
            for (int i = 0; i < this.inputConfig.size(); ++i) {
                BigItemStack stackInConfig = this.inputConfig.get(i);
                inputs.put(this.connections.get((int)i).from, this.craftingActive ? (int)this.behaviour.craftingList.stream().skip(1L).filter(b -> !b.stack.isEmpty() && ItemStack.isSameItemSameComponents((ItemStack)b.stack, (ItemStack)stackInConfig.stack)).count() : stackInConfig.count);
            }
        }
        List<ItemStack> craftingArrangement = this.craftingActive ? this.behaviour.craftingList.stream().skip(1L).map(b -> b.stack).toList() : List.of();
        FactoryPanelPosition pos = this.behaviour.getPanelPosition();
        int promiseExp = this.promiseExpiration.getState();
        String address = this.addressBox.getValue();
        FactoryPanelConfigurationPacket packet = new FactoryPanelConfigurationPacket(pos, address, inputs, craftingArrangement, this.outputConfig.count, promiseExp, toRemove, clearPromises, this.sendReset, this.sendRedstoneReset);
        this.minecraft.player.connection.send((Packet)packet);
    }
}

