/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.factoryBoard;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelPosition;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelSetItemMenu;
import com.zurrtum.create.content.logistics.factoryBoard.ServerFactoryPanelBehaviour;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.BlockAndTintGetter;

public class FactoryPanelSetItemScreen
extends AbstractSimiContainerScreen<FactoryPanelSetItemMenu> {
    private IconButton confirmButton;
    private ElementWidget renderedItem;
    private List<Rect2i> extraAreas = Collections.emptyList();

    public FactoryPanelSetItemScreen(FactoryPanelSetItemMenu container, Inventory inv, Component title) {
        super(container, inv, title);
    }

    public static FactoryPanelSetItemScreen create(Minecraft mc, MenuType<ServerFactoryPanelBehaviour> type, int syncId, Inventory inventory, Component title, RegistryFriendlyByteBuf extraData) {
        FactoryPanelPosition pos = (FactoryPanelPosition)FactoryPanelPosition.PACKET_CODEC.decode((Object)extraData);
        ServerFactoryPanelBehaviour behaviour = ServerFactoryPanelBehaviour.at((BlockAndTintGetter)mc.level, pos);
        return (FactoryPanelSetItemScreen)((Object)type.create(FactoryPanelSetItemScreen::new, syncId, inventory, title, behaviour));
    }

    @Override
    protected void init() {
        int bgHeight = AllGuiTextures.FACTORY_GAUGE_SET_ITEM.getHeight();
        int bgWidth = AllGuiTextures.FACTORY_GAUGE_SET_ITEM.getWidth();
        this.setWindowSize(bgWidth, bgHeight + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        super.init();
        this.clearWidgets();
        this.confirmButton = new IconButton(this.leftPos + bgWidth - 40, this.topPos + bgHeight - 25, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.minecraft.player.closeContainer());
        this.addRenderableWidget(this.confirmButton);
        this.extraAreas = List.of(new Rect2i(this.leftPos + bgWidth, this.topPos + bgHeight - 30, 40, 20));
        this.renderedItem = new ElementWidget(this.leftPos + 180, this.topPos + 48).showingElement(GuiGameElement.of(AllItems.FACTORY_GAUGE.getDefaultInstance()).scale(3.0f));
        this.addRenderableWidget(this.renderedItem);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    protected void renderBg(GuiGraphics pGuiGraphics, float pPartialTick, int pMouseX, int pMouseY) {
        AllGuiTextures.FACTORY_GAUGE_SET_ITEM.render(pGuiGraphics, this.leftPos - 5, this.topPos);
        this.renderPlayerInventory(pGuiGraphics, this.leftPos + 5, this.topPos + 94);
        MutableComponent title = CreateLang.translate("gui.factory_panel.place_item_to_monitor", new Object[0]).component();
        pGuiGraphics.drawString(this.font, (Component)title, this.leftPos + this.imageWidth / 2 - this.font.width((FormattedText)title) / 2 - 5, this.topPos + 4, -12764088, false);
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

