/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.factoryBoard;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.catnip.math.VecHelper;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.content.logistics.factoryBoard.FactoryPanelBlock;
import com.zurrtum.create.content.logistics.factoryBoard.PanelSlot;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class FactoryPanelSlotPositioning
extends ValueBoxTransform {
    public PanelSlot slot;

    public FactoryPanelSlotPositioning(PanelSlot slot) {
        this.slot = slot;
    }

    @Override
    public Vec3 getLocalOffset(BlockState state) {
        return FactoryPanelSlotPositioning.getCenterOfSlot(state, this.slot);
    }

    public static Vec3 getCenterOfSlot(BlockState state, PanelSlot slot) {
        Vec3 vec = new Vec3(0.25 + (double)slot.xOffset * 0.5, 0.09375, 0.25 + (double)slot.yOffset * 0.5);
        vec = VecHelper.rotateCentered(vec, 180.0, Direction.Axis.Y);
        vec = VecHelper.rotateCentered(vec, 57.295776f * FactoryPanelBlock.getXRot(state) + 90.0f, Direction.Axis.X);
        vec = VecHelper.rotateCentered(vec, 57.295776f * FactoryPanelBlock.getYRot(state), Direction.Axis.Y);
        return vec;
    }

    @Override
    public boolean testHit(LevelAccessor level, BlockPos pos, BlockState state, Vec3 localHit) {
        Vec3 offset = this.getLocalOffset(state);
        if (offset == null) {
            return false;
        }
        return localHit.distanceTo(offset) < (double)(this.scale / 2.0f);
    }

    @Override
    public float getScale() {
        return super.getScale();
    }

    @Override
    public void rotate(BlockState state, PoseStack ms) {
        ((PoseTransformStack)TransformStack.of(ms).rotate(FactoryPanelBlock.getYRot(state) + (float)Math.PI, Direction.UP)).rotate(-FactoryPanelBlock.getXRot(state), Direction.EAST);
    }
}

