/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.filter;

import com.google.common.collect.ImmutableList;
import com.zurrtum.create.AllPackets;
import com.zurrtum.create.client.AllKeys;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.catnip.lang.FontHelper;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.menu.AbstractSimiContainerScreen;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.content.logistics.filter.AbstractFilterMenu;
import com.zurrtum.create.infrastructure.packet.c2s.FilterScreenPacket;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public abstract class AbstractFilterScreen<F extends AbstractFilterMenu>
extends AbstractSimiContainerScreen<F> {
    protected AllGuiTextures background;
    private List<Rect2i> extraAreas = Collections.emptyList();
    private IconButton resetButton;
    private IconButton confirmButton;
    private ElementWidget renderedItem;

    protected AbstractFilterScreen(F menu, Inventory inv, Component title, AllGuiTextures background) {
        super(menu, inv, title);
        this.background = background;
    }

    @Override
    protected void init() {
        this.setWindowSize(Math.max(this.background.getWidth(), AllGuiTextures.PLAYER_INVENTORY.getWidth()), this.background.getHeight() + 4 + AllGuiTextures.PLAYER_INVENTORY.getHeight());
        super.init();
        this.resetButton = new IconButton(this.leftPos + this.background.getWidth() - 62, this.topPos + this.background.getHeight() - 24, AllIcons.I_TRASH);
        this.resetButton.withCallback(() -> {
            ((AbstractFilterMenu)this.menu).clearContents();
            this.contentsCleared();
            this.minecraft.player.connection.send((Packet)AllPackets.CLEAR_CONTAINER);
        });
        this.confirmButton = new IconButton(this.leftPos + this.background.getWidth() - 33, this.topPos + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(() -> this.minecraft.player.closeContainer());
        this.addRenderableWidget(this.resetButton);
        this.addRenderableWidget(this.confirmButton);
        this.extraAreas = ImmutableList.of((Object)new Rect2i(this.leftPos + this.background.getWidth(), this.topPos + this.background.getHeight() - 40, 80, 48));
        this.renderedItem = new ElementWidget(this.leftPos + this.background.getWidth() + 8, this.topPos + this.background.getHeight() - 52).showingElement(GuiGameElement.of((ItemStack)((AbstractFilterMenu)this.menu).contentHolder).scale(4.0f));
        this.addRenderableWidget(this.renderedItem);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        int invX = this.getLeftOfCentered(AllGuiTextures.PLAYER_INVENTORY.getWidth());
        int invY = this.topPos + this.background.getHeight() + 4;
        this.renderPlayerInventory(graphics, invX, invY);
        this.background.render(graphics, this.leftPos, this.topPos);
        graphics.drawString(this.font, this.title, this.leftPos + (this.background.getWidth() - 8) / 2 - this.font.width((FormattedText)this.title) / 2, this.topPos + 4, this.getTitleColor(), false);
    }

    protected int getTitleColor() {
        return -10935260;
    }

    @Override
    protected void containerTick() {
        if (!ItemStack.matches((ItemStack)this.minecraft.player.getMainHandItem(), (ItemStack)((ItemStack)((AbstractFilterMenu)this.menu).contentHolder))) {
            this.minecraft.player.closeContainer();
        }
        super.containerTick();
        this.handleTooltips();
        this.handleIndicators();
    }

    protected void handleTooltips() {
        List<IconButton> tooltipButtons = this.getTooltipButtons();
        for (IconButton button : tooltipButtons) {
            if (button.getToolTip().isEmpty()) continue;
            button.setToolTip(button.getToolTip().get(0));
            button.getToolTip().add((Component)TooltipHelper.holdShift(FontHelper.Palette.YELLOW, AllKeys.hasShiftDown()));
        }
        if (AllKeys.hasShiftDown()) {
            List<MutableComponent> tooltipDescriptions = this.getTooltipDescriptions();
            for (int i = 0; i < tooltipButtons.size(); ++i) {
                this.fillToolTip(tooltipButtons.get(i), (Component)tooltipDescriptions.get(i));
            }
        }
    }

    public void handleIndicators() {
        for (IconButton button : this.getTooltipButtons()) {
            button.green = !this.isButtonEnabled(button);
        }
    }

    protected abstract boolean isButtonEnabled(IconButton var1);

    protected List<IconButton> getTooltipButtons() {
        return Collections.emptyList();
    }

    protected List<MutableComponent> getTooltipDescriptions() {
        return Collections.emptyList();
    }

    private void fillToolTip(IconButton button, Component tooltip) {
        if (!button.isHoveredOrFocused()) {
            return;
        }
        List<Component> tip = button.getToolTip();
        tip.addAll(TooltipHelper.cutTextComponent(tooltip, FontHelper.Palette.ALL_GRAY));
    }

    protected void contentsCleared() {
    }

    protected void sendOptionUpdate(FilterScreenPacket.Option option) {
        this.minecraft.player.connection.send((Packet)new FilterScreenPacket(option));
    }

    @Override
    public List<Rect2i> getExtraAreas() {
        return this.extraAreas;
    }
}

