/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.filter;

import com.zurrtum.create.client.content.logistics.filter.AbstractFilterScreen;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.logistics.filter.FilterMenu;
import com.zurrtum.create.foundation.gui.menu.MenuType;
import com.zurrtum.create.infrastructure.packet.c2s.FilterScreenPacket;
import java.util.Arrays;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;

public class FilterScreen
extends AbstractFilterScreen<FilterMenu> {
    private static final String PREFIX = "gui.filter.";
    private final Component allowN = CreateLang.translateDirect("gui.filter.allow_list", new Object[0]);
    private final Component allowDESC = CreateLang.translateDirect("gui.filter.allow_list.description", new Object[0]);
    private final Component denyN = CreateLang.translateDirect("gui.filter.deny_list", new Object[0]);
    private final Component denyDESC = CreateLang.translateDirect("gui.filter.deny_list.description", new Object[0]);
    private final Component respectDataN = CreateLang.translateDirect("gui.filter.respect_data", new Object[0]);
    private final Component respectDataDESC = CreateLang.translateDirect("gui.filter.respect_data.description", new Object[0]);
    private final Component ignoreDataN = CreateLang.translateDirect("gui.filter.ignore_data", new Object[0]);
    private final Component ignoreDataDESC = CreateLang.translateDirect("gui.filter.ignore_data.description", new Object[0]);
    private IconButton whitelist;
    private IconButton blacklist;
    private IconButton respectNBT;
    private IconButton ignoreNBT;

    public FilterScreen(FilterMenu menu, Inventory inv, Component title) {
        super(menu, inv, title, AllGuiTextures.FILTER);
    }

    public static FilterScreen create(Minecraft mc, MenuType<ItemStack> type, int syncId, Inventory inventory, Component title, RegistryFriendlyByteBuf extraData) {
        return (FilterScreen)((Object)type.create(FilterScreen::new, syncId, inventory, title, FilterScreen.getStack(extraData)));
    }

    @Override
    protected void init() {
        this.setWindowOffset(-11, 5);
        super.init();
        this.blacklist = new IconButton(this.leftPos + 18, this.topPos + 75, AllIcons.I_BLACKLIST);
        this.blacklist.withCallback(() -> {
            ((FilterMenu)this.menu).blacklist = true;
            this.sendOptionUpdate(FilterScreenPacket.Option.BLACKLIST);
        });
        this.blacklist.setToolTip(this.denyN);
        this.whitelist = new IconButton(this.leftPos + 36, this.topPos + 75, AllIcons.I_WHITELIST);
        this.whitelist.withCallback(() -> {
            ((FilterMenu)this.menu).blacklist = false;
            this.sendOptionUpdate(FilterScreenPacket.Option.WHITELIST);
        });
        this.whitelist.setToolTip(this.allowN);
        this.addRenderableWidgets(new IconButton[]{this.blacklist, this.whitelist});
        this.respectNBT = new IconButton(this.leftPos + 60, this.topPos + 75, AllIcons.I_RESPECT_NBT);
        this.respectNBT.withCallback(() -> {
            ((FilterMenu)this.menu).respectNBT = true;
            this.sendOptionUpdate(FilterScreenPacket.Option.RESPECT_DATA);
        });
        this.respectNBT.setToolTip(this.respectDataN);
        this.ignoreNBT = new IconButton(this.leftPos + 78, this.topPos + 75, AllIcons.I_IGNORE_NBT);
        this.ignoreNBT.withCallback(() -> {
            ((FilterMenu)this.menu).respectNBT = false;
            this.sendOptionUpdate(FilterScreenPacket.Option.IGNORE_DATA);
        });
        this.ignoreNBT.setToolTip(this.ignoreDataN);
        this.addRenderableWidgets(new IconButton[]{this.respectNBT, this.ignoreNBT});
        this.handleIndicators();
    }

    @Override
    protected List<IconButton> getTooltipButtons() {
        return Arrays.asList(this.blacklist, this.whitelist, this.respectNBT, this.ignoreNBT);
    }

    @Override
    protected List<MutableComponent> getTooltipDescriptions() {
        return Arrays.asList(this.denyDESC.plainCopy(), this.allowDESC.plainCopy(), this.respectDataDESC.plainCopy(), this.ignoreDataDESC.plainCopy());
    }

    @Override
    protected boolean isButtonEnabled(IconButton button) {
        if (button == this.blacklist) {
            return !((FilterMenu)this.menu).blacklist;
        }
        if (button == this.whitelist) {
            return ((FilterMenu)this.menu).blacklist;
        }
        if (button == this.respectNBT) {
            return !((FilterMenu)this.menu).respectNBT;
        }
        if (button == this.ignoreNBT) {
            return ((FilterMenu)this.menu).respectNBT;
        }
        return true;
    }

    @Override
    protected int getTitleColor() {
        return -13619152;
    }
}

