/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.packager;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.content.logistics.packager.PackagerBlock;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class PackagerRenderer
implements BlockEntityRenderer<PackagerBlockEntity, PackagerRenderState> {
    protected final ItemModelResolver itemModelManager;

    public PackagerRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public PackagerRenderState createRenderState() {
        return new PackagerRenderState();
    }

    public void extractRenderState(PackagerBlockEntity be, PackagerRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        Level world = be.getLevel();
        boolean support = VisualizationManager.supportsVisualization((LevelAccessor)world);
        ItemStack renderedBox = be.getRenderedBox();
        boolean empty = renderedBox.isEmpty();
        if (support && empty) {
            return;
        }
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        Direction facing = ((Direction)state.blockState.getValue((Property)PackagerBlock.FACING)).getOpposite();
        float trayOffset = be.getTrayOffset(tickProgress);
        state.trayOffset = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()).scale((double)trayOffset);
        state.trayYRot = (float)Math.PI / 180 * facing.toYRot();
        if (!support) {
            state.layer = RenderTypes.cutoutMovingBlock();
            state.hatch = CachedBuffers.partial(PackagerRenderer.getHatchModel(be), state.blockState);
            state.hatchOffset = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i()).scale((double)0.49999f);
            state.hatchYRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
            state.hatchXRot = (float)Math.PI / 180 * AngleHelper.verticalAngle(facing);
            state.tray = CachedBuffers.partial(PackagerRenderer.getTrayModel(state.blockState), state.blockState);
        }
        if (!empty) {
            ItemStackRenderState item = new ItemStackRenderState();
            item.displayContext = ItemDisplayContext.FIXED;
            this.itemModelManager.appendItemLayers(item, renderedBox, item.displayContext, world, null, 0);
            state.item = item;
        }
    }

    public void submit(PackagerRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.layer != null) {
            queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        }
        if (state.item != null) {
            matrices.translate(state.trayOffset);
            matrices.translate(0.5f, 0.5f, 0.5f);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(state.trayYRot));
            matrices.translate(0.0f, 0.125f, 0.0f);
            matrices.scale(1.49f, 1.49f, 1.49f);
            state.item.submit(matrices, queue, state.lightCoords, OverlayTexture.NO_OVERLAY, 0);
        }
    }

    public static PartialModel getTrayModel(BlockState blockState) {
        return blockState.is((Block)AllBlocks.PACKAGER) ? AllPartialModels.PACKAGER_TRAY_REGULAR : AllPartialModels.PACKAGER_TRAY_DEFRAG;
    }

    public static PartialModel getHatchModel(PackagerBlockEntity be) {
        return PackagerRenderer.isHatchOpen(be) ? AllPartialModels.PACKAGER_HATCH_OPEN : AllPartialModels.PACKAGER_HATCH_CLOSED;
    }

    public static boolean isHatchOpen(PackagerBlockEntity be) {
        return be.animationTicks > (be.animationInward ? 1 : 5) && be.animationTicks < 20 - (be.animationInward ? 5 : 1);
    }

    public static class PackagerRenderState
    extends BlockEntityRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public Vec3 trayOffset;
        public float trayYRot;
        public RenderType layer;
        public SuperByteBuffer hatch;
        public Vec3 hatchOffset;
        public float hatchYRot;
        public float hatchXRot;
        public SuperByteBuffer tray;
        public ItemStackRenderState item;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.hatch.translate(this.hatchOffset)).rotateYCentered(this.hatchYRot)).rotateXCentered(this.hatchXRot)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)this.tray.translate(this.trayOffset)).rotateYCentered(this.trayYRot)).light(this.lightCoords).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

