/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.packager;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.content.logistics.packager.PackagerRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.logistics.packager.PackagerBlock;
import com.zurrtum.create.content.logistics.packager.PackagerBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class PackagerVisual<T extends PackagerBlockEntity>
extends AbstractBlockEntityVisual<T>
implements SimpleDynamicVisual {
    public final TransformedInstance hatch;
    public final TransformedInstance tray;
    public float lastTrayOffset = Float.NaN;
    public PartialModel lastHatchPartial;

    public PackagerVisual(VisualizationContext ctx, T blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        this.lastHatchPartial = PackagerRenderer.getHatchModel(blockEntity);
        this.hatch = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(this.lastHatchPartial)).createInstance();
        this.tray = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(PackagerRenderer.getTrayModel(this.blockState))).createInstance();
        Direction facing = ((Direction)this.blockState.getValue((Property)PackagerBlock.FACING)).getOpposite();
        Vec3 lowerCorner = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i());
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.hatch.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translate(lowerCorner.scale((double)0.49999f))).rotateYCenteredDegrees(AngleHelper.horizontalAngle(facing))).rotateXCenteredDegrees(AngleHelper.verticalAngle(facing))).setChanged();
        this.animate(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    public void animate(float partialTick) {
        float trayOffset;
        PartialModel hatchPartial = PackagerRenderer.getHatchModel((PackagerBlockEntity)this.blockEntity);
        if (hatchPartial != this.lastHatchPartial) {
            this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(hatchPartial)).stealInstance(this.hatch);
            this.lastHatchPartial = hatchPartial;
        }
        if ((trayOffset = ((PackagerBlockEntity)this.blockEntity).getTrayOffset(partialTick)) != this.lastTrayOffset) {
            Direction facing = ((Direction)this.blockState.getValue((Property)PackagerBlock.FACING)).getOpposite();
            Vec3 lowerCorner = Vec3.atLowerCornerOf((Vec3i)facing.getUnitVec3i());
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)this.tray.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translate(lowerCorner.scale((double)trayOffset))).rotateYCenteredDegrees(facing.toYRot())).setChanged();
            this.lastTrayOffset = trayOffset;
        }
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.hatch, this.tray);
    }

    @Override
    protected void _delete() {
        this.hatch.delete();
        this.tray.delete();
    }

    @Override
    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }
}

