/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.packagerLink;

import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelBehaviour;
import com.zurrtum.create.client.content.logistics.factoryBoard.FactoryPanelConnectionHandler;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBehaviour;
import com.zurrtum.create.content.logistics.packagerLink.LogisticallyLinkedBlockItem;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.UUIDUtil;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.TypedEntityData;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.tuple.Pair;

public class LogisticallyLinkedClientHandler {
    private static UUID previouslyHeldFrequency;

    public static void tick(Minecraft mc) {
        previouslyHeldFrequency = null;
        LocalPlayer player = mc.player;
        if (player == null) {
            return;
        }
        ItemStack mainHandItem = player.getMainHandItem();
        if (!(mainHandItem.getItem() instanceof LogisticallyLinkedBlockItem) || !LogisticallyLinkedBlockItem.isTuned(mainHandItem)) {
            return;
        }
        TypedEntityData data = (TypedEntityData)mainHandItem.get(DataComponents.BLOCK_ENTITY_DATA);
        if (data == null || !data.contains("Freq")) {
            return;
        }
        CompoundTag tag = data.copyTagWithoutId();
        Optional uuid = tag.read("Freq", UUIDUtil.CODEC);
        if (uuid.isEmpty()) {
            return;
        }
        previouslyHeldFrequency = (UUID)uuid.get();
        for (LogisticallyLinkedBehaviour behaviour : LogisticallyLinkedBehaviour.getAllPresent(previouslyHeldFrequency, false, true)) {
            SmartBlockEntity be = behaviour.blockEntity;
            VoxelShape shape = be.getBlockState().getShape((BlockGetter)player.level(), be.getBlockPos());
            if (shape.isEmpty() || !player.blockPosition().closerThan((Vec3i)be.getBlockPos(), 64.0)) continue;
            List list = shape.toAabbs();
            int size = list.size();
            for (int i = 0; i < size; ++i) {
                AABB aabb = (AABB)list.get(i);
                Outliner.getInstance().showAABB(Pair.of((Object)behaviour, (Object)i), aabb.inflate(-0.0078125).move(be.getBlockPos()), 2).lineWidth(0.03125f).disableLineNormals().colored(AnimationTickHolder.getTicks() % 16 < 8 ? 7376301 : 9481677);
            }
        }
    }

    public static void tickPanel(FactoryPanelBehaviour fpb) {
        if (previouslyHeldFrequency == null) {
            return;
        }
        if (!previouslyHeldFrequency.equals(fpb.getNetwork())) {
            return;
        }
        LocalPlayer player = Minecraft.getInstance().player;
        if (player == null) {
            return;
        }
        if (!player.blockPosition().closerThan((Vec3i)fpb.getPos(), 64.0)) {
            return;
        }
        Outliner.getInstance().showAABB(fpb, FactoryPanelConnectionHandler.getBB(fpb.blockEntity.getBlockState(), fpb.getPanelPosition()).inflate(-0.01171875)).lineWidth(0.03125f).disableLineNormals().colored(AnimationTickHolder.getTicks() % 16 < 8 ? 7376301 : 9481677);
    }
}

