/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.tableCloth;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.content.equipment.blueprint.BlueprintOverlayRenderer;
import com.zurrtum.create.client.content.logistics.tableCloth.TableClothFilteringBehaviour;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerBlockEntity;
import com.zurrtum.create.content.logistics.stockTicker.StockTickerInteractionHandler;
import com.zurrtum.create.content.logistics.tableCloth.ShoppingListItem;
import com.zurrtum.create.content.logistics.tableCloth.TableClothBlockEntity;
import com.zurrtum.create.infrastructure.component.ShoppingList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;

public class TableClothOverlayRenderer {
    public static void tick(Minecraft mc) {
        if (mc.gameMode.getPlayerMode() == GameType.SPECTATOR) {
            return;
        }
        HitResult mouseOver = mc.hitResult;
        if (mouseOver == null) {
            return;
        }
        ItemStack heldItem = mc.player.getMainHandItem();
        ClientLevel world = mc.level;
        if (mouseOver.getType() != HitResult.Type.ENTITY) {
            if (!(mouseOver instanceof BlockHitResult)) {
                return;
            }
            BlockHitResult bhr = (BlockHitResult)mouseOver;
            BlockEntity blockEntity = world.getBlockEntity(bhr.getBlockPos());
            if (!(blockEntity instanceof TableClothBlockEntity)) {
                return;
            }
            TableClothBlockEntity dcbe = (TableClothBlockEntity)blockEntity;
            if (!dcbe.isShop()) {
                return;
            }
            if (heldItem.is((Item)AllItems.CLIPBOARD)) {
                return;
            }
            TableClothFilteringBehaviour behaviour = (TableClothFilteringBehaviour)dcbe.getBehaviour(TableClothFilteringBehaviour.TYPE);
            if (behaviour.targetsPriceTag((Player)mc.player, bhr)) {
                return;
            }
            int alreadyPurchased = 0;
            ShoppingList list = ShoppingListItem.getList(heldItem);
            if (list != null) {
                alreadyPurchased = list.getPurchases(dcbe.getBlockPos());
            }
            BlueprintOverlayRenderer.displayClothShop(dcbe, alreadyPurchased, list);
            return;
        }
        EntityHitResult entityRay = (EntityHitResult)mouseOver;
        if (!heldItem.is((Item)AllItems.SHOPPING_LIST)) {
            return;
        }
        ShoppingList list = ShoppingListItem.getList(heldItem);
        BlockPos stockTickerPosition = StockTickerInteractionHandler.getStockTickerPosition(entityRay.getEntity());
        if (list == null || stockTickerPosition == null) {
            return;
        }
        BlockEntity blockEntity = world.getBlockEntity(stockTickerPosition);
        if (!(blockEntity instanceof StockTickerBlockEntity)) {
            return;
        }
        StockTickerBlockEntity tickerBE = (StockTickerBlockEntity)blockEntity;
        if (!tickerBE.behaviour.freqId.equals(list.shopNetwork())) {
            return;
        }
        BlueprintOverlayRenderer.displayShoppingList(mc.player, list.bakeEntries((LevelAccessor)world, null));
    }
}

