/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.logistics.tunnel;

import com.zurrtum.create.catnip.animation.LerpedFloat;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.logistics.FlapStuffs;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.logistics.tunnel.BeltTunnelBlockEntity;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public class BeltTunnelVisual
extends AbstractBlockEntityVisual<BeltTunnelBlockEntity>
implements SimpleDynamicVisual {
    private final Map<Direction, FlapStuffs.Visual> tunnelFlaps = new EnumMap<Direction, FlapStuffs.Visual>(Direction.class);
    private int light;

    public BeltTunnelVisual(VisualizationContext context, BeltTunnelBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        this.createFlaps();
        this.updateFlaps(partialTick);
    }

    private void createFlaps() {
        ((BeltTunnelBlockEntity)this.blockEntity).flaps.forEach((direction, flapValue) -> {
            Matrix4f commonTransform = FlapStuffs.commonTransform(this.visualPos, direction, 0.0f);
            FlapStuffs.Visual flapSide = new FlapStuffs.Visual(this.instancerProvider(), (Matrix4fc)commonTransform, FlapStuffs.TUNNEL_PIVOT, Models.partial(AllPartialModels.BELT_TUNNEL_FLAP));
            flapSide.updateLight(this.light);
            this.tunnelFlaps.put((Direction)direction, flapSide);
        });
    }

    @Override
    public void update(float partialTick) {
        super.update(partialTick);
        this._delete();
        this.createFlaps();
        this.updateFlaps(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.updateFlaps(ctx.partialTick());
    }

    private void updateFlaps(float partialTicks) {
        this.tunnelFlaps.forEach((direction, keys) -> {
            LerpedFloat lerpedFloat = ((BeltTunnelBlockEntity)this.blockEntity).flaps.get(direction);
            if (lerpedFloat == null) {
                return;
            }
            keys.update(lerpedFloat.getValue(partialTicks));
        });
    }

    @Override
    public void updateLight(float partialTick) {
        this.light = this.computePackedLight();
        for (FlapStuffs.Visual value : this.tunnelFlaps.values()) {
            value.updateLight(this.light);
        }
    }

    @Override
    protected void _delete() {
        this.tunnelFlaps.values().forEach(FlapStuffs.Visual::delete);
        this.tunnelFlaps.clear();
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        for (FlapStuffs.Visual value : this.tunnelFlaps.values()) {
            value.collectCrumblingInstances(consumer);
        }
    }
}

