/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.processing.burner;

import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.AllSpriteShifts;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.SpriteShiftEntry;
import com.zurrtum.create.client.content.processing.burner.BlazeBurnerRenderer;
import com.zurrtum.create.client.content.processing.burner.ScrollInstance;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visual.TickableVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.model.baked.PartialModel;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleTickableVisual;
import com.zurrtum.create.client.foundation.render.AllInstanceTypes;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlock;
import com.zurrtum.create.content.processing.burner.BlazeBurnerBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.Nullable;

public class BlazeBurnerVisual
extends AbstractBlockEntityVisual<BlazeBurnerBlockEntity>
implements SimpleDynamicVisual,
SimpleTickableVisual {
    private BlazeBurnerBlock.HeatLevel heatLevel = BlazeBurnerBlock.HeatLevel.SMOULDERING;
    private final TransformedInstance head;
    private final boolean isInert;
    @Nullable
    private TransformedInstance smallRods;
    @Nullable
    private TransformedInstance largeRods;
    @Nullable
    private ScrollInstance flame;
    @Nullable
    private TransformedInstance goggles;
    @Nullable
    private TransformedInstance hat;
    private boolean validBlockAbove;

    public BlazeBurnerVisual(VisualizationContext ctx, BlazeBurnerBlockEntity blockEntity, float partialTick) {
        super(ctx, blockEntity, partialTick);
        this.validBlockAbove = blockEntity.isValidBlockAbove();
        PartialModel blazeModel = BlazeBurnerRenderer.getBlazeModel(this.heatLevel, this.validBlockAbove);
        this.isInert = blazeModel == AllPartialModels.BLAZE_INERT;
        this.head = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(blazeModel)).createInstance();
        this.head.light(0xF000F0);
        this.animate(partialTick);
    }

    @Override
    public void tick(TickableVisual.Context context) {
        BlazeBurnerRenderer.tickAnimation((BlazeBurnerBlockEntity)this.blockEntity);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        if (!this.isVisible(ctx.frustum()) || this.doDistanceLimitThisFrame(ctx)) {
            return;
        }
        this.animate(ctx.partialTick());
    }

    private void animate(float partialTicks) {
        boolean hatPresent;
        float animation = ((BlazeBurnerBlockEntity)this.blockEntity).headAnimation.getValue(partialTicks) * 0.175f;
        boolean validBlockAbove = animation > 0.125f;
        BlazeBurnerBlock.HeatLevel heatLevel = ((BlazeBurnerBlockEntity)this.blockEntity).getHeatLevelForRender();
        if (validBlockAbove != this.validBlockAbove || heatLevel != this.heatLevel) {
            this.validBlockAbove = validBlockAbove;
            PartialModel blazeModel = BlazeBurnerRenderer.getBlazeModel(heatLevel, validBlockAbove);
            this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(blazeModel)).stealInstance(this.head);
            boolean needsRods = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
            boolean hasRods = this.heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING);
            if (needsRods && !hasRods) {
                PartialModel rodsModel = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS : AllPartialModels.BLAZE_BURNER_RODS;
                PartialModel rodsModel2 = heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllPartialModels.BLAZE_BURNER_SUPER_RODS_2 : AllPartialModels.BLAZE_BURNER_RODS_2;
                this.smallRods = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(rodsModel)).createInstance();
                this.largeRods = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(rodsModel2)).createInstance();
                this.smallRods.light(0xF000F0);
                this.largeRods.light(0xF000F0);
            } else if (!needsRods && hasRods) {
                if (this.smallRods != null) {
                    this.smallRods.delete();
                }
                if (this.largeRods != null) {
                    this.largeRods.delete();
                }
                this.smallRods = null;
                this.largeRods = null;
            }
            this.heatLevel = heatLevel;
        }
        if (validBlockAbove && this.flame == null) {
            this.setupFlameInstance();
        } else if (!validBlockAbove && this.flame != null) {
            this.flame.delete();
            this.flame = null;
        }
        if (((BlazeBurnerBlockEntity)this.blockEntity).goggles && this.goggles == null) {
            this.goggles = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(this.isInert ? AllPartialModels.BLAZE_GOGGLES_SMALL : AllPartialModels.BLAZE_GOGGLES)).createInstance();
            this.goggles.light(0xF000F0);
        } else if (!((BlazeBurnerBlockEntity)this.blockEntity).goggles && this.goggles != null) {
            this.goggles.delete();
            this.goggles = null;
        }
        boolean bl = hatPresent = ((BlazeBurnerBlockEntity)this.blockEntity).hat || ((BlazeBurnerBlockEntity)this.blockEntity).stockKeeper;
        if (hatPresent && this.hat == null) {
            this.hat = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(((BlazeBurnerBlockEntity)this.blockEntity).stockKeeper ? AllPartialModels.LOGISTICS_HAT : AllPartialModels.TRAIN_HAT)).createInstance();
            this.hat.light(0xF000F0);
        } else if (!hatPresent && this.hat != null) {
            this.hat.delete();
            this.hat = null;
        }
        int hashCode = ((BlazeBurnerBlockEntity)this.blockEntity).hashCode();
        float time = AnimationTickHolder.getRenderTime((LevelAccessor)this.level);
        float renderTick = time + (float)(hashCode % 13) * 16.0f;
        float offsetMult = heatLevel.isAtLeast(BlazeBurnerBlock.HeatLevel.FADING) ? 64.0f : 16.0f;
        float offset = Mth.sin((double)((float)((double)(renderTick / 16.0f) % (Math.PI * 2)))) / offsetMult;
        float headY = offset - animation * 0.75f;
        float horizontalAngle = AngleHelper.rad(((BlazeBurnerBlockEntity)this.blockEntity).headAngle.getValue(partialTicks));
        ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.head.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(headY)).translate(0.5f)).rotateY(horizontalAngle).translateBack(0.5f)).setChanged();
        if (this.goggles != null) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.goggles.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(headY + 0.5f)).translate(0.5f)).rotateY(horizontalAngle).translateBack(0.5f)).setChanged();
        }
        if (this.hat != null) {
            ((TransformedInstance)((TransformedInstance)this.hat.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(headY)).translateY(0.75f);
            ((TransformedInstance)this.hat.rotateCentered(horizontalAngle + (float)Math.PI, Direction.UP)).translate(0.5f, 0.0f, 0.5f).light(0xF000F0);
            this.hat.setChanged();
        }
        if (this.smallRods != null) {
            float offset1 = Mth.sin((double)((float)(((double)(renderTick / 16.0f) + Math.PI) % (Math.PI * 2)))) / offsetMult;
            ((TransformedInstance)((TransformedInstance)this.smallRods.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(offset1 + animation + 0.125f)).setChanged();
        }
        if (this.largeRods != null) {
            float offset2 = Mth.sin((double)((float)(((double)(renderTick / 16.0f) + 1.5707963267948966) % (Math.PI * 2)))) / offsetMult;
            ((TransformedInstance)((TransformedInstance)this.largeRods.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translateY(offset2 + animation - 0.1875f)).setChanged();
        }
    }

    private void setupFlameInstance() {
        this.flame = this.instancerProvider().instancer(AllInstanceTypes.SCROLLING, Models.partial(AllPartialModels.BLAZE_BURNER_FLAME)).createInstance();
        this.flame.position((Vec3i)this.getVisualPosition()).light(0xF000F0);
        SpriteShiftEntry spriteShift = this.heatLevel == BlazeBurnerBlock.HeatLevel.SEETHING ? AllSpriteShifts.SUPER_BURNER_FLAME : AllSpriteShifts.BURNER_FLAME;
        float spriteWidth = spriteShift.getTarget().getU1() - spriteShift.getTarget().getU0();
        float spriteHeight = spriteShift.getTarget().getV1() - spriteShift.getTarget().getV0();
        float speed = 0.03125f + 0.015625f * (float)this.heatLevel.ordinal();
        this.flame.speedU = speed / 2.0f;
        this.flame.speedV = speed;
        this.flame.scaleU = spriteWidth / 2.0f;
        this.flame.scaleV = spriteHeight / 2.0f;
        this.flame.diffU = spriteShift.getTarget().getU0() - spriteShift.getOriginal().getU0();
        this.flame.diffV = spriteShift.getTarget().getV0() - spriteShift.getOriginal().getV0();
    }

    @Override
    public void updateLight(float partialTick) {
    }

    @Override
    public void collectCrumblingInstances(Consumer<@Nullable Instance> consumer) {
    }

    @Override
    protected void _delete() {
        this.head.delete();
        if (this.smallRods != null) {
            this.smallRods.delete();
        }
        if (this.largeRods != null) {
            this.largeRods.delete();
        }
        if (this.flame != null) {
            this.flame.delete();
        }
        if (this.goggles != null) {
            this.goggles.delete();
        }
        if (this.hat != null) {
            this.hat.delete();
        }
    }
}

