/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.deskBell;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.foundation.blockEntity.renderer.SmartBlockEntityRenderer;
import com.zurrtum.create.content.redstone.deskBell.DeskBellBlock;
import com.zurrtum.create.content.redstone.deskBell.DeskBellBlockEntity;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class DeskBellRenderer
extends SmartBlockEntityRenderer<DeskBellBlockEntity, DeskBellRenderState> {
    public DeskBellRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    @Override
    public DeskBellRenderState createRenderState() {
        return new DeskBellRenderState();
    }

    @Override
    public void extractRenderState(DeskBellBlockEntity be, DeskBellRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        super.extractRenderState(be, state, tickProgress, cameraPos, crumblingOverlay);
        float p = be.animation.getValue(tickProgress);
        if ((double)p < 0.004 && !((Boolean)state.blockState.getValueOrElse((Property)DeskBellBlock.POWERED, (Comparable)Boolean.valueOf(false))).booleanValue()) {
            return;
        }
        state.layer = RenderTypes.solidMovingBlock();
        float f = (float)(1.0 - 4.0 * Math.pow(Math.max((double)p - 0.5, 0.0) - 0.5, 2.0));
        float f2 = (float)Math.pow(p, 1.25);
        Direction facing = (Direction)state.blockState.getValue((Property)DeskBellBlock.FACING);
        state.yRot = (float)Math.PI / 180 * AngleHelper.horizontalAngle(facing);
        state.xRot = (float)Math.PI / 180 * (AngleHelper.verticalAngle(facing) + 90.0f);
        state.plunger = CachedBuffers.partial(AllPartialModels.DESK_BELL_PLUNGER, state.blockState);
        state.plungerOffset = f * -0.75f / 16.0f;
        state.bell = CachedBuffers.partial(AllPartialModels.DESK_BELL_BELL, state.blockState);
        state.bellOffset = 0;
        float offset = p * (float)Math.PI * 4.0f + be.animationOffset;
        state.bellXRot = (float)Math.PI / 180 * (f2 * 8.0f * Mth.sin((double)offset));
        state.bellZRot = (float)Math.PI / 180 * (f2 * 8.0f * Mth.cos((double)offset));
    }

    @Override
    public void submit(DeskBellRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        super.submit(state, matrices, queue, cameraState);
        if (state.layer != null) {
            queue.submitCustomGeometry(matrices, state.layer, (SubmitNodeCollector.CustomGeometryRenderer)state);
        }
    }

    public static class DeskBellRenderState
    extends SmartBlockEntityRenderer.SmartRenderState
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public float yRot;
        public float xRot;
        public SuperByteBuffer plunger;
        public float plungerOffset;
        public SuperByteBuffer bell;
        public int bellOffset;
        public float bellXRot;
        public float bellZRot;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.plunger.center()).rotateY(this.yRot)).rotateX(this.xRot)).uncenter()).translate(0.0f, this.plungerOffset, 0.0f);
            this.plunger.light(this.lightCoords).overlay(OverlayTexture.NO_OVERLAY).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.bell.center()).rotateY(this.yRot)).rotateX(this.xRot)).translate(0.0f, this.bellOffset, 0.0f)).rotateX(this.bellXRot)).rotateZ(this.bellZRot)).translate(0.0f, -this.bellOffset, 0.0f);
            ((SuperByteBuffer)((SuperByteBuffer)this.bell.scale(0.995f)).uncenter()).light(this.lightCoords).overlay(OverlayTexture.NO_OVERLAY).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

