/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.link;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.content.redstone.link.LinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.c2s.LinkSettingsPacket;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;

public class LinkHandler {
    public static InteractionResult onBlockActivated(Level world, LocalPlayer player, InteractionHand hand, BlockHitResult ray) {
        if (player.isShiftKeyDown() || player.isSpectator()) {
            return null;
        }
        ItemStack heldItem = player.getItemInHand(hand);
        if (heldItem.is((Item)AllItems.LINKED_CONTROLLER)) {
            return null;
        }
        if (heldItem.is((Item)AllItems.WRENCH)) {
            return null;
        }
        BlockPos pos = ray.getBlockPos();
        LinkBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)world, pos, LinkBehaviour.TYPE);
        if (behaviour == null) {
            return null;
        }
        for (boolean first : Iterate.trueAndFalse) {
            if (!behaviour.testHit(first, ray.getLocation())) continue;
            behaviour.setFrequency(first, heldItem);
            world.playSound(null, pos, SoundEvents.ITEM_FRAME_ADD_ITEM, SoundSource.BLOCKS, 0.25f, 0.1f);
            player.connection.send((Packet)new LinkSettingsPacket(pos, first, hand));
            return InteractionResult.SUCCESS;
        }
        return null;
    }
}

