/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.link;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.datafixers.util.Pair;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.content.redstone.link.LinkBehaviour;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBox;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxRenderer;
import com.zurrtum.create.client.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.foundation.blockEntity.SmartBlockEntity;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class LinkRenderer {
    public static void tick(Minecraft mc) {
        HitResult target = mc.hitResult;
        if (!(target instanceof BlockHitResult)) {
            return;
        }
        BlockHitResult result = (BlockHitResult)target;
        ClientLevel world = mc.level;
        BlockPos pos = result.getBlockPos();
        LinkBehaviour behaviour = BlockEntityBehaviour.get((BlockGetter)world, pos, LinkBehaviour.TYPE);
        if (behaviour == null) {
            return;
        }
        MutableComponent freq1 = CreateLang.translateDirect("logistics.firstFrequency", new Object[0]);
        MutableComponent freq2 = CreateLang.translateDirect("logistics.secondFrequency", new Object[0]);
        for (boolean first : Iterate.trueAndFalse) {
            AABB bb = new AABB(Vec3.ZERO, Vec3.ZERO).inflate(0.25);
            MutableComponent label = first ? freq1 : freq2;
            boolean hit = behaviour.testHit(first, target.getLocation());
            ValueBoxTransform transform = first ? behaviour.firstSlot : behaviour.secondSlot;
            ValueBox box = new ValueBox((Component)label, bb, pos).passive(!hit);
            boolean empty = behaviour.getNetworkKey().get(first).getStack().isEmpty();
            if (!empty) {
                box.wideOutline();
            }
            Outliner.getInstance().showOutline(Pair.of((Object)first, (Object)pos), box.transform(transform)).highlightFace(result.getDirection());
            if (!hit) continue;
            ArrayList<MutableComponent> tip = new ArrayList<MutableComponent>();
            tip.add(label.copy());
            tip.add(CreateLang.translateDirect(empty ? "logistics.filter.click_to_set" : "logistics.filter.click_to_replace", new Object[0]));
            Create.VALUE_SETTINGS_HANDLER.showHoverTip(mc, tip);
        }
    }

    @Nullable
    public static LinkRenderState getLinkRenderState(SmartBlockEntity be, ItemModelResolver itemModelManager, double distance) {
        LinkBehaviour behaviour = be.getBehaviour(LinkBehaviour.TYPE);
        if (behaviour == null || behaviour.behaviour == null) {
            return null;
        }
        float max = behaviour.getRenderDistance();
        if ((double)(max * max) < distance) {
            return null;
        }
        return LinkRenderState.create(behaviour.firstSlot, behaviour.secondSlot, itemModelManager, behaviour.getFirstStack(), behaviour.getLastStack(), be.getLevel());
    }

    public record LinkRenderState(ValueBoxTransform firstSlot, ItemStackRenderState firstState, float firstOffset, ValueBoxTransform secondSlot, ItemStackRenderState secondState, float secondOffset) {
        public static LinkRenderState create(ValueBoxTransform firstSlot, ValueBoxTransform secondSlot, ItemModelResolver itemModelManager, ItemStack firstStack, ItemStack secondStack, Level world) {
            ItemStackRenderState firstState = new ItemStackRenderState();
            ItemStackRenderState secondState = new ItemStackRenderState();
            firstState.displayContext = secondState.displayContext = ItemDisplayContext.FIXED;
            itemModelManager.appendItemLayers(firstState, firstStack, firstState.displayContext, world, null, 0);
            itemModelManager.appendItemLayers(secondState, secondStack, secondState.displayContext, world, null, 0);
            return new LinkRenderState(firstSlot, firstState, ValueBoxRenderer.customZOffset(firstStack.getItem()), secondSlot, secondState, ValueBoxRenderer.customZOffset(secondStack.getItem()));
        }

        public void render(BlockState blockState, SubmitNodeCollector queue, PoseStack ms, int light) {
            ms.pushPose();
            this.firstSlot.transform(blockState, ms);
            ValueBoxRenderer.renderItemIntoValueBox(this.firstState, queue, ms, light, this.firstOffset);
            ms.popPose();
            ms.pushPose();
            this.secondSlot.transform(blockState, ms);
            ValueBoxRenderer.renderItemIntoValueBox(this.secondState, queue, ms, light, this.secondOffset);
            ms.popPose();
        }
    }
}

