/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.link.controller;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.AllItems;
import com.zurrtum.create.AllSoundEvents;
import com.zurrtum.create.client.catnip.lang.FontHelper;
import com.zurrtum.create.client.catnip.outliner.Outliner;
import com.zurrtum.create.client.foundation.item.TooltipHelper;
import com.zurrtum.create.client.foundation.utility.ControlsUtil;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.model.LinkedControllerModel;
import com.zurrtum.create.content.redstone.link.ServerLinkBehaviour;
import com.zurrtum.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.zurrtum.create.infrastructure.packet.c2s.LinkedControllerBindPacket;
import com.zurrtum.create.infrastructure.packet.c2s.LinkedControllerInputPacket;
import com.zurrtum.create.infrastructure.packet.c2s.LinkedControllerStopLecternPacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.ChatFormatting;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.tooltip.ClientTooltipComponent;
import net.minecraft.client.gui.screens.inventory.tooltip.DefaultTooltipPositioner;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.protocol.Packet;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.joml.Matrix3x2fStack;

public class LinkedControllerClientHandler {
    public static Mode MODE = Mode.IDLE;
    public static int PACKET_RATE = 5;
    public static Collection<Integer> currentlyPressed = new HashSet<Integer>();
    private static BlockPos lecternPos;
    private static BlockPos selectedLocation;
    private static int packetCooldown;

    public static void toggleBindMode(LocalPlayer player, BlockPos location) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.BIND;
            selectedLocation = location;
        } else {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
        }
    }

    public static void toggle(LocalPlayer player) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            lecternPos = null;
        } else {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
        }
    }

    public static void activateInLectern(BlockPos lecternAt) {
        if (MODE == Mode.IDLE) {
            MODE = Mode.ACTIVE;
            lecternPos = lecternAt;
        }
    }

    public static boolean deactivateInLectern(LocalPlayer player) {
        if (MODE == Mode.ACTIVE && LinkedControllerClientHandler.inLectern()) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
            return true;
        }
        return false;
    }

    public static boolean inLectern() {
        return lecternPos != null;
    }

    protected static void onReset(LocalPlayer player) {
        ControlsUtil.getControls().forEach(kb -> kb.setDown(ControlsUtil.isActuallyPressed(kb)));
        packetCooldown = 0;
        selectedLocation = BlockPos.ZERO;
        if (LinkedControllerClientHandler.inLectern()) {
            player.connection.send((Packet)new LinkedControllerStopLecternPacket(lecternPos));
        }
        lecternPos = null;
        if (!currentlyPressed.isEmpty()) {
            player.connection.send((Packet)new LinkedControllerInputPacket(currentlyPressed, false));
        }
        currentlyPressed.clear();
        LinkedControllerModel.resetButtons();
    }

    public static void tick(Minecraft mc) {
        LinkedControllerModel.tick(mc);
        if (MODE == Mode.IDLE) {
            return;
        }
        if (packetCooldown > 0) {
            --packetCooldown;
        }
        LocalPlayer player = mc.player;
        ClientLevel world = mc.level;
        ItemStack heldItem = player.getMainHandItem();
        if (player.isSpectator()) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
            return;
        }
        if (!(LinkedControllerClientHandler.inLectern() || heldItem.is((Item)AllItems.LINKED_CONTROLLER) || (heldItem = player.getOffhandItem()).is((Item)AllItems.LINKED_CONTROLLER))) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
            return;
        }
        if (LinkedControllerClientHandler.inLectern() && AllBlocks.LECTERN_CONTROLLER.getBlockEntityOptional((BlockGetter)world, lecternPos).map(be -> !be.isUsedBy((Player)mc.player)).orElse(true).booleanValue()) {
            LinkedControllerClientHandler.deactivateInLectern(player);
            return;
        }
        if (mc.screen != null) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
            return;
        }
        if (InputConstants.isKeyDown((Window)mc.getWindow(), (int)256)) {
            MODE = Mode.IDLE;
            LinkedControllerClientHandler.onReset(player);
            return;
        }
        List<KeyMapping> controls = ControlsUtil.getControls();
        HashSet<Integer> pressedKeys = new HashSet<Integer>();
        for (int i = 0; i < controls.size(); ++i) {
            if (!ControlsUtil.isActuallyPressed(controls.get(i))) continue;
            pressedKeys.add(i);
        }
        HashSet<Integer> newKeys = new HashSet<Integer>(pressedKeys);
        Collection<Integer> releasedKeys = currentlyPressed;
        newKeys.removeAll(releasedKeys);
        releasedKeys.removeAll(pressedKeys);
        if (MODE == Mode.ACTIVE) {
            if (!releasedKeys.isEmpty()) {
                player.connection.send((Packet)new LinkedControllerInputPacket(releasedKeys, false, lecternPos));
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.level(), (Vec3i)player.blockPosition(), 1.0f, 0.5f, true);
            }
            if (!newKeys.isEmpty()) {
                player.connection.send((Packet)new LinkedControllerInputPacket(newKeys, true, lecternPos));
                packetCooldown = PACKET_RATE;
                AllSoundEvents.CONTROLLER_CLICK.playAt(player.level(), (Vec3i)player.blockPosition(), 1.0f, 0.75f, true);
            }
            if (packetCooldown == 0 && !pressedKeys.isEmpty()) {
                player.connection.send((Packet)new LinkedControllerInputPacket(pressedKeys, true, lecternPos));
                packetCooldown = PACKET_RATE;
            }
        }
        if (MODE == Mode.BIND) {
            Iterator iterator;
            VoxelShape shape = world.getBlockState(selectedLocation).getShape((BlockGetter)world, selectedLocation);
            if (!shape.isEmpty()) {
                Outliner.getInstance().showAABB("controller", shape.bounds().move(selectedLocation)).colored(12008493).lineWidth(0.0625f);
            }
            if ((iterator = newKeys.iterator()).hasNext()) {
                Integer integer = (Integer)iterator.next();
                ServerLinkBehaviour linkBehaviour = BlockEntityBehaviour.get((BlockGetter)world, selectedLocation, ServerLinkBehaviour.TYPE);
                if (linkBehaviour != null) {
                    player.connection.send((Packet)new LinkedControllerBindPacket(integer, selectedLocation));
                    CreateLang.translate("linked_controller.key_bound", controls.get(integer).getTranslatedKeyMessage().getString()).sendStatus((Player)mc.player);
                }
                MODE = Mode.IDLE;
            }
        }
        currentlyPressed = pressedKeys;
        controls.forEach(kb -> kb.setDown(false));
    }

    public static void renderOverlay(Minecraft mc, GuiGraphics guiGraphics) {
        if (MODE != Mode.BIND) {
            return;
        }
        int width1 = guiGraphics.guiWidth();
        int height1 = guiGraphics.guiHeight();
        Matrix3x2fStack poseStack = guiGraphics.pose();
        poseStack.pushMatrix();
        Object[] keys = new Object[6];
        List<KeyMapping> controls = ControlsUtil.getControls();
        for (int i = 0; i < controls.size(); ++i) {
            KeyMapping keyBinding = controls.get(i);
            keys[i] = keyBinding.getTranslatedKeyMessage().getString();
        }
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(CreateLang.translateDirect("linked_controller.bind_mode", new Object[0]).withStyle(ChatFormatting.GOLD));
        list.addAll(TooltipHelper.cutTextComponent((Component)CreateLang.translateDirect("linked_controller.press_keybind", keys), FontHelper.Palette.ALL_GRAY));
        int width = 0;
        int n = list.size();
        Objects.requireNonNull(mc.font);
        int height = n * 9;
        for (Component component : list) {
            width = Math.max(width, mc.font.width((FormattedText)component));
        }
        int x = width1 / 3 - width / 2;
        int n2 = height1 - height - 24;
        guiGraphics.renderTooltip(mc.font, list.stream().map(Component::getVisualOrderText).map(ClientTooltipComponent::create).collect(Collectors.toList()), x, n2, DefaultTooltipPositioner.INSTANCE, null);
        poseStack.popMatrix();
    }

    static {
        selectedLocation = BlockPos.ZERO;
    }

    public static enum Mode {
        IDLE,
        ACTIVE,
        BIND;

    }
}

