/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.nixieTube;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.catnip.data.Couple;
import com.zurrtum.create.catnip.math.AngleHelper;
import com.zurrtum.create.catnip.theme.Color;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.lib.util.ShadersModHelper;
import com.zurrtum.create.client.foundation.render.CreateRenderTypes;
import com.zurrtum.create.client.foundation.utility.DyeHelper;
import com.zurrtum.create.content.redstone.nixieTube.DoubleFaceAttachedBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlock;
import com.zurrtum.create.content.redstone.nixieTube.NixieTubeBlockEntity;
import com.zurrtum.create.content.trains.signal.SignalBlockEntity;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.font.TextRenderable;
import net.minecraft.client.gui.font.glyphs.BakedGlyph;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Style;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionfc;

public class NixieTubeRenderer
implements BlockEntityRenderer<NixieTubeBlockEntity, NixieTubeRenderState> {
    protected final Font textRenderer;

    public NixieTubeRenderer(BlockEntityRendererProvider.Context context) {
        this.textRenderer = context.font();
    }

    public NixieTubeRenderState createRenderState() {
        return new NixieTubeRenderState();
    }

    public void extractRenderState(NixieTubeBlockEntity be, NixieTubeRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        if (be.signalState != null) {
            NixieTubeRenderer.updateSignalRenderState(be, state, cameraPos);
        } else {
            NixieTubeRenderer.updateTextRenderState(this.textRenderer, be, state);
        }
    }

    public static void updateTextRenderState(Font textRenderer, NixieTubeBlockEntity be, NixieTubeRenderState state) {
        TextRenderState data = new TextRenderState();
        DoubleFaceAttachedBlock.DoubleAttachFace face = (DoubleFaceAttachedBlock.DoubleAttachFace)((Object)state.blockState.getValue((Property)NixieTubeBlock.FACE));
        Direction facing = (Direction)state.blockState.getValue((Property)NixieTubeBlock.FACING);
        data.yRot = (float)Math.PI / 180 * (AngleHelper.horizontalAngle(facing) - 90.0f + (float)(face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 180 : 0));
        data.zRot = (float)Math.PI / 180 * (float)(face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL ? -90 : (face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 90 : 0));
        if (face == DoubleFaceAttachedBlock.DoubleAttachFace.CEILING || facing == Direction.DOWN) {
            data.zRot2 = (float)Math.PI;
        }
        data.layer = RenderTypes.translucentMovingBlock();
        data.light = state.lightCoords;
        data.tube = CachedBuffers.partial(AllPartialModels.NIXIE_TUBE, state.blockState);
        Couple<String> s = be.getDisplayedStrings();
        if (s != null) {
            DyeColor color = NixieTubeBlock.colorOf(state.blockState);
            float flicker = be.getLevel().random.nextFloat();
            Couple<Integer> couple = DyeHelper.getDyeColors(color);
            int brightColor = (Integer)couple.getFirst() | 0xFF000000;
            int darkColor = (Integer)couple.getSecond() | 0xFF000000;
            int flickeringBrightColor = Color.mixColors(brightColor, darkColor, flicker / 4.0f);
            int y = face == DoubleFaceAttachedBlock.DoubleAttachFace.CEILING ? -5 : -3;
            data.left = NixieTubeRenderer.createTextDrawable(textRenderer, (String)s.getFirst(), y, flickeringBrightColor, darkColor);
            data.right = NixieTubeRenderer.createTextDrawable(textRenderer, (String)s.getSecond(), y, flickeringBrightColor, darkColor);
        }
        state.data = data;
    }

    @Nullable
    public static TextDrawableState createTextDrawable(Font textRenderer, String text, int y, int flickeringBrightColor, int darkColor) {
        int code = NixieTubeRenderer.visit(text);
        if (code == 32) {
            return null;
        }
        BakedGlyph glyph = textRenderer.getGlyphSource(Style.EMPTY.getFont()).getGlyph(code);
        TextRenderable.Styled bright = glyph.createGlyph(0.0f, 0.0f, flickeringBrightColor, 0, Style.EMPTY, 0.0f, 0.0f);
        if (bright == null) {
            return null;
        }
        TextRenderable.Styled dark = glyph.createGlyph(0.0f, 0.0f, darkColor, 0, Style.EMPTY, 0.0f, 0.0f);
        TextRenderable.Styled mix = glyph.createGlyph(0.0f, 0.0f, Color.mixColors(darkColor, -16777216, 0.35f), 0, Style.EMPTY, 0.0f, 0.0f);
        float x = ((float)textRenderer.width(text) - 0.5f) / -2.0f;
        return new TextDrawableState(bright.renderType(Font.DisplayMode.NORMAL), x, y, (TextRenderable)bright, (TextRenderable)dark, (TextRenderable)mix);
    }

    public static int visit(String text) {
        int length = text.length();
        if (length == 0) {
            return 32;
        }
        char c = text.charAt(0);
        if (Character.isHighSurrogate(c)) {
            if (length == 1) {
                return 65533;
            }
            char d = text.charAt(1);
            if (Character.isLowSurrogate(d)) {
                return Character.toCodePoint(c, d);
            }
            return 65533;
        }
        if (Character.isSurrogate(c)) {
            return 65533;
        }
        return c;
    }

    public static void updateSignalRenderState(NixieTubeBlockEntity be, NixieTubeRenderState state, Vec3 cameraPos) {
        int zRot;
        SignalRenderState data = new SignalRenderState();
        state.data = data;
        DoubleFaceAttachedBlock.DoubleAttachFace face = (DoubleFaceAttachedBlock.DoubleAttachFace)((Object)state.blockState.getValue((Property)NixieTubeBlock.FACE));
        Direction facing = NixieTubeBlock.getFacing(state.blockState);
        data.yRot = (float)Math.PI / 180 * (AngleHelper.horizontalAngle((Direction)state.blockState.getValue((Property)NixieTubeBlock.FACING)) - 90.0f + (float)(face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 180 : 0));
        int n = face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL ? -90 : (zRot = face == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 90 : 0);
        if (facing == Direction.DOWN) {
            zRot += 180;
        }
        data.zRot = (float)Math.PI / 180 * (float)zRot;
        data.light = state.lightCoords;
        data.layer = RenderTypes.solidMovingBlock();
        data.panel = CachedBuffers.partial(AllPartialModels.SIGNAL_PANEL, state.blockState);
        data.offset = facing == Direction.DOWN || state.blockState.getValue((Property)NixieTubeBlock.FACE) == DoubleFaceAttachedBlock.DoubleAttachFace.WALL_REVERSED ? 0.25f : -0.25f;
        SignalDrawableState left = data.left = new SignalDrawableState();
        SignalBlockEntity.SignalState signalState = be.signalState;
        float renderTime = AnimationTickHolder.getRenderTime((LevelAccessor)be.getLevel());
        boolean yellow = signalState.isYellowLight(renderTime);
        float longSide = yellow ? 1.0f : 4.0f;
        float longSideGlow = yellow ? 2.0f : 5.125f;
        boolean vert = facing.getAxis().isHorizontal();
        double distance = Vec3.atCenterOf((Vec3i)state.blockPos).subtract(cameraPos).lengthSqr();
        left.light = state.lightCoords;
        left.layer = CreateRenderTypes.translucent();
        if (signalState.isRedLight(renderTime)) {
            left.additive = true;
            if (distance < 9216.0) {
                left.cubeLayer = left.layer;
                left.cube = CachedBuffers.partial(AllPartialModels.SIGNAL_WHITE_CUBE, state.blockState);
                left.glow = CachedBuffers.partial(AllPartialModels.SIGNAL_RED_GLOW, state.blockState);
                if (vert) {
                    left.cubeX = 1.0f;
                    left.cubeY = longSide;
                    left.glowX = 2.0f;
                    left.glowY = longSideGlow;
                } else {
                    left.cubeX = longSide;
                    left.cubeY = 1.0f;
                    left.glowX = longSideGlow;
                    left.glowY = 2.0f;
                }
            }
            left.layer = CreateRenderTypes.additive2();
            left.layer2 = CreateRenderTypes.additive();
            left.signal = CachedBuffers.partial(AllPartialModels.SIGNAL_RED, state.blockState);
        } else {
            left.signal = CachedBuffers.partial(AllPartialModels.NIXIE_TUBE_SINGLE, state.blockState);
        }
        SignalDrawableState right = data.right = new SignalDrawableState();
        right.light = state.lightCoords;
        right.layer = CreateRenderTypes.translucent();
        if (yellow || signalState.isGreenLight(renderTime)) {
            right.additive = true;
            if (distance < 9216.0) {
                right.cubeLayer = right.layer;
                right.cube = CachedBuffers.partial(AllPartialModels.SIGNAL_WHITE_CUBE, state.blockState);
                right.glow = CachedBuffers.partial(yellow ? AllPartialModels.SIGNAL_YELLOW_GLOW : AllPartialModels.SIGNAL_WHITE_GLOW, state.blockState);
                if (vert) {
                    right.cubeX = longSide;
                    right.cubeY = 1.0f;
                    right.glowX = longSideGlow;
                    right.glowY = 2.0f;
                } else {
                    right.cubeX = 1.0f;
                    right.cubeY = longSide;
                    right.glowX = 2.0f;
                    right.glowY = longSideGlow;
                }
            }
            right.layer = CreateRenderTypes.additive2();
            right.layer2 = CreateRenderTypes.additive();
            right.signal = CachedBuffers.partial(yellow ? AllPartialModels.SIGNAL_YELLOW : AllPartialModels.SIGNAL_WHITE, state.blockState);
        } else {
            right.signal = CachedBuffers.partial(AllPartialModels.NIXIE_TUBE_SINGLE, state.blockState);
        }
    }

    public void submit(NixieTubeRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        state.data.render(matrices, queue);
    }

    public static void drawInWorldString(Font fontRenderer, PoseStack ms, MultiBufferSource buffer, String c, int color) {
        fontRenderer.drawInBatch(c, 0.0f, 0.0f, color, false, ms.last().pose(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
    }

    public int getViewDistance() {
        return 128;
    }

    public static class NixieTubeRenderState
    extends BlockEntityRenderState {
        public NixieTubeRenderData data;
    }

    public static class TextRenderState
    implements NixieTubeRenderData,
    SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public float yRot;
        public float zRot;
        public float zRot2;
        public TextDrawableState left;
        public TextDrawableState right;
        public SuperByteBuffer tube;
        public int light;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.tube.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        @Override
        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            SubmitNodeCollector batchingQueue;
            matrices.pushPose();
            matrices.translate(0.5f, 0.5f, 0.5f);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.yRot));
            matrices.mulPose((Quaternionfc)Axis.ZP.rotation(this.zRot));
            Object object = batchingQueue = ShadersModHelper.isShaderPackInUse() ? queue.order(1) : queue;
            if (this.zRot2 != 0.0f) {
                matrices.pushPose();
                matrices.mulPose((Quaternionfc)Axis.ZP.rotation(this.zRot2));
                batchingQueue.submitCustomGeometry(matrices, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
                matrices.popPose();
            } else {
                batchingQueue.submitCustomGeometry(matrices, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
            }
            if (this.left != null) {
                matrices.pushPose();
                matrices.translate(-0.25f, 0.0f, 0.0f);
                matrices.scale(0.05f, -0.05f, 0.05f);
                queue.submitCustomGeometry(matrices, this.left.layer, (SubmitNodeCollector.CustomGeometryRenderer)this.left);
                matrices.popPose();
            }
            if (this.right != null) {
                matrices.translate(0.25f, 0.0f, 0.0f);
                matrices.scale(0.05f, -0.05f, 0.05f);
                queue.submitCustomGeometry(matrices, this.right.layer, (SubmitNodeCollector.CustomGeometryRenderer)this.right);
            }
            matrices.popPose();
        }
    }

    public record TextDrawableState(RenderType layer, float x, int y, TextRenderable bright, TextRenderable dark, TextRenderable mix) implements SubmitNodeCollector.CustomGeometryRenderer
    {
        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            Matrix4f pose = matricesEntry.pose();
            pose.translate(this.x, (float)this.y, 0.0f);
            this.bright.render(pose, vertexConsumer, 0xF000F0, false);
            pose.translate(0.5f, 0.5f, -0.0625f);
            this.dark.render(pose, vertexConsumer, 0xF000F0, false);
            pose.scale(-1.0f, 1.0f, 1.0f);
            pose.translate(0.5f + this.x + this.x, -0.5f, 0.0625f);
            this.dark.render(pose, vertexConsumer, 0xF000F0, false);
            pose.translate(-0.5f, 0.5f, -0.0625f);
            this.mix.render(pose, vertexConsumer, 0xF000F0, false);
        }
    }

    public static interface NixieTubeRenderData {
        public void render(PoseStack var1, SubmitNodeCollector var2);
    }

    public static class SignalRenderState
    implements NixieTubeRenderData,
    SubmitNodeCollector.CustomGeometryRenderer {
        public float yRot;
        public float zRot;
        public int light;
        public RenderType layer;
        public SuperByteBuffer panel;
        public float offset;
        public SignalDrawableState left;
        public SignalDrawableState right;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.panel.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }

        @Override
        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            matrices.pushPose();
            matrices.translate(0.5f, 0.5f, 0.5f);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.yRot));
            matrices.mulPose((Quaternionfc)Axis.ZP.rotation(this.zRot));
            matrices.translate(-0.5f, -0.5f, -0.5f);
            queue.submitCustomGeometry(matrices, this.layer, (SubmitNodeCollector.CustomGeometryRenderer)this);
            matrices.translate(0.5f, 0.46875f, 0.5f);
            matrices.pushPose();
            matrices.translate(this.offset, 0.0f, 0.0f);
            this.left.render(matrices, queue);
            matrices.popPose();
            matrices.translate(-this.offset, 0.0f, 0.0f);
            this.right.render(matrices, queue);
            matrices.popPose();
        }
    }

    public static class SignalDrawableState {
        public RenderType layer;
        public RenderType layer2;
        public SuperByteBuffer signal;
        public int light;
        public RenderType cubeLayer;
        public SuperByteBuffer cube;
        public float cubeX;
        public float cubeY;
        public SuperByteBuffer glow;
        public float glowX;
        public float glowY;
        public boolean additive;

        public void render(PoseStack matrices, SubmitNodeCollector queue) {
            if (ShadersModHelper.isShaderPackInUse()) {
                if (this.additive) {
                    queue.order(1).submitCustomGeometry(matrices, this.layer, (e, v) -> this.renderAdditive(e, v, 153));
                    if (this.cube != null) {
                        queue.order(1).submitCustomGeometry(matrices, this.cubeLayer, this::renderCube);
                    }
                    queue.order(2).submitCustomGeometry(matrices, this.layer2, (e, v) -> this.renderAdditive(e, v, 102));
                } else {
                    queue.order(1).submitCustomGeometry(matrices, this.layer, this::renderNormal);
                }
            } else if (this.additive) {
                queue.submitCustomGeometry(matrices, this.layer, (e, v) -> this.renderAdditive(e, v, 153));
                if (this.cube != null) {
                    queue.submitCustomGeometry(matrices, this.cubeLayer, this::renderCube);
                }
                queue.submitCustomGeometry(matrices, this.layer2, (e, v) -> this.renderAdditive(e, v, 102));
            } else {
                queue.submitCustomGeometry(matrices, this.layer, this::renderNormal);
            }
        }

        public void renderCube(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)this.cube.light(0xF000F0).disableDiffuse().scale(this.cubeX, this.cubeY, 1.0f)).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderAdditive(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer, int color) {
            if (this.glow != null) {
                ((SuperByteBuffer)this.glow.light(0xF000F0).disableDiffuse().scale(this.glowX, this.glowY, 2.0f)).color(color, color, color, color).renderInto(matricesEntry, vertexConsumer);
            }
            ((SuperByteBuffer)this.signal.light(0xF000F0).disableDiffuse().scale(1.0625f)).color(color, color, color, color).renderInto(matricesEntry, vertexConsumer);
        }

        public void renderNormal(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            this.signal.light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }
}

