/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.redstone.thresholdSwitch;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.catnip.data.Iterate;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.ScreenOpener;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.AbstractSimiWidget;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.gui.widget.ScrollInput;
import com.zurrtum.create.client.foundation.gui.widget.SelectionScrollInput;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.client.infrastructure.ponder.AllCreatePonderTags;
import com.zurrtum.create.client.ponder.foundation.ui.PonderTagScreen;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchBlockEntity;
import com.zurrtum.create.content.redstone.thresholdSwitch.ThresholdSwitchObservable;
import com.zurrtum.create.infrastructure.packet.c2s.ConfigureThresholdSwitchPacket;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RedstoneTorchBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class ThresholdSwitchScreen
extends AbstractSimiScreen {
    private ScrollInput offBelow;
    private ScrollInput onAbove;
    private SelectionScrollInput inStacks;
    private IconButton confirmButton;
    private IconButton flipSignals;
    private final Component invertSignal = CreateLang.translateDirect("gui.threshold_switch.invert_signal", new Object[0]);
    private ElementWidget renderedItem;
    private ElementWidget torchPower;
    private ElementWidget torchOff;
    private AllGuiTextures background = AllGuiTextures.THRESHOLD_SWITCH;
    private ThresholdSwitchBlockEntity blockEntity;
    private int lastModification;

    public ThresholdSwitchScreen(ThresholdSwitchBlockEntity be) {
        super((Component)CreateLang.translateDirect("gui.threshold_switch.title", new Object[0]));
        this.blockEntity = be;
        this.lastModification = -1;
    }

    @Override
    protected void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        this.setWindowOffset(-20, 0);
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop;
        this.inStacks = (SelectionScrollInput)new SelectionScrollInput(x + 100, y + 23, 52, 42).forOptions(List.of(CreateLang.translateDirect("schedule.condition.threshold.items", new Object[0]), CreateLang.translateDirect("schedule.condition.threshold.stacks", new Object[0]))).titled(CreateLang.translateDirect("schedule.condition.threshold.item_measure", new Object[0])).setState(this.blockEntity.inStacks ? 1 : 0);
        this.offBelow = new ScrollInput(x + 48, y + 47, 1, 18).withRange(this.blockEntity.getMinLevel(), this.blockEntity.getMaxLevel() + 1 - this.getValueStep()).titled(CreateLang.translateDirect("gui.threshold_switch.lower_threshold", new Object[0])).calling(state -> {
            this.lastModification = 0;
            int valueStep = this.getValueStep();
            if (this.onAbove.getState() / valueStep == 0 && state / valueStep == 0) {
                return;
            }
            if (this.onAbove.getState() / valueStep <= state / valueStep) {
                this.onAbove.setState((state + valueStep) / valueStep * valueStep);
                this.onAbove.onChanged();
            }
        }).withStepFunction(sc -> sc.shift ? 10 * this.getValueStep() : this.getValueStep()).setState(this.blockEntity.offWhenBelow);
        this.onAbove = new ScrollInput(x + 48, y + 23, 1, 18).withRange(this.blockEntity.getMinLevel() + this.getValueStep(), this.blockEntity.getMaxLevel() + 1).titled(CreateLang.translateDirect("gui.threshold_switch.upper_threshold", new Object[0])).calling(state -> {
            this.lastModification = 0;
            int valueStep = this.getValueStep();
            if (this.offBelow.getState() / valueStep == 0 && state / valueStep == 0) {
                return;
            }
            if (this.offBelow.getState() / valueStep >= state / valueStep) {
                this.offBelow.setState((state - valueStep) / valueStep * valueStep);
                this.offBelow.onChanged();
            }
        }).withStepFunction(sc -> sc.shift ? 10 * this.getValueStep() : this.getValueStep()).setState(this.blockEntity.onWhenAbove);
        this.onAbove.onChanged();
        this.offBelow.onChanged();
        this.addRenderableWidget(this.onAbove);
        this.addRenderableWidget(this.offBelow);
        this.addRenderableWidget(this.inStacks);
        this.confirmButton = new IconButton(x + this.background.getWidth() - 33, y + this.background.getHeight() - 24, AllIcons.I_CONFIRM);
        this.confirmButton.withCallback(this::onClose);
        this.addRenderableWidget(this.confirmButton);
        this.flipSignals = new IconButton(x + this.background.getWidth() - 62, y + this.background.getHeight() - 24, AllIcons.I_FLIP);
        this.flipSignals.withCallback(() -> this.send(!this.blockEntity.isInverted()));
        this.flipSignals.setToolTip(this.invertSignal);
        this.addRenderableWidget(this.flipSignals);
        this.renderedItem = new ElementWidget(x + this.background.getWidth() + 6, y + this.background.getHeight() - 56).showingElement(GuiGameElement.of(AllItems.THRESHOLD_SWITCH.getDefaultInstance()).scale(5.0f));
        this.addRenderableWidget(this.renderedItem);
        BlockState torch = Blocks.REDSTONE_TORCH.defaultBlockState();
        this.torchPower = new ElementWidget(x + 22, y + 19).showingElement(GuiGameElement.of(torch).rotate(-22.5f, 45.0f, 0.0f).scale(1.25f));
        this.addRenderableWidget(this.torchPower);
        this.torchOff = new ElementWidget(x + 22, y + 43).showingElement(GuiGameElement.of((BlockState)torch.setValue((Property)RedstoneTorchBlock.LIT, (Comparable)Boolean.valueOf(false))).rotate(-22.5f, 45.0f, 0.0f).scale(1.25f));
        this.addRenderableWidget(this.torchOff);
        this.updateInputBoxes();
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
        this.torchPower.getRenderElement().clear();
        this.torchOff.getRenderElement().clear();
    }

    public boolean mouseClicked(MouseButtonEvent click, boolean doubled) {
        int itemX = this.guiLeft + 13;
        int itemY = this.guiTop + 80;
        double mouseX = click.x();
        double mouseY = click.y();
        if (mouseX >= (double)itemX && mouseX < (double)(itemX + 16) && mouseY >= (double)itemY && mouseY < (double)(itemY + 16)) {
            ScreenOpener.open(new PonderTagScreen(AllCreatePonderTags.THRESHOLD_SWITCH_TARGETS));
            return true;
        }
        return super.mouseClicked(click, doubled);
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        boolean stacks;
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        graphics.drawString(this.font, this.title, x + this.background.getWidth() / 2 - this.font.width((FormattedText)this.title) / 2, y + 4, -10935260, false);
        ThresholdSwitchBlockEntity.ThresholdType typeOfCurrentTarget = this.blockEntity.getTypeOfCurrentTarget();
        boolean forItems = typeOfCurrentTarget == ThresholdSwitchBlockEntity.ThresholdType.ITEM;
        AllGuiTextures inputBg = forItems ? AllGuiTextures.THRESHOLD_SWITCH_ITEMCOUNT_INPUTS : AllGuiTextures.THRESHOLD_SWITCH_MISC_INPUTS;
        inputBg.render(graphics, x + 44, y + 21);
        inputBg.render(graphics, x + 44, y + 21 + 24);
        int valueStep = 1;
        boolean bl = stacks = this.inStacks.getState() == 1;
        if (typeOfCurrentTarget == ThresholdSwitchBlockEntity.ThresholdType.FLUID) {
            valueStep = 81000;
        }
        if (forItems) {
            MutableComponent suffix = this.inStacks.getState() == 0 ? CreateLang.translateDirect("schedule.condition.threshold.items", new Object[0]) : CreateLang.translateDirect("schedule.condition.threshold.stacks", new Object[0]);
            valueStep = this.inStacks.getState() == 0 ? 1 : 64;
            graphics.drawString(this.font, (Component)suffix, x + 105, y + 28, -1, true);
            graphics.drawString(this.font, (Component)suffix, x + 105, y + 28 + 24, -1, true);
        }
        graphics.drawString(this.font, (Component)Component.literal((String)("\u2265 " + String.valueOf(typeOfCurrentTarget == ThresholdSwitchBlockEntity.ThresholdType.UNSUPPORTED ? "" : (forItems ? Integer.valueOf(this.onAbove.getState() / valueStep) : ThresholdSwitchScreen.format(this.blockEntity, this.onAbove.getState() / valueStep, stacks).getString())))), x + 53, y + 28, -1, true);
        graphics.drawString(this.font, (Component)Component.literal((String)("\u2264 " + String.valueOf(typeOfCurrentTarget == ThresholdSwitchBlockEntity.ThresholdType.UNSUPPORTED ? "" : (forItems ? Integer.valueOf(this.offBelow.getState() / valueStep) : ThresholdSwitchScreen.format(this.blockEntity, this.offBelow.getState() / valueStep, stacks).getString())))), x + 53, y + 28 + 24, -1, true);
        int itemX = x + 13;
        int itemY = y + 80;
        ItemStack displayItem = this.blockEntity.getDisplayItemForScreen();
        graphics.renderItem(displayItem.isEmpty() ? new ItemStack((ItemLike)Items.BARRIER) : displayItem, itemX, itemY);
        int torchX = x + 23;
        int torchY = y + 24;
        boolean highlightTopRow = this.blockEntity.isInverted() ^ this.blockEntity.isPowered();
        AllGuiTextures.THRESHOLD_SWITCH_CURRENT_STATE.render(graphics, torchX - 3, torchY - 4 + (highlightTopRow ? 0 : 24));
        if (this.blockEntity.isInverted()) {
            this.torchPower.setY(y + 43);
            this.torchOff.setY(y + 19);
        } else {
            this.torchPower.setY(y + 19);
            this.torchOff.setY(y + 43);
        }
        if (mouseX >= itemX && mouseX < itemX + 16 && mouseY >= itemY && mouseY < itemY + 16) {
            ArrayList<Object> list = new ArrayList<Object>();
            if (displayItem.isEmpty()) {
                list.add(CreateLang.translateDirect("gui.threshold_switch.not_attached", new Object[0]));
                list.add(CreateLang.translateDirect("display_link.view_compatible", new Object[0]).withStyle(ChatFormatting.DARK_GRAY));
                graphics.setComponentTooltipForNextFrame(this.font, list, mouseX, mouseY);
                return;
            }
            list.add(displayItem.getHoverName());
            if (typeOfCurrentTarget == ThresholdSwitchBlockEntity.ThresholdType.UNSUPPORTED) {
                list.add(CreateLang.translateDirect("gui.threshold_switch.incompatible", new Object[0]).withStyle(ChatFormatting.GRAY));
                list.add(CreateLang.translateDirect("display_link.view_compatible", new Object[0]).withStyle(ChatFormatting.DARK_GRAY));
                graphics.setComponentTooltipForNextFrame(this.font, list, mouseX, mouseY);
                return;
            }
            CreateLang.translate("gui.threshold_switch.currently", ThresholdSwitchScreen.format(this.blockEntity, this.blockEntity.currentLevel / valueStep, stacks)).style(ChatFormatting.DARK_AQUA).addTo(list);
            if (this.blockEntity.currentMinLevel / valueStep == 0) {
                CreateLang.translate("gui.threshold_switch.range_max", ThresholdSwitchScreen.format(this.blockEntity, this.blockEntity.currentMaxLevel / valueStep, stacks)).style(ChatFormatting.GRAY).addTo(list);
            } else {
                CreateLang.translate("gui.threshold_switch.range", this.blockEntity.currentMinLevel / valueStep, ThresholdSwitchScreen.format(this.blockEntity, this.blockEntity.currentMaxLevel / valueStep, stacks)).style(ChatFormatting.GRAY).addTo(list);
            }
            list.add(CreateLang.translateDirect("display_link.view_compatible", new Object[0]).withStyle(ChatFormatting.DARK_GRAY));
            graphics.setComponentTooltipForNextFrame(this.font, list, mouseX, mouseY);
            return;
        }
        for (boolean power : Iterate.trueAndFalse) {
            int thisTorchY;
            int n = thisTorchY = power ? torchY : torchY + 26;
            if (mouseX < torchX || mouseX >= torchX + 16 || mouseY < thisTorchY || mouseY >= thisTorchY + 16) continue;
            graphics.setComponentTooltipForNextFrame(this.font, List.of(CreateLang.translate(power ^ this.blockEntity.isInverted() ? "gui.threshold_switch.power_on_when" : "gui.threshold_switch.power_off_when", new Object[0]).color(AbstractSimiWidget.HEADER_RGB).component()), mouseX, mouseY);
            return;
        }
    }

    public static MutableComponent format(ThresholdSwitchBlockEntity be, int value, boolean stacks) {
        BlockEntity blockEntity;
        ThresholdSwitchBlockEntity.ThresholdType type = be.getTypeOfCurrentTarget();
        if (type == ThresholdSwitchBlockEntity.ThresholdType.CUSTOM && (blockEntity = be.getLevel().getBlockEntity(be.getTargetPos())) instanceof ThresholdSwitchObservable) {
            ThresholdSwitchObservable tso = (ThresholdSwitchObservable)blockEntity;
            return tso.format(value);
        }
        String suffix = type == ThresholdSwitchBlockEntity.ThresholdType.ITEM ? (stacks ? "schedule.condition.threshold.stacks" : "schedule.condition.threshold.items") : "schedule.condition.threshold.buckets";
        return CreateLang.text(value + " ").add(CreateLang.translate(suffix, new Object[0])).component();
    }

    @Override
    public void tick() {
        super.tick();
        if (this.lastModification >= 0) {
            ++this.lastModification;
        }
        if (this.lastModification >= 20) {
            this.lastModification = -1;
            this.send(this.blockEntity.isInverted());
        }
        if (this.inStacks == null) {
            return;
        }
        this.updateInputBoxes();
    }

    private void updateInputBoxes() {
        ThresholdSwitchBlockEntity.ThresholdType typeOfCurrentTarget = this.blockEntity.getTypeOfCurrentTarget();
        boolean forItems = typeOfCurrentTarget == ThresholdSwitchBlockEntity.ThresholdType.ITEM;
        int valueStep = this.getValueStep();
        this.inStacks.active = this.inStacks.visible = forItems;
        this.onAbove.setWidth(forItems ? 48 : 103);
        this.offBelow.setWidth(forItems ? 48 : 103);
        this.onAbove.visible = typeOfCurrentTarget != ThresholdSwitchBlockEntity.ThresholdType.UNSUPPORTED;
        this.offBelow.visible = typeOfCurrentTarget != ThresholdSwitchBlockEntity.ThresholdType.UNSUPPORTED;
        int min = this.blockEntity.currentMinLevel + valueStep;
        int max = this.blockEntity.currentMaxLevel;
        this.onAbove.withRange(min, max + 1);
        int roundedState = Mth.clamp((int)(this.onAbove.getState() / valueStep * valueStep), (int)min, (int)max);
        if (roundedState != this.onAbove.getState()) {
            this.onAbove.setState(roundedState);
            this.onAbove.onChanged();
        }
        min = this.blockEntity.currentMinLevel;
        max = this.blockEntity.currentMaxLevel - valueStep;
        this.offBelow.withRange(min, max + 1);
        roundedState = Mth.clamp((int)(this.offBelow.getState() / valueStep * valueStep), (int)min, (int)max);
        if (roundedState != this.offBelow.getState()) {
            this.offBelow.setState(roundedState);
            this.offBelow.onChanged();
        }
    }

    private int getValueStep() {
        boolean stacks = this.inStacks.getState() == 1;
        int valueStep = 1;
        if (this.blockEntity.getTypeOfCurrentTarget() == ThresholdSwitchBlockEntity.ThresholdType.FLUID) {
            valueStep = 81000;
        } else if (stacks) {
            valueStep = 64;
        }
        return valueStep;
    }

    public void removed() {
        this.send(this.blockEntity.isInverted());
    }

    protected void send(boolean invert) {
        this.minecraft.player.connection.send((Packet)new ConfigureThresholdSwitchPacket(this.blockEntity.getBlockPos(), this.offBelow.getState(), this.onAbove.getState(), invert, this.inStacks.getState() == 1));
    }
}

