/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.cannon;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.zurrtum.create.AllBlocks;
import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.catnip.render.CachedBuffers;
import com.zurrtum.create.client.catnip.render.SuperByteBuffer;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationManager;
import com.zurrtum.create.content.schematics.cannon.LaunchedItem;
import com.zurrtum.create.content.schematics.cannon.SchematicannonBlockEntity;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.SubmitNodeCollector;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.blockentity.state.BlockEntityRenderState;
import net.minecraft.client.renderer.feature.ModelFeatureRenderer;
import net.minecraft.client.renderer.item.ItemModelResolver;
import net.minecraft.client.renderer.item.ItemStackRenderState;
import net.minecraft.client.renderer.rendertype.RenderType;
import net.minecraft.client.renderer.rendertype.RenderTypes;
import net.minecraft.client.renderer.state.CameraRenderState;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionfc;

public class SchematicannonRenderer
implements BlockEntityRenderer<SchematicannonBlockEntity, SchematicannonRenderState> {
    protected final ItemModelResolver itemModelManager;

    public SchematicannonRenderer(BlockEntityRendererProvider.Context context) {
        this.itemModelManager = context.itemModelResolver();
    }

    public SchematicannonRenderState createRenderState() {
        return new SchematicannonRenderState();
    }

    public void extractRenderState(SchematicannonBlockEntity be, SchematicannonRenderState state, float tickProgress, Vec3 cameraPos, @Nullable ModelFeatureRenderer.CrumblingOverlay crumblingOverlay) {
        Level world = be.getLevel();
        boolean support = VisualizationManager.supportsVisualization((LevelAccessor)world);
        boolean empty = be.flyingBlocks.isEmpty();
        if (support && empty) {
            return;
        }
        BlockEntityRenderState.extractBase((BlockEntity)be, (BlockEntityRenderState)state, (ModelFeatureRenderer.CrumblingOverlay)crumblingOverlay);
        if (!empty) {
            state.blocks = this.getFlyBlocksRenderState(be, world, state.blockPos, tickProgress);
        }
        if (support) {
            return;
        }
        SchematicannonRenderData data = state.data = new SchematicannonRenderData();
        data.layer = RenderTypes.solidMovingBlock();
        double[] cannonAngles = SchematicannonRenderer.getCannonAngles(be, state.blockPos, tickProgress);
        double recoil = SchematicannonRenderer.getRecoil(be, tickProgress);
        data.connector = CachedBuffers.partial(AllPartialModels.SCHEMATICANNON_CONNECTOR, state.blockState);
        data.yaw = (float)(0.01745329238474369 * (cannonAngles[0] + 90.0));
        data.pipe = CachedBuffers.partial(AllPartialModels.SCHEMATICANNON_PIPE, state.blockState);
        data.pitch = (float)(0.01745329238474369 * cannonAngles[1]);
        data.offset = (float)(-recoil / 100.0);
        data.light = state.lightCoords;
    }

    public void submit(SchematicannonRenderState state, PoseStack matrices, SubmitNodeCollector queue, CameraRenderState cameraState) {
        if (state.blocks != null) {
            for (LaunchedRenderState block : state.blocks) {
                block.render(matrices, queue, state.lightCoords);
            }
        }
        if (state.data != null) {
            queue.submitCustomGeometry(matrices, state.data.layer, (SubmitNodeCollector.CustomGeometryRenderer)state.data);
        }
    }

    @Nullable
    public List<LaunchedRenderState> getFlyBlocksRenderState(SchematicannonBlockEntity be, Level world, BlockPos pos, float partialTicks) {
        ArrayList<LaunchedRenderState> blocks = new ArrayList<LaunchedRenderState>();
        Vec3 position = Vec3.atCenterOf((Vec3i)pos.above());
        for (LaunchedItem launched : be.flyingBlocks) {
            if (launched.ticksRemaining == 0) continue;
            Vec3 target = Vec3.atCenterOf((Vec3i)launched.target);
            Vec3 distance = target.subtract(position);
            double yDifference = target.y - position.y;
            double throwHeight = Math.sqrt(distance.lengthSqr()) * (double)0.6f + yDifference;
            Vec3 cannonOffset = distance.add(0.0, throwHeight, 0.0).normalize().scale(2.0);
            Vec3 start = position.add(cannonOffset);
            yDifference = target.y - start.y;
            float t = ((float)launched.totalTicks - ((float)(launched.ticksRemaining + 1) - partialTicks)) / (float)launched.totalTicks;
            Vec3 blockLocationXZ = target.subtract(start).scale((double)t).multiply(1.0, 0.0, 1.0);
            double yOffset = (double)(2.0f * (1.0f - t) * t) * throwHeight + (double)(t * t) * yDifference;
            Vec3 blockLocation = blockLocationXZ.add(0.5, yOffset + 1.5, 0.5).add(cannonOffset);
            float angle = (float)Math.PI * 2 * t;
            if (launched instanceof LaunchedItem.ForBlockState) {
                LaunchedItem.ForBlockState forBlockState = (LaunchedItem.ForBlockState)launched;
                BlockState state = launched instanceof LaunchedItem.ForBelt ? AllBlocks.SHAFT.defaultBlockState() : forBlockState.state;
                blocks.add(new LaunchedBlockRenderState(blockLocation, angle, 0.3f, state));
            } else if (launched instanceof LaunchedItem.ForEntity) {
                ItemStackRenderState item = new ItemStackRenderState();
                item.displayContext = ItemDisplayContext.GROUND;
                this.itemModelManager.appendItemLayers(item, launched.stack, item.displayContext, world, null, 0);
                blocks.add(new LaunchedEntityRenderState(blockLocation, angle, 1.2f, item));
            }
            if (launched.ticksRemaining != launched.totalTicks || !be.firstRenderTick) continue;
            start = start.subtract(0.5, 0.5, 0.5);
            be.firstRenderTick = false;
            RandomSource r = world.getRandom();
            for (int i = 0; i < 10; ++i) {
                double sX = cannonOffset.x * (double)0.01f;
                double sY = (cannonOffset.y + 1.0) * (double)0.01f;
                double sZ = cannonOffset.z * (double)0.01f;
                double rX = (double)r.nextFloat() - sX * 40.0;
                double rY = (double)r.nextFloat() - sY * 40.0;
                double rZ = (double)r.nextFloat() - sZ * 40.0;
                world.addParticle((ParticleOptions)ParticleTypes.CLOUD, start.x + rX, start.y + rY, start.z + rZ, sX, sY, sZ);
            }
        }
        if (blocks.isEmpty()) {
            return null;
        }
        return blocks;
    }

    public static double[] getCannonAngles(SchematicannonBlockEntity blockEntity, BlockPos pos, float partialTicks) {
        double pitch;
        double yaw;
        BlockPos target = blockEntity.printer.getCurrentTarget();
        if (target != null) {
            Vec3 diff = Vec3.atLowerCornerOf((Vec3i)target.subtract((Vec3i)pos));
            if (blockEntity.previousTarget != null) {
                diff = Vec3.atLowerCornerOf((Vec3i)blockEntity.previousTarget).add(Vec3.atLowerCornerOf((Vec3i)target.subtract((Vec3i)blockEntity.previousTarget)).scale((double)partialTicks)).subtract(Vec3.atLowerCornerOf((Vec3i)pos));
            }
            double diffX = diff.x();
            double diffZ = diff.z();
            yaw = Mth.atan2((double)diffX, (double)diffZ);
            yaw = yaw / Math.PI * 180.0;
            float distance = Mth.sqrt((float)((float)(diffX * diffX + diffZ * diffZ)));
            double yOffset = 0.0f + distance * 2.0f;
            pitch = Mth.atan2((double)distance, (double)(diff.y() * 3.0 + yOffset));
            pitch = pitch / Math.PI * 180.0 + 10.0;
        } else {
            yaw = blockEntity.defaultYaw;
            pitch = 40.0;
        }
        return new double[]{yaw, pitch};
    }

    public static double getRecoil(SchematicannonBlockEntity blockEntity, float partialTicks) {
        double recoil = 0.0;
        for (LaunchedItem launched : blockEntity.flyingBlocks) {
            if (launched.ticksRemaining == 0 || !((float)(launched.ticksRemaining + 1) - partialTicks > (float)(launched.totalTicks - 10))) continue;
            recoil = Math.max(recoil, (double)((float)(launched.ticksRemaining + 1) - partialTicks - (float)launched.totalTicks + 10.0f));
        }
        return recoil;
    }

    public boolean shouldRenderOffScreen() {
        return true;
    }

    public int getViewDistance() {
        return 128;
    }

    public static class SchematicannonRenderState
    extends BlockEntityRenderState {
        public List<LaunchedRenderState> blocks;
        public SchematicannonRenderData data;
    }

    public static class SchematicannonRenderData
    implements SubmitNodeCollector.CustomGeometryRenderer {
        public RenderType layer;
        public SuperByteBuffer connector;
        public float yaw;
        public SuperByteBuffer pipe;
        public float pitch;
        public float offset;
        public int light;

        public void render(PoseStack.Pose matricesEntry, VertexConsumer vertexConsumer) {
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.connector.translate(0.5f, 0.0f, 0.5f)).rotate(this.yaw, Direction.UP)).translate(-0.5f, 0.0f, -0.5f)).light(this.light).renderInto(matricesEntry, vertexConsumer);
            ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)this.pipe.translate(0.5f, 0.9375f, 0.5f)).rotate(this.yaw, Direction.UP)).rotate(this.pitch, Direction.SOUTH)).translate(-0.5f, -0.9375f, -0.5f)).translate(0.0f, this.offset, 0.0f)).light(this.light).renderInto(matricesEntry, vertexConsumer);
        }
    }

    public static abstract class LaunchedRenderState {
        public Vec3 offset;
        public float angle;
        public float scale;

        public LaunchedRenderState(Vec3 offset, float angle, float scale) {
            this.offset = offset;
            this.angle = angle;
            this.scale = scale;
        }

        public void render(PoseStack matrices, SubmitNodeCollector queue, int light) {
            matrices.pushPose();
            matrices.translate(this.offset);
            matrices.translate(0.125f, 0.125f, 0.125f);
            matrices.mulPose((Quaternionfc)Axis.YP.rotation(this.angle));
            matrices.mulPose((Quaternionfc)Axis.XP.rotation(this.angle));
            matrices.translate(-0.125f, -0.125f, -0.125f);
            matrices.scale(this.scale, this.scale, this.scale);
            this.submit(queue, matrices, light);
            matrices.popPose();
        }

        public abstract void submit(SubmitNodeCollector var1, PoseStack var2, int var3);
    }

    public static class LaunchedBlockRenderState
    extends LaunchedRenderState {
        public BlockState state;

        public LaunchedBlockRenderState(Vec3 offset, float angle, float scale, BlockState state) {
            super(offset, angle, scale);
            this.state = state;
        }

        @Override
        public void submit(SubmitNodeCollector queue, PoseStack matrices, int light) {
            queue.submitBlock(matrices, this.state, light, OverlayTexture.NO_OVERLAY, 0);
        }
    }

    public static class LaunchedEntityRenderState
    extends LaunchedRenderState {
        public ItemStackRenderState item;

        public LaunchedEntityRenderState(Vec3 offset, float angle, float scale, ItemStackRenderState item) {
            super(offset, angle, scale);
            this.item = item;
        }

        @Override
        public void submit(SubmitNodeCollector queue, PoseStack matrices, int light) {
            this.item.submit(matrices, queue, light, OverlayTexture.NO_OVERLAY, 0);
        }
    }
}

