/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.cannon;

import com.zurrtum.create.client.AllPartialModels;
import com.zurrtum.create.client.content.schematics.cannon.SchematicannonRenderer;
import com.zurrtum.create.client.flywheel.api.instance.Instance;
import com.zurrtum.create.client.flywheel.api.visual.DynamicVisual;
import com.zurrtum.create.client.flywheel.api.visualization.VisualizationContext;
import com.zurrtum.create.client.flywheel.lib.instance.InstanceTypes;
import com.zurrtum.create.client.flywheel.lib.instance.TransformedInstance;
import com.zurrtum.create.client.flywheel.lib.model.Models;
import com.zurrtum.create.client.flywheel.lib.visual.AbstractBlockEntityVisual;
import com.zurrtum.create.client.flywheel.lib.visual.SimpleDynamicVisual;
import com.zurrtum.create.content.schematics.cannon.SchematicannonBlockEntity;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;

public class SchematicannonVisual
extends AbstractBlockEntityVisual<SchematicannonBlockEntity>
implements SimpleDynamicVisual {
    private final TransformedInstance connector;
    private final TransformedInstance pipe;
    private double lastYaw = Double.NaN;
    private double lastPitch = Double.NaN;
    private double lastRecoil = Double.NaN;

    public SchematicannonVisual(VisualizationContext context, SchematicannonBlockEntity blockEntity, float partialTick) {
        super(context, blockEntity, partialTick);
        this.connector = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.SCHEMATICANNON_CONNECTOR)).createInstance();
        this.pipe = this.instancerProvider().instancer(InstanceTypes.TRANSFORMED, Models.partial(AllPartialModels.SCHEMATICANNON_PIPE)).createInstance();
        this.animate(partialTick);
    }

    @Override
    public void beginFrame(DynamicVisual.Context ctx) {
        this.animate(ctx.partialTick());
    }

    private void animate(float partialTicks) {
        double[] cannonAngles = SchematicannonRenderer.getCannonAngles((SchematicannonBlockEntity)this.blockEntity, this.pos, partialTicks);
        double yaw = cannonAngles[0];
        double pitch = cannonAngles[1];
        double recoil = SchematicannonRenderer.getRecoil((SchematicannonBlockEntity)this.blockEntity, partialTicks);
        if (yaw != this.lastYaw) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.connector.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).center()).rotate((float)((yaw + 90.0) / 180.0 * Math.PI), Direction.UP)).uncenter()).setChanged();
        }
        if (pitch != this.lastPitch || recoil != this.lastRecoil) {
            ((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)((TransformedInstance)this.pipe.setIdentityTransform().translate((Vec3i)this.getVisualPosition())).translate(0.5f, 0.9375f, 0.5f).rotate((float)((yaw + 90.0) / 180.0 * Math.PI), Direction.UP)).rotate((float)(pitch / 180.0 * Math.PI), Direction.SOUTH)).translateBack(0.5f, 0.9375f, 0.5f)).translate(0.0, -recoil / 100.0, 0.0)).setChanged();
        }
        this.lastYaw = yaw;
        this.lastPitch = pitch;
        this.lastRecoil = recoil;
    }

    @Override
    protected void _delete() {
        this.connector.delete();
        this.pipe.delete();
    }

    @Override
    public void updateLight(float partialTick) {
        this.relight(this.connector, this.pipe);
    }

    @Override
    public void collectCrumblingInstances(Consumer<Instance> consumer) {
        consumer.accept(this.connector);
        consumer.accept(this.pipe);
    }
}

