/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client;

import com.zurrtum.create.AllItems;
import com.zurrtum.create.client.Create;
import com.zurrtum.create.client.catnip.gui.AbstractSimiScreen;
import com.zurrtum.create.client.catnip.gui.element.GuiGameElement;
import com.zurrtum.create.client.catnip.gui.widget.ElementWidget;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.gui.widget.IconButton;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;

public class SchematicPromptScreen
extends AbstractSimiScreen {
    private final AllGuiTextures background;
    private final Component convertLabel = CreateLang.translateDirect("schematicAndQuill.convert", new Object[0]);
    private final Component abortLabel = CreateLang.translateDirect("action.discard", new Object[0]);
    private final Component confirmLabel = CreateLang.translateDirect("action.saveToFile", new Object[0]);
    private EditBox nameField;
    private IconButton confirm;
    private IconButton abort;
    private IconButton convert;
    private ElementWidget renderedItem;

    public SchematicPromptScreen() {
        super((Component)CreateLang.translateDirect("schematicAndQuill.title", new Object[0]));
        this.background = AllGuiTextures.SCHEMATIC_PROMPT;
    }

    @Override
    public void init() {
        this.setWindowSize(this.background.getWidth(), this.background.getHeight());
        super.init();
        int x = this.guiLeft;
        int y = this.guiTop + 2;
        this.nameField = new EditBox(this.font, x + 49, y + 26, 131, 10, CommonComponents.EMPTY);
        this.nameField.setTextColor(-1);
        this.nameField.setTextColorUneditable(-1);
        this.nameField.setBordered(false);
        this.nameField.setMaxLength(35);
        this.nameField.setFocused(true);
        this.setFocused((GuiEventListener)this.nameField);
        this.addRenderableWidget((GuiEventListener)this.nameField);
        this.abort = new IconButton(x + 7, y + 53, AllIcons.I_TRASH);
        this.abort.withCallback(() -> {
            Create.SCHEMATIC_AND_QUILL_HANDLER.discard(this.minecraft);
            this.onClose();
        });
        this.abort.setToolTip(this.abortLabel);
        this.addRenderableWidget(this.abort);
        this.confirm = new IconButton(x + 158, y + 53, AllIcons.I_CONFIRM);
        this.confirm.withCallback(() -> this.confirm(false));
        this.confirm.setToolTip(this.confirmLabel);
        this.addRenderableWidget(this.confirm);
        this.convert = new IconButton(x + 180, y + 53, AllIcons.I_SCHEMATIC);
        this.convert.withCallback(() -> this.confirm(true));
        this.convert.setToolTip(this.convertLabel);
        this.addRenderableWidget(this.convert);
        this.renderedItem = new ElementWidget(x + this.background.getWidth() + 6, this.guiTop + this.background.getHeight() - 38).showingElement(GuiGameElement.of(AllItems.SCHEMATIC_AND_QUILL.getDefaultInstance()).scale(3.0f));
        this.addRenderableWidget(this.renderedItem);
    }

    public void onClose() {
        super.onClose();
        this.renderedItem.getRenderElement().clear();
    }

    @Override
    protected void renderWindow(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        int x = this.guiLeft;
        int y = this.guiTop;
        this.background.render(graphics, x, y);
        graphics.drawString(this.font, this.title, x + (this.background.getWidth() - 8 - this.font.width((FormattedText)this.title)) / 2, y + 4, -11513776, false);
        graphics.renderItem(AllItems.SCHEMATIC.getDefaultInstance(), x + 22, y + 24);
    }

    @Override
    public boolean keyPressed(KeyEvent input) {
        int keyCode = input.key();
        if (keyCode == 257) {
            this.confirm(false);
            return true;
        }
        if (keyCode == 256 && this.shouldCloseOnEsc()) {
            this.onClose();
            return true;
        }
        return this.nameField.keyPressed(input);
    }

    private void confirm(boolean convertImmediately) {
        Create.SCHEMATIC_AND_QUILL_HANDLER.saveSchematic(this.minecraft, this.nameField.getValue(), convertImmediately);
        this.onClose();
    }
}

