/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client.tools;

import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.AABBOutline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.schematics.client.SchematicTransformation;
import com.zurrtum.create.client.content.schematics.client.tools.PlacementToolBase;
import com.zurrtum.create.client.flywheel.lib.transform.PoseTransformStack;
import com.zurrtum.create.client.flywheel.lib.transform.TransformStack;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class DeployTool
extends PlacementToolBase {
    @Override
    public void init() {
        super.init();
        this.selectionRange = -1;
    }

    @Override
    public void updateSelection(Minecraft mc) {
        if (this.schematicHandler.isActive() && this.selectionRange == -1) {
            this.selectionRange = (int)(this.schematicHandler.getBounds().getCenter().length() / 2.0);
            this.selectionRange = Mth.clamp((int)this.selectionRange, (int)1, (int)100);
        }
        this.selectIgnoreBlocks = InputConstants.isKeyDown((Window)mc.getWindow(), (int)341);
        super.updateSelection(mc);
    }

    @Override
    public void renderTool(Minecraft mc, PoseStack ms, SuperRenderTypeBuffer buffer, Vec3 camera) {
        super.renderTool(mc, ms, buffer, camera);
        if (this.selectedPos == null) {
            return;
        }
        ms.pushPose();
        float pt = AnimationTickHolder.getPartialTicks();
        double x = Mth.lerp((double)pt, (double)this.lastChasingSelectedPos.x, (double)this.chasingSelectedPos.x);
        double y = Mth.lerp((double)pt, (double)this.lastChasingSelectedPos.y, (double)this.chasingSelectedPos.y);
        double z = Mth.lerp((double)pt, (double)this.lastChasingSelectedPos.z, (double)this.chasingSelectedPos.z);
        SchematicTransformation transformation = this.schematicHandler.getTransformation();
        AABB bounds = this.schematicHandler.getBounds();
        Vec3 center = bounds.getCenter();
        Vec3 rotationOffset = transformation.getRotationOffset(true);
        int centerX = (int)center.x;
        int centerZ = (int)center.z;
        double xOrigin = bounds.getXsize() / 2.0;
        double zOrigin = bounds.getZsize() / 2.0;
        Vec3 origin = new Vec3(xOrigin, 0.0, zOrigin);
        ms.translate(x - (double)centerX - camera.x, y - camera.y, z - (double)centerZ - camera.z);
        ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of(ms).translate(origin)).translate(rotationOffset)).rotateYDegrees(transformation.getCurrentRotation())).translateBack(rotationOffset)).translateBack(origin);
        AABBOutline outline = this.schematicHandler.getOutline();
        outline.render(mc, ms, buffer, Vec3.ZERO, pt);
        outline.getParams().clearTextures();
        ms.popPose();
    }

    @Override
    public boolean handleMouseWheel(double delta) {
        if (!this.selectIgnoreBlocks) {
            return super.handleMouseWheel(delta);
        }
        this.selectionRange = (int)((double)this.selectionRange + delta);
        this.selectionRange = Mth.clamp((int)this.selectionRange, (int)1, (int)100);
        return true;
    }

    @Override
    public boolean handleRightClick(Minecraft mc) {
        if (this.selectedPos == null) {
            return super.handleRightClick(mc);
        }
        Vec3 center = this.schematicHandler.getBounds().getCenter();
        BlockPos target = this.selectedPos.offset(-((int)center.x), 0, -((int)center.z));
        ItemStack item = this.schematicHandler.getActiveSchematicItem();
        if (item != null) {
            item.set(AllDataComponents.SCHEMATIC_DEPLOYED, (Object)true);
            item.set(AllDataComponents.SCHEMATIC_ANCHOR, (Object)target);
            this.schematicHandler.getTransformation().startAt(target);
        }
        this.schematicHandler.getTransformation().moveTo(target);
        this.schematicHandler.markDirty();
        this.schematicHandler.deploy(mc);
        return true;
    }
}

