/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.client.AllSpecialTextures;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.AABBOutline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.schematics.client.tools.PlacementToolBase;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class FlipTool
extends PlacementToolBase {
    private final AABBOutline outline = new AABBOutline(new AABB(BlockPos.ZERO));

    @Override
    public void init() {
        super.init();
        this.renderSelectedFace = false;
    }

    @Override
    public boolean handleRightClick(Minecraft mc) {
        this.mirror();
        return true;
    }

    @Override
    public boolean handleMouseWheel(double delta) {
        this.mirror();
        return true;
    }

    @Override
    public void updateSelection(Minecraft mc) {
        super.updateSelection(mc);
    }

    private void mirror() {
        if (this.schematicSelected && this.selectedFace.getAxis().isHorizontal()) {
            this.schematicHandler.getTransformation().flip(this.selectedFace.getAxis());
            this.schematicHandler.markDirty();
        }
    }

    @Override
    public void renderOnSchematic(Minecraft mc, PoseStack ms, SuperRenderTypeBuffer buffer) {
        if (!this.schematicSelected || !this.selectedFace.getAxis().isHorizontal()) {
            super.renderOnSchematic(mc, ms, buffer);
            return;
        }
        Direction facing = this.selectedFace.getClockWise();
        AABB bounds = this.schematicHandler.getBounds();
        Vec3 directionVec = Vec3.atLowerCornerOf((Vec3i)Direction.get((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)facing.getAxis()).getUnitVec3i());
        Vec3 boundsSize = new Vec3(bounds.getXsize(), bounds.getYsize(), bounds.getZsize());
        Vec3 vec = boundsSize.multiply(directionVec);
        bounds = bounds.contract(vec.x, vec.y, vec.z).inflate(1.0 - directionVec.x, 1.0 - directionVec.y, 1.0 - directionVec.z);
        bounds = bounds.move(directionVec.scale(0.5).multiply(boundsSize));
        this.outline.setBounds(bounds);
        AllSpecialTextures tex = AllSpecialTextures.CHECKERED;
        this.outline.getParams().lineWidth(0.0625f).disableLineNormals().colored(0xDDDDDD).withFaceTextures(tex, tex);
        this.outline.render(mc, ms, buffer, Vec3.ZERO, AnimationTickHolder.getPartialTicks());
        super.renderOnSchematic(mc, ms, buffer);
    }
}

