/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client.tools;

import com.mojang.blaze3d.vertex.PoseStack;
import com.zurrtum.create.client.catnip.animation.AnimationTickHolder;
import com.zurrtum.create.client.catnip.outliner.LineOutline;
import com.zurrtum.create.client.catnip.render.SuperRenderTypeBuffer;
import com.zurrtum.create.client.content.schematics.client.tools.PlacementToolBase;
import net.minecraft.client.Minecraft;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class RotateTool
extends PlacementToolBase {
    private final LineOutline line = new LineOutline();

    @Override
    public boolean handleMouseWheel(double delta) {
        this.schematicHandler.getTransformation().rotate90(delta > 0.0);
        this.schematicHandler.markDirty();
        return true;
    }

    @Override
    public void renderOnSchematic(Minecraft mc, PoseStack ms, SuperRenderTypeBuffer buffer) {
        AABB bounds = this.schematicHandler.getBounds();
        double lengthY = bounds.getYsize();
        double height = lengthY + Math.max(20.0, lengthY);
        Vec3 center = bounds.getCenter().add(this.schematicHandler.getTransformation().getRotationOffset(false));
        Vec3 start = center.subtract(0.0, height / 2.0, 0.0);
        Vec3 end = center.add(0.0, height / 2.0, 0.0);
        this.line.getParams().disableCull().disableLineNormals().colored(0xDDDDDD).lineWidth(0.0625f);
        this.line.set(start, end).render(mc, ms, buffer, Vec3.ZERO, AnimationTickHolder.getPartialTicks());
        super.renderOnSchematic(mc, ms, buffer);
    }
}

