/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.content.schematics.client.tools;

import com.zurrtum.create.client.catnip.lang.Lang;
import com.zurrtum.create.client.content.schematics.client.tools.DeployTool;
import com.zurrtum.create.client.content.schematics.client.tools.FlipTool;
import com.zurrtum.create.client.content.schematics.client.tools.ISchematicTool;
import com.zurrtum.create.client.content.schematics.client.tools.MoveTool;
import com.zurrtum.create.client.content.schematics.client.tools.MoveVerticalTool;
import com.zurrtum.create.client.content.schematics.client.tools.PlaceTool;
import com.zurrtum.create.client.content.schematics.client.tools.RotateTool;
import com.zurrtum.create.client.foundation.gui.AllIcons;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public enum ToolType {
    DEPLOY(new DeployTool(), AllIcons.I_TOOL_DEPLOY),
    MOVE(new MoveTool(), AllIcons.I_TOOL_MOVE_XZ),
    MOVE_Y(new MoveVerticalTool(), AllIcons.I_TOOL_MOVE_Y),
    ROTATE(new RotateTool(), AllIcons.I_TOOL_ROTATE),
    FLIP(new FlipTool(), AllIcons.I_TOOL_MIRROR),
    PRINT(new PlaceTool(), AllIcons.I_CONFIRM);

    private final ISchematicTool tool;
    private final AllIcons icon;

    private ToolType(ISchematicTool tool, AllIcons icon) {
        this.tool = tool;
        this.icon = icon;
    }

    public ISchematicTool getTool() {
        return this.tool;
    }

    public MutableComponent getDisplayName() {
        return CreateLang.translateDirect("schematic.tool." + Lang.asId(this.name()), new Object[0]);
    }

    public AllIcons getIcon() {
        return this.icon;
    }

    public static List<ToolType> getTools(boolean creative) {
        ArrayList<ToolType> tools = new ArrayList<ToolType>();
        Collections.addAll(tools, MOVE, MOVE_Y, DEPLOY, ROTATE, FLIP);
        if (creative) {
            tools.add(PRINT);
        }
        return tools;
    }

    public List<Component> getDescription() {
        return CreateLang.translatedOptions("schematic.tool." + Lang.asId(this.name()) + ".description", "0", "1", "2", "3");
    }
}

